/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.util.PopupUtilsKt;
import java.util.Comparator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "vulnerabilities", "Lorg/jetbrains/security/VulnerablePackage;", "(Lorg/jetbrains/security/VulnerablePackage;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "startInWriteAction", "", "LinkListPopupStep", "intellij.packageChecker"})
public final class ShowVulnerabilityInfoFix
implements LocalQuickFix {
    @NotNull
    private final VulnerablePackage vulnerabilities;

    public ShowVulnerabilityInfoFix(@NotNull VulnerablePackage vulnerabilities) {
        Intrinsics.checkNotNullParameter((Object)vulnerabilities, (String)"vulnerabilities");
        this.vulnerabilities = vulnerabilities;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.vulnerabilities.getPkg().getHumanReadableCoordinates()};
        String string = PackageCheckerBundle.message("show.info.quickfix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PackageCheckerUsageStat.INSTANCE.getShowInfo().log(project);
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> ShowVulnerabilityInfoFix.applyFix$lambda$0((Function1)new Function1<DataContext, Unit>(this, project){
            final /* synthetic */ ShowVulnerabilityInfoFix this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(DataContext it) {
                ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new LinkListPopupStep(ShowVulnerabilityInfoFix.access$getVulnerabilities$p(this.this$0), this.$project));
                Intrinsics.checkNotNull((Object)it);
                listPopup.show(PopupUtilsKt.getBestPopupPosition((DataContext)it));
            }
        }, arg_0));
    }

    private static final void applyFix$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ VulnerablePackage access$getVulnerabilities$p(ShowVulnerabilityInfoFix $this) {
        return $this.vulnerabilities;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix$LinkListPopupStep;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "vulnerabilities", "Lorg/jetbrains/security/VulnerablePackage;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/security/VulnerablePackage;Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getIconFor", "Ljavax/swing/Icon;", "value", "getTextFor", "", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "", "intellij.packageChecker"})
    @SourceDebugExtension(value={"SMAP\nShowVulnerabilityInfoFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowVulnerabilityInfoFix.kt\ncom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix$LinkListPopupStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1054#2:65\n1#3:66\n*S KotlinDebug\n*F\n+ 1 ShowVulnerabilityInfoFix.kt\ncom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix$LinkListPopupStep\n*L\n40#1:65\n*E\n"})
    public static final class LinkListPopupStep
    extends BaseListPopupStep<Vulnerability> {
        @NotNull
        private final Project project;
        @NotNull
        private final Logger LOG;

        public LinkListPopupStep(@NotNull VulnerablePackage vulnerabilities, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)vulnerabilities, (String)"vulnerabilities");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object[] objectArray = new Object[]{vulnerabilities.getPkg().getHumanReadableCoordinates()};
            Iterable $this$sortedByDescending$iv = vulnerabilities.getVulnerabilities();
            boolean $i$f$sortedByDescending = false;
            super(PackageCheckerBundle.message("show.info.quickfix.title", objectArray), CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Vulnerability it = (Vulnerability)b;
                    boolean bl = false;
                    Comparable comparable = Float.valueOf(it.getCvssScore());
                    it = (Vulnerability)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getCvssScore()));
                }
            }));
            this.project = project;
            Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            this.LOG = logger;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable Vulnerability selectedValue, boolean finalChoice) {
            block2: {
                if (!finalChoice) break block2;
                PackageCheckerUsageStat.INSTANCE.getNavigateInfo().log(this.project);
                Object object = selectedValue;
                if (object != null && (object = ((Vulnerability)object).getReference()) != null) {
                    Object object2;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object2 : null;
                    if (object != null) {
                        it = object;
                        boolean bl2 = false;
                        BrowserUtil.browse((String)it);
                    }
                }
            }
            return super.onChosen((Object)selectedValue, finalChoice);
        }

        @NotNull
        public Icon getIconFor(@Nullable Vulnerability value) {
            Icon icon = AllIcons.Ide.External_link_arrow;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"External_link_arrow");
            return icon;
        }

        @NotNull
        public String getTextFor(@Nullable Vulnerability value) {
            if (value == null) {
                this.LOG.warn("Missed vulnerability");
                return "";
            }
            Object[] objectArray = new Object[]{value.getCve(), StringsKt.take((String)value.getTitle(), (int)145)};
            String string = PackageCheckerBundle.message("vulnerability.popup.step.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

