/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.dev.intmultimaps;

import java.util.Arrays;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class Int2IntMultimap {
    public static final int NO_VALUE = 0;
    private final float loadFactor;
    private int @NotNull [] table;
    private int aliveValues = 0;
    private int filledSlots = 0;

    public Int2IntMultimap() {
        this(16, 0.4f);
    }

    public Int2IntMultimap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = new int[capacity * 2];
        Arrays.fill(this.table, 0);
    }

    public boolean lookup(int key, IntPredicate valuesProcessor) {
        Int2IntMultimap.checkNotNoValue("key", key);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key) {
                assert (slotValue != 0) : "value(table[" + (slotIndex * 2 + 1) + "]) = " + 0 + " (NO_VALUE), while key(table[" + slotIndex * 2 + "]) = " + key;
                if (valuesProcessor.test(slotValue)) continue;
                return false;
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        return true;
    }

    public boolean has(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                return true;
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        return false;
    }

    public boolean put(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        int firstTombstoneIndex = -1;
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                return false;
            }
            if (slotKey != 0) continue;
            if (slotValue != 0) {
                if (firstTombstoneIndex != -1) continue;
                firstTombstoneIndex = slotIndex;
                continue;
            }
            int insertionIndex = firstTombstoneIndex >= 0 ? firstTombstoneIndex : slotIndex;
            this.table[insertionIndex * 2] = key;
            this.table[insertionIndex * 2 + 1] = value;
            ++this.aliveValues;
            break;
        }
        if ((float)this.aliveValues > (float)capacity * this.loadFactor) {
            Int2IntMultimap newMMap = new Int2IntMultimap(capacity * 2, this.loadFactor);
            this.forEach((_key, _value) -> {
                newMMap.put(_key, _value);
                return true;
            });
            this.table = newMMap.table;
            this.aliveValues = newMMap.aliveValues;
            this.filledSlots = newMMap.aliveValues;
        }
        return true;
    }

    public boolean remove(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                this.table[slotIndex * 2] = 0;
                --this.aliveValues;
                return true;
            }
            if (slotKey != 0 || slotValue != 0) continue;
            return false;
        }
        return false;
    }

    public boolean forEach(@NotNull KeyValueProcessor processor) {
        if (processor == null) {
            Int2IntMultimap.$$$reportNull$$$0(0);
        }
        for (int i2 = 0; i2 < this.table.length; i2 += 2) {
            int key = this.table[i2];
            int value = this.table[i2 + 1];
            if (key == 0) continue;
            assert (value != 0) : "value(table[" + (i2 + 1) + "]) = " + 0 + ", while key(table[" + i2 + "]) = " + key;
            if (processor.process(key, value)) continue;
            return false;
        }
        return true;
    }

    public int sizeInBytes() {
        return this.table.length * 4;
    }

    public int capacity() {
        return this.table.length / 2;
    }

    public int size() {
        return this.aliveValues;
    }

    public boolean replace(int key, int oldValue, int newValue) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("oldValue", oldValue);
        Int2IntMultimap.checkNotNoValue("newValue", newValue);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        int oldValueSlotIndex = -1;
        int newValueSlotIndex = -1;
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key) {
                if (slotValue == oldValue) {
                    oldValueSlotIndex = slotIndex;
                } else if (slotValue == newValue) {
                    newValueSlotIndex = slotIndex;
                }
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        if (oldValueSlotIndex != -1) {
            if (newValueSlotIndex != -1) {
                this.table[oldValueSlotIndex * 2] = 0;
                --this.aliveValues;
            } else {
                this.table[oldValueSlotIndex * 2 + 1] = newValue;
            }
            return true;
        }
        return false;
    }

    private static void checkNotNoValue(String paramName, int value) {
        if (value == 0) {
            throw new IllegalArgumentException(paramName + " can't be = " + 0 + " -- it is special value used as NO_VALUE");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/io/dev/intmultimaps/Int2IntMultimap", "forEach"));
    }

    @FunctionalInterface
    public static interface KeyValueProcessor {
        public boolean process(int var1, int var2);
    }
}

