/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.dev.mmapped;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MMappedFileStorage
implements Closeable,
Unmappable,
CleanableStorage {
    static final Logger LOG = Logger.getInstance(MMappedFileStorage.class);
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, 1000L);
    public static final boolean FSYNC_ON_FLUSH_BY_DEFAULT = SystemProperties.getBooleanProperty("MMappedFileStorage.FSYNC_BY_DEFAULT_ON_FLUSH", false);
    private static final String UNMAP_ON_CLOSE_KIND = System.getProperty("MMappedFileStorage.UNMAP_ON_CLOSE", "never");
    private static final boolean UNMAP_ON_CLOSE_BY_DEFAULT = "always".equals(UNMAP_ON_CLOSE_KIND) || "on-windows".equals(UNMAP_ON_CLOSE_KIND) && SystemInfoRt.isWindows;
    private static final boolean FAIL_ON_FAILED_UNMAP = SystemProperties.getBooleanProperty("idea.fs.fail-if-unmap-failed", true);
    private static final boolean LOG_UNMAP_OPERATIONS = SystemProperties.getBooleanProperty("MMappedFileStorage.LOG_UNMAP_OPERATIONS", false);
    private static final boolean CRASH_TOLERANT_EXPANSION = SystemProperties.getBooleanProperty("MMappedFileStorage.CRASH_TOLERANT_EXPANSION", true);
    private static final boolean WARN_OF_DELETED_STORAGES_USE = SystemProperties.getBooleanProperty("MMappedFileStorage.WARN_OF_DELETED_STORAGES_USE", true);
    private static final int PAGES_TO_WARN_THRESHOLD = SystemProperties.getIntProperty("vfs.memory-mapped-storage.pages-to-warn-threshold", 512);
    private static volatile int openedStoragesCount = 0;
    private static final AtomicInteger totalPagesMapped = new AtomicInteger();
    private static final AtomicLong totalBytesMapped = new AtomicLong();
    private static final AtomicLong totalTimeForPageMapNs = new AtomicLong();
    private static final Map<Path, MMappedFileStorage> openedStorages = new HashMap<Path, MMappedFileStorage>();
    private final Path storagePath;
    private final int pageSize;
    private final int pageSizeMask;
    private final int pageSizeBits;
    private final FileChannel channel;
    private final transient Object pagesLock;
    private Page[] pages;
    private final RegionAllocationAtomicityLock regionAllocationAtomicityLock;

    MMappedFileStorage(@NotNull Path path, int pageSize, @NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock) throws IOException {
        if (path == null) {
            MMappedFileStorage.$$$reportNull$$$0(0);
        }
        if (regionAllocationAtomicityLock == null) {
            MMappedFileStorage.$$$reportNull$$$0(1);
        }
        this(path, pageSize, 0, regionAllocationAtomicityLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MMappedFileStorage(Path path, int pageSize, int pagesCountToMapInitially, @NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock) throws IOException {
        Path absolutePath;
        if (regionAllocationAtomicityLock == null) {
            MMappedFileStorage.$$$reportNull$$$0(2);
        }
        this.pagesLock = new Object();
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be >0");
        }
        if (Integer.bitCount(pageSize) != 1) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be a power of 2");
        }
        if (pagesCountToMapInitially < 0) {
            throw new IllegalArgumentException("pagesCountToMapInitially(=" + pagesCountToMapInitially + ") must be >= 0");
        }
        this.pageSizeBits = Integer.numberOfTrailingZeros(pageSize);
        this.pageSizeMask = pageSize - 1;
        this.pageSize = pageSize;
        this.storagePath = absolutePath = path.toAbsolutePath();
        this.regionAllocationAtomicityLock = regionAllocationAtomicityLock;
        Map<Path, MMappedFileStorage> map2 = openedStorages;
        synchronized (map2) {
            MMappedFileStorage alreadyExistingStorage = openedStorages.get(absolutePath);
            if (alreadyExistingStorage != null) {
                throw new IllegalStateException("Storage[" + absolutePath + "] is already opened (and not yet closed) -- can't open same file more than once");
            }
            this.channel = FileChannel.open(this.storagePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            this.pages = new Page[pagesCountToMapInitially];
            for (int i2 = 0; i2 < pagesCountToMapInitially; ++i2) {
                this.pageByIndex(i2);
            }
            openedStorages.put(absolutePath, this);
            ++openedStoragesCount;
        }
    }

    public Path storagePath() {
        return this.storagePath;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long actualFileSize() throws IOException {
        Object object = this.pagesLock;
        synchronized (object) {
            long channelSize = this.channel.size();
            if ((channelSize & (long)this.pageSizeMask) != 0L) {
                throw new AssertionError((Object)("Bug: [" + this.storagePath + "].channelSize(=" + channelSize + ") is not pageSize(=" + this.pageSize + ")-aligned"));
            }
            return channelSize;
        }
    }

    @NotNull
    public Page pageByOffset(long offsetInFile) throws IOException {
        int pageIndex = this.pageIndexByOffset(offsetInFile);
        Page page = this.pageByIndex(pageIndex);
        if (page == null) {
            MMappedFileStorage.$$$reportNull$$$0(3);
        }
        return page;
    }

    @NotNull
    public Page pageByIndex(int pageIndex) throws IOException {
        Page page = MMappedFileStorage.pageOrNull(this.pages, pageIndex);
        if (page == null) {
            page = this.pageByIndexLocked(pageIndex);
        }
        Page page2 = page;
        if (page2 == null) {
            MMappedFileStorage.$$$reportNull$$$0(4);
        }
        return page2;
    }

    public int pageIndexByOffset(long offsetInFile) {
        if (offsetInFile < 0L) {
            throw new IllegalArgumentException("offsetInFile(=" + offsetInFile + ") must be >=0");
        }
        return (int)(offsetInFile >> this.pageSizeBits);
    }

    public int toOffsetInPage(long offsetInFile) {
        return (int)(offsetInFile & (long)this.pageSizeMask);
    }

    @Override
    public void close() throws IOException {
        this.close(UNMAP_ON_CLOSE_BY_DEFAULT);
    }

    @Override
    public void closeAndUnsafelyUnmap() throws IOException {
        this.close(true);
    }

    public void fsync() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.force(true);
        }
    }

    @Override
    public void closeAndClean() throws IOException {
        this.closeAndUnsafelyUnmap();
        FileUtil.delete(this.storagePath);
    }

    public void zeroizeRegion(long startOffsetInFile, long endOffsetInFile) throws IOException {
        int startOffsetInPage;
        int endOffsetInPage;
        if (startOffsetInFile < 0L) {
            throw new IllegalArgumentException("startOffsetInFile(=" + startOffsetInFile + ") must be >=0");
        }
        if (endOffsetInFile < 0L) {
            throw new IllegalArgumentException("endOffsetInFile(=" + endOffsetInFile + ") must be >=0");
        }
        for (long offset = startOffsetInFile; offset <= endOffsetInFile; offset += (long)(endOffsetInPage - startOffsetInPage + 1)) {
            Page page = this.pageByOffset(offset);
            ByteBuffer pageBuffer = page.rawPageBuffer();
            startOffsetInPage = this.toOffsetInPage(offset);
            endOffsetInPage = endOffsetInFile > page.lastOffsetInFile() ? this.pageSize - 1 : this.toOffsetInPage(endOffsetInFile);
            for (int pos = startOffsetInPage; pos <= endOffsetInPage; ++pos) {
                pageBuffer.put(pos, (byte)0);
            }
        }
    }

    public void zeroizeTillEOF(long startOffsetInFile) throws IOException {
        long actualFileSize = this.actualFileSize();
        if (actualFileSize == 0L) {
            return;
        }
        this.zeroizeRegion(startOffsetInFile, actualFileSize - 1L);
    }

    public String toString() {
        return "MMappedFileStorage[" + this.storagePath + "][" + this.pages.length + " pages of " + this.pageSize + "b]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean unmap) throws IOException {
        Map<Path, MMappedFileStorage> map2;
        boolean actuallyClosed = false;
        try {
            map2 = this.pagesLock;
            synchronized (map2) {
                if (this.channel.isOpen()) {
                    this.channel.close();
                    for (Page page : this.pages) {
                        if (page == null) continue;
                        MMappedFileStorage.unregisterMappedPage(this.pageSize);
                    }
                    actuallyClosed = true;
                }
                if (unmap) {
                    try {
                        for (Page page : this.pages) {
                            if (page == null) continue;
                            page.unmap();
                        }
                    }
                    finally {
                        Arrays.fill(this.pages, null);
                    }
                }
            }
        }
        finally {
            map2 = openedStorages;
            synchronized (map2) {
                MMappedFileStorage removed = openedStorages.get(this.storagePath);
                if (removed == this) {
                    openedStorages.remove(this.storagePath);
                    --openedStoragesCount;
                }
            }
        }
        if (actuallyClosed && WARN_OF_DELETED_STORAGES_USE) {
            Path parent = this.storagePath.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                LOG.warn("Storage parent dir[" + parent.toAbsolutePath() + "] is not exist: storage files were removed while wasn't yet closed!");
            } else if (!Files.exists(this.storagePath, new LinkOption[0])) {
                LOG.warn("Storage[" + this.storagePath.toAbsolutePath() + "] is not exist: storage file was removed while wasn't yet closed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page pageByIndexLocked(int pageIndex) throws IOException {
        Object object = this.pagesLock;
        synchronized (object) {
            Page page;
            if (!this.channel.isOpen()) {
                throw new ClosedStorageException("Storage already closed");
            }
            if (pageIndex >= this.pages.length) {
                this.pages = Arrays.copyOf(this.pages, pageIndex + 1);
            }
            if ((page = this.pages[pageIndex]) == null) {
                this.pages[pageIndex] = page = new Page(this.regionAllocationAtomicityLock, pageIndex, this.channel, this.pageSize, this.byteOrder());
                MMappedFileStorage.registerMappedPage(this.pageSize);
            }
            return page;
        }
    }

    @Nullable
    private static Page pageOrNull(Page[] pages, int pageIndex) {
        if (0 <= pageIndex && pageIndex < pages.length) {
            return pages[pageIndex];
        }
        return null;
    }

    public static int openedStoragesCount() {
        return openedStoragesCount;
    }

    public static int totalPagesMapped() {
        return totalPagesMapped.get();
    }

    public static long totalBytesMapped() {
        return totalBytesMapped.get();
    }

    public static long totalTimeForPageMap(@NotNull TimeUnit unit) {
        if (unit == null) {
            MMappedFileStorage.$$$reportNull$$$0(5);
        }
        return unit.convert(totalTimeForPageMapNs.get(), TimeUnit.NANOSECONDS);
    }

    private static void registerMappedPage(int pageSize) {
        int pagesMapped = totalPagesMapped.incrementAndGet();
        totalBytesMapped.addAndGet(pageSize);
        if (pagesMapped > PAGES_TO_WARN_THRESHOLD) {
            THROTTLED_LOG.warn("Too many pages were mapped: " + pagesMapped + " > " + PAGES_TO_WARN_THRESHOLD + " threshold. Total mapped size: " + totalBytesMapped.get() + " bytes, storages: " + openedStoragesCount);
        }
    }

    private static void unregisterMappedPage(int pageSize) {
        totalPagesMapped.decrementAndGet();
        totalBytesMapped.addAndGet(-pageSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regionAllocationAtomicityLock";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/dev/mmapped/MMappedFileStorage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/dev/mmapped/MMappedFileStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByIndex";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "totalTimeForPageMap";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RegionAllocationAtomicityLock {
        public Region region(long var1, int var3) throws IOException;

        public static RegionAllocationAtomicityLock defaultLock(@NotNull Path mainStorageFile) {
            if (mainStorageFile == null) {
                RegionAllocationAtomicityLock.$$$reportNull$$$0(0);
            }
            if (CRASH_TOLERANT_EXPANSION) {
                return new FileBasedRegionAllocationLock(mainStorageFile);
            }
            return new NoLock();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainStorageFile", "com/intellij/util/io/dev/mmapped/MMappedFileStorage$RegionAllocationAtomicityLock", "defaultLock"));
        }

        public static class FileBasedRegionAllocationLock
        implements RegionAllocationAtomicityLock {
            private final Path mainStoragePath;

            public FileBasedRegionAllocationLock(@NotNull Path mainStoragePath) {
                if (mainStoragePath == null) {
                    FileBasedRegionAllocationLock.$$$reportNull$$$0(0);
                }
                this.mainStoragePath = mainStoragePath;
            }

            @Override
            public Region region(long regionStartOffset, int pageSize) throws IOException {
                Path mappingLockFile = this.mainStoragePath.resolveSibling("." + this.mainStoragePath.getFileName() + "." + regionStartOffset + ".lock");
                return new RegionImpl(mappingLockFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainStoragePath", "com/intellij/util/io/dev/mmapped/MMappedFileStorage$RegionAllocationAtomicityLock$FileBasedRegionAllocationLock", "<init>"));
            }

            private static final class RegionImpl
            implements Region {
                private final Path mappingLockFile;

                private RegionImpl(@NotNull Path mappingLockFile) {
                    if (mappingLockFile == null) {
                        RegionImpl.$$$reportNull$$$0(0);
                    }
                    this.mappingLockFile = mappingLockFile;
                }

                @Override
                public void start() throws IOException {
                    try {
                        Files.createFile(this.mappingLockFile, new FileAttribute[0]);
                    }
                    catch (NoSuchFileException e2) {
                        Path parent = this.mappingLockFile.getParent();
                        if (!Files.exists(parent, new LinkOption[0])) {
                            throw new IOException("Parent dir[" + parent.toAbsolutePath() + "] is not exist/was removed -- can't create .lock-file", e2);
                        }
                        throw new IOException("Can't create .lock-file for unknown reasons", e2);
                    }
                    catch (FileAlreadyExistsException e3) {
                        throw new IOException("lock-file[" + this.mappingLockFile + "] already created -- concurrent access?", e3);
                    }
                }

                @Override
                public boolean isUnfinished() {
                    return Files.exists(this.mappingLockFile, new LinkOption[0]);
                }

                @Override
                public void finish() throws IOException {
                    Files.delete(this.mappingLockFile);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappingLockFile", "com/intellij/util/io/dev/mmapped/MMappedFileStorage$RegionAllocationAtomicityLock$FileBasedRegionAllocationLock$RegionImpl", "<init>"));
                }
            }
        }

        public static class NoLock
        implements RegionAllocationAtomicityLock {
            @Override
            public Region region(long regionStartOffset, int pageSize) throws IOException {
                return new Region(){

                    @Override
                    public boolean isUnfinished() {
                        return false;
                    }

                    @Override
                    public void start() throws IOException {
                    }

                    @Override
                    public void finish() throws IOException {
                    }
                };
            }
        }

        public static interface Region {
            public boolean isUnfinished();

            public void start() throws IOException;

            public void finish() throws IOException;
        }
    }

    public static final class Page {
        private final int pageIndex;
        private final int pageSize;
        private final long offsetInFile;
        private final ByteBuffer pageBuffer;
        private static final Method INVOKE_CLEANER_METHOD;

        private Page(@NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock, int pageIndex, @NotNull FileChannel channel, int pageSize, @NotNull ByteOrder byteOrder) throws IOException {
            if (regionAllocationAtomicityLock == null) {
                Page.$$$reportNull$$$0(0);
            }
            if (channel == null) {
                Page.$$$reportNull$$$0(1);
            }
            if (byteOrder == null) {
                Page.$$$reportNull$$$0(2);
            }
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
            this.offsetInFile = (long)pageIndex * (long)pageSize;
            this.pageBuffer = this.map(regionAllocationAtomicityLock, channel, pageSize).order(byteOrder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MappedByteBuffer map(@NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock, @NotNull FileChannel channel, int pageSize) throws IOException {
            if (regionAllocationAtomicityLock == null) {
                Page.$$$reportNull$$$0(3);
            }
            if (channel == null) {
                Page.$$$reportNull$$$0(4);
            }
            long startedAtNs = System.nanoTime();
            try {
                this.ensureFileRegionAllocatedAndZeroed(regionAllocationAtomicityLock, channel, pageSize);
                MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, this.offsetInFile, pageSize);
                return mappedByteBuffer;
            }
            finally {
                long timeSpentNs = System.nanoTime() - startedAtNs;
                totalTimeForPageMapNs.addAndGet(timeSpentNs);
            }
        }

        private void ensureFileRegionAllocatedAndZeroed(@NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock, @NotNull FileChannel channel, int pageSize) throws IOException {
            RegionAllocationAtomicityLock.Region region;
            if (regionAllocationAtomicityLock == null) {
                Page.$$$reportNull$$$0(5);
            }
            if (channel == null) {
                Page.$$$reportNull$$$0(6);
            }
            if ((region = regionAllocationAtomicityLock.region(this.offsetInFile, pageSize)).isUnfinished()) {
                LOG.warn("mmapped file region [" + this.offsetInFile + ".. +" + pageSize + "] allocation & zeroing has been started, but hasn't been properly finished -- IDE was crashed/killed? -- try finishing the job");
                IOUtil.fillFileRegionWithZeros(channel, this.offsetInFile, this.offsetInFile + (long)pageSize);
            } else {
                region.start();
                IOUtil.allocateFileRegion(channel, this.offsetInFile + (long)pageSize);
            }
            region.finish();
        }

        private void unmap() throws IOException {
            try {
                Page.unmapBuffer(this.pageBuffer);
            }
            catch (Throwable t2) {
                if (FAIL_ON_FAILED_UNMAP) {
                    throw new IOException("Can't unmap pageBuffer", t2);
                }
                THROTTLED_LOG.warn("Can't unmap pageBuffer explicitly -- rely on GC to do it eventually", t2);
            }
        }

        public ByteBuffer rawPageBuffer() {
            return this.pageBuffer;
        }

        public long firstOffsetInFile() {
            return this.offsetInFile;
        }

        public long lastOffsetInFile() {
            return this.offsetInFile + (long)this.pageSize - 1L;
        }

        public String toString() {
            return "Page[#" + this.pageIndex + "][offset: " + this.offsetInFile + ", length: " + this.pageBuffer.capacity() + " b)";
        }

        public static void unmapBuffer(@NotNull ByteBuffer buffer) throws Exception {
            if (buffer == null) {
                Page.$$$reportNull$$$0(7);
            }
            if (!buffer.isDirect()) {
                return;
            }
            if (INVOKE_CLEANER_METHOD == null) {
                throw new IllegalStateException("No access to Unsafe.invokeCleaner() -- explicit mapped buffers unmapping is unavailable");
            }
            INVOKE_CLEANER_METHOD.invoke(ReflectionUtil.getUnsafe(), buffer);
            if (LOG_UNMAP_OPERATIONS) {
                LOG.info("Buffer unmapped: " + buffer);
            }
        }

        static {
            Method cleanerMethod;
            try {
                Object unsafe = ReflectionUtil.getUnsafe();
                Class<?> unsafeClass = unsafe.getClass();
                cleanerMethod = ReflectionUtil.getDeclaredMethod(unsafeClass, "invokeCleaner", ByteBuffer.class);
            }
            catch (Throwable t2) {
                LOG.error("Can't get access to Unsafe.invokeCleaner() -- explicit mapped buffers unmapping will be unavailable", t2);
                cleanerMethod = null;
            }
            INVOKE_CLEANER_METHOD = cleanerMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regionAllocationAtomicityLock";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "channel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "byteOrder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/io/dev/mmapped/MMappedFileStorage$Page";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ensureFileRegionAllocatedAndZeroed";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unmapBuffer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

