/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.toolwindow.ReviewTabViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.GitLabProjectsManager;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabProject;
import org.jetbrains.plugins.gitlab.mergerequest.ui.create.model.GitLabMergeRequestCreateViewModelImpl;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.model.GitLabMergeRequestDetailsLoadingViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.model.GitLabMergeRequestDetailsLoadingViewModelImpl;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.model.GitLabMergeRequestDetailsViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;
import org.jetbrains.plugins.gitlab.util.GitLabProjectPath;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel;", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabViewModel;", "CreateMergeRequest", "Details", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$CreateMergeRequest;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$Details;", "intellij.vcs.gitlab"})
public interface GitLabReviewTabViewModel
extends ReviewTabViewModel {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002Bt\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00121\u0010\u000e\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u000f\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\u0010\u0019J\b\u0010#\u001a\u00020\u0015H\u0016R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$CreateMergeRequest;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "projectsManager", "Lorg/jetbrains/plugins/gitlab/GitLabProjectsManager;", "projectData", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;", "avatarIconProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "openReviewTabAction", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "mrIid", "Lkotlin/coroutines/Continuation;", "", "", "onReviewCreated", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/GitLabProjectsManager;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "createVm", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/create/model/GitLabMergeRequestCreateViewModelImpl;", "getCreateVm", "()Lorg/jetbrains/plugins/gitlab/mergerequest/ui/create/model/GitLabMergeRequestCreateViewModelImpl;", "cs", "displayName", "getDisplayName", "()Ljava/lang/String;", "projectPath", "dispose", "intellij.vcs.gitlab"})
    public static final class CreateMergeRequest
    implements GitLabReviewTabViewModel,
    Disposable {
        @NotNull
        private final CoroutineScope cs;
        @NotNull
        private final String projectPath;
        @NotNull
        private final String displayName;
        @NotNull
        private final GitLabMergeRequestCreateViewModelImpl createVm;

        public CreateMergeRequest(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GitLabProjectsManager projectsManager, @NotNull GitLabProject projectData, @NotNull IconsProvider<GitLabUserDTO> avatarIconProvider, @NotNull Function2<? super String, ? super Continuation<? super Unit>, ? extends Object> openReviewTabAction, @NotNull Function0<Unit> onReviewCreated) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
            Intrinsics.checkNotNullParameter((Object)projectsManager, (String)"projectsManager");
            Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
            Intrinsics.checkNotNullParameter(avatarIconProvider, (String)"avatarIconProvider");
            Intrinsics.checkNotNullParameter(openReviewTabAction, (String)"openReviewTabAction");
            Intrinsics.checkNotNullParameter(onReviewCreated, (String)"onReviewCreated");
            this.cs = CoroutineUtilKt.cancelledWith((CoroutineScope)CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, null, (boolean)false, (int)3, null), (Disposable)this);
            this.projectPath = GitLabProjectPath.fullPath$default(projectData.getProjectMapping().getRepository().getProjectPath(), false, 1, null);
            Object[] objectArray = new Object[]{this.projectPath};
            this.displayName = GitLabBundle.message("merge.request.create.tab.title", objectArray);
            this.createVm = new GitLabMergeRequestCreateViewModelImpl(project, this.cs, projectsManager, projectData, avatarIconProvider, openReviewTabAction, onReviewCreated);
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final GitLabMergeRequestCreateViewModelImpl getCreateVm() {
            return this.createVm;
        }

        public void dispose() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$Details;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel;", "Lcom/intellij/openapi/Disposable;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "reviewId", "", "detailsVm", "Lkotlinx/coroutines/flow/Flow;", "Lkotlin/Result;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestDetailsViewModel;", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Lkotlinx/coroutines/flow/Flow;)V", "cs", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestDetailsLoadingViewModel;", "getDetailsVm", "()Lorg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestDetailsLoadingViewModel;", "displayName", "Lcom/intellij/openapi/util/NlsSafe;", "getDisplayName", "()Ljava/lang/String;", "dispose", "", "intellij.vcs.gitlab"})
    public static final class Details
    implements GitLabReviewTabViewModel,
    Disposable {
        @NotNull
        private final CoroutineScope cs;
        @NotNull
        private final String displayName;
        @NotNull
        private final GitLabMergeRequestDetailsLoadingViewModel detailsVm;

        public Details(@NotNull CoroutineScope parentCs, @NotNull String reviewId, @NotNull Flow<? extends Result<? extends GitLabMergeRequestDetailsViewModel>> detailsVm) {
            Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
            Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
            Intrinsics.checkNotNullParameter(detailsVm, (String)"detailsVm");
            this.cs = CoroutineUtilKt.cancelledWith((CoroutineScope)CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, null, (boolean)false, (int)3, null), (Disposable)this);
            this.displayName = "!" + reviewId;
            this.detailsVm = new GitLabMergeRequestDetailsLoadingViewModelImpl(this.cs, reviewId, detailsVm);
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final GitLabMergeRequestDetailsLoadingViewModel getDetailsVm() {
            return this.detailsVm;
        }

        public void dispose() {
        }
    }
}

