/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractIterableSizeAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectEnumerableAssert;
import org.assertj.core.api.RecursiveAssertionAssert;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.filter.FilterOperator;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionConfiguration;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.description.Description;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.ConfigurableRecursiveFieldByFieldComparator;
import org.assertj.core.internal.ExtendedByTypesComparator;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.IterableElementComparisonStrategy;
import org.assertj.core.internal.Iterables;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;

public abstract class AbstractIterableAssert<SELF extends AbstractIterableAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractAssert<SELF, ACTUAL>
implements ObjectEnumerableAssert<SELF, ELEMENT> {
    private static final String ASSERT = "Assert";
    private TypeComparators comparatorsByType;
    private Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames = new TreeMap();
    private TypeComparators comparatorsForElementPropertyOrFieldTypes;
    protected Iterables iterables = Iterables.instance();

    protected AbstractIterableAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
        SortedSet sortedSet;
        Comparator comparator;
        if (actual instanceof SortedSet && (comparator = (sortedSet = (SortedSet)actual).comparator()) != null) {
            this.usingElementComparator(sortedSet.comparator());
        }
    }

    @Override
    public void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int boundary) {
        this.iterables.assertHasSizeGreaterThan(this.info, (Iterable)this.actual, boundary);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.iterables.assertHasSizeGreaterThanOrEqualTo(this.info, (Iterable)this.actual, boundary);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int boundary) {
        this.iterables.assertHasSizeLessThan(this.info, (Iterable)this.actual, boundary);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.iterables.assertHasSizeLessThanOrEqualTo(this.info, (Iterable)this.actual, boundary);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.iterables.assertHasSizeBetween(this.info, (Iterable)this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @Deprecated
    public SELF hasOnlyOneElementSatisfying(Consumer<? super ELEMENT> elementAssertions) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, 1);
        elementAssertions.accept(((Iterable)this.actual).iterator().next());
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF contains(ELEMENT ... values) {
        return this.containsForProxy(values);
    }

    protected SELF containsForProxy(ELEMENT[] values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF containsOnly(ELEMENT ... values) {
        return this.containsOnlyForProxy(values);
    }

    protected SELF containsOnlyForProxy(ELEMENT[] values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF containsOnlyOnce(ELEMENT ... values) {
        return this.containsOnlyOnceForProxy(values);
    }

    protected SELF containsOnlyOnceForProxy(ELEMENT[] values) {
        this.iterables.assertContainsOnlyOnce(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsOnlyNulls() {
        this.iterables.assertContainsOnlyNulls(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF containsExactly(ELEMENT ... values) {
        return this.containsExactlyForProxy(values);
    }

    protected SELF containsExactlyForProxy(ELEMENT[] values) {
        this.iterables.assertContainsExactly(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF containsExactlyInAnyOrder(ELEMENT ... values) {
        return this.containsExactlyInAnyOrderForProxy(values);
    }

    protected SELF containsExactlyInAnyOrderForProxy(ELEMENT[] values) {
        this.iterables.assertContainsExactlyInAnyOrder(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrderElementsOf(Iterable<? extends ELEMENT> values) {
        return (SELF)this.containsExactlyInAnyOrder((Object[])IterableUtil.toArray(values));
    }

    @Override
    public SELF isSubsetOf(Iterable<? extends ELEMENT> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF isSubsetOf(ELEMENT ... values) {
        return this.isSubsetOfForProxy(values);
    }

    protected SELF isSubsetOfForProxy(ELEMENT[] values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, java.util.Arrays.asList(values));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF containsSequence(ELEMENT ... sequence) {
        return this.containsSequenceForProxy(sequence);
    }

    protected SELF containsSequenceForProxy(ELEMENT[] sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF doesNotContainSequence(ELEMENT ... sequence) {
        return this.doesNotContainSequenceForProxy(sequence);
    }

    protected SELF doesNotContainSequenceForProxy(ELEMENT[] sequence) {
        this.iterables.assertDoesNotContainSequence(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSequence(Iterable<? extends ELEMENT> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.iterables.assertDoesNotContainSequence(this.info, (Iterable)this.actual, IterableUtil.toArray(sequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF containsSubsequence(ELEMENT ... subsequence) {
        return this.containsSubsequenceForProxy(subsequence);
    }

    protected SELF containsSubsequenceForProxy(ELEMENT[] subsequence) {
        this.iterables.assertContainsSubsequence(this.info, (Iterable)this.actual, subsequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.iterables.assertContainsSubsequence(this.info, (Iterable)this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF doesNotContainSubsequence(ELEMENT ... subsequence) {
        return this.doesNotContainSubsequenceForProxy(subsequence);
    }

    protected SELF doesNotContainSubsequenceForProxy(ELEMENT[] subsequence) {
        this.iterables.assertDoesNotContainSubsequence(this.info, (Iterable)this.actual, subsequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainSubsequence(Iterable<? extends ELEMENT> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.iterables.assertDoesNotContainSubsequence(this.info, (Iterable)this.actual, IterableUtil.toArray(subsequence));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF doesNotContain(ELEMENT ... values) {
        return this.doesNotContainForProxy(values);
    }

    protected SELF doesNotContainForProxy(ELEMENT[] values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainAnyElementsOf(Iterable<? extends ELEMENT> iterable) {
        this.iterables.assertDoesNotContainAnyElementsOf(this.info, (Iterable)this.actual, iterable);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF startsWith(ELEMENT ... sequence) {
        return this.startsWithForProxy(sequence);
    }

    protected SELF startsWithForProxy(ELEMENT[] sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF endsWith(ELEMENT first, ELEMENT ... rest) {
        return this.endsWithForProxy(first, rest);
    }

    protected SELF endsWithForProxy(ELEMENT first, ELEMENT[] rest) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, first, rest);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT[] sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF are(Condition<? super ELEMENT> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areNot(Condition<? super ELEMENT> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF have(Condition<? super ELEMENT> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doNotHave(Condition<? super ELEMENT> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtLeastOne(Condition<? super ELEMENT> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtMost(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areExactly(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveAtLeastOne(Condition<? super ELEMENT> condition) {
        return (SELF)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public SELF haveAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveAtMost(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveExactly(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasAtLeastOneElementOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasAtLeastOneElementOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasOnlyElementsOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveAnyElementsOfTypes(Class<?> ... unexpectedTypes) {
        ObjectArrays.instance().assertDoesNotHaveAnyElementsOfTypes(this.info, IterableUtil.toArray((Iterable)this.actual), unexpectedTypes);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfTypes(Class<?> ... types) {
        ObjectArrays.instance().assertHasOnlyElementsOfTypes(this.info, IterableUtil.toArray((Iterable)this.actual), types);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasExactlyElementsOfTypes(Class<?> ... types) {
        ObjectArrays.instance().assertHasExactlyElementsOfTypes(this.info, IterableUtil.toArray((Iterable)this.actual), types);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsAll(Iterable<? extends ELEMENT> iterable) {
        this.iterables.assertContainsAll(this.info, (Iterable)this.actual, iterable);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super ELEMENT> elementComparator) {
        this.iterables = new Iterables(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new IterableElementComparisonStrategy<ELEMENT>(elementComparator));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @CheckReturnValue
    private SELF usingExtendedByTypesElementComparator(Comparator<Object> elementComparator) {
        return (SELF)this.usingElementComparator((Comparator)new ExtendedByTypesComparator(elementComparator, this.getComparatorsByType()));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.iterables = Iterables.instance();
        return (SELF)this.usingDefaultComparator();
    }

    @Override
    @SafeVarargs
    public final SELF containsAnyOf(ELEMENT ... values) {
        return this.containsAnyOfForProxy(values);
    }

    protected SELF containsAnyOfForProxy(ELEMENT[] values) {
        this.iterables.assertContainsAnyOf(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsAnyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsAnyOf((Object[])IterableUtil.toArray(iterable));
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extracting(String propertyOrField) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        String extractedDescription = Extractors.extractedDescriptionOf(propertyOrField);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> extractingResultOf(String method) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> AbstractListAssert<?, List<? extends P>, P, ObjectAssert<P>> extractingResultOf(String method, Class<P> extractedType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> AbstractListAssert<?, List<? extends P>, P, ObjectAssert<P>> extracting(String propertyOrField, Class<P> extractingType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        String extractedDescription = Extractors.extractedDescriptionOf(propertyOrField);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(String ... propertiesOrFields) {
        List<Tuple> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertiesOrFields));
        String extractedDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.newListAssertInstanceForMethodsChangingElementType(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> extracting(Function<? super ELEMENT, V> extractor) {
        return this.internalExtracting(extractor);
    }

    private <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> internalExtracting(Function<? super ELEMENT, V> extractor) {
        if (this.actual == null) {
            this.throwAssertionError(ShouldNotBeNull.shouldNotBeNull());
        }
        List<V> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        return this.newListAssertInstanceForMethodsChangingElementType(values);
    }

    public <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> map(Function<? super ELEMENT, V> mapper) {
        return this.internalExtracting(mapper);
    }

    @CheckReturnValue
    public <V, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> extracting(ThrowingExtractor<? super ELEMENT, V, EXCEPTION> extractor) {
        return this.internalExtracting(extractor);
    }

    @CheckReturnValue
    public <V, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> map(ThrowingExtractor<? super ELEMENT, V, EXCEPTION> mapper) {
        return this.internalExtracting(mapper);
    }

    private <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> newListAssertInstanceForMethodsChangingElementType(List<V> values) {
        if (this.actual instanceof SortedSet) {
            this.usingDefaultElementComparator();
        }
        return (AbstractListAssert)this.newListAssertInstance(values).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatExtracting(Function<? super ELEMENT, ? extends Collection<V>> extractor) {
        return this.doFlatExtracting(extractor);
    }

    @CheckReturnValue
    public <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatMap(Function<? super ELEMENT, ? extends Collection<V>> mapper) {
        return this.doFlatExtracting(mapper);
    }

    @CheckReturnValue
    public <V, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatExtracting(ThrowingExtractor<? super ELEMENT, ? extends Collection<V>, EXCEPTION> extractor) {
        return this.doFlatExtracting(extractor);
    }

    @CheckReturnValue
    public <V, EXCEPTION extends Exception> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> flatMap(ThrowingExtractor<? super ELEMENT, ? extends Collection<V>, EXCEPTION> mapper) {
        return this.doFlatExtracting(mapper);
    }

    private <V> AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> doFlatExtracting(Function<? super ELEMENT, ? extends Collection<V>> extractor) {
        List result2 = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor).stream().flatMap(Collection::stream).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(result2);
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(Function<? super ELEMENT, ?> ... extractors) {
        return this.flatExtractingForProxy(extractors);
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatMap(Function<? super ELEMENT, ?> ... mappers) {
        return this.flatExtractingForProxy(mappers);
    }

    protected AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtractingForProxy(Function<? super ELEMENT, ?>[] extractors) {
        if (this.actual == null) {
            this.throwAssertionError(ShouldNotBeNull.shouldNotBeNull());
        }
        Stream<Object> actualStream = StreamSupport.stream(((Iterable)this.actual).spliterator(), false);
        List result2 = actualStream.flatMap((? super T element) -> Stream.of(extractors).map((? super T extractor) -> extractor.apply(element))).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(result2);
    }

    @SafeVarargs
    @CheckReturnValue
    public final <EXCEPTION extends Exception> AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(ThrowingExtractor<? super ELEMENT, ?, EXCEPTION> ... extractors) {
        return this.flatExtractingForProxy(extractors);
    }

    @SafeVarargs
    @CheckReturnValue
    public final <EXCEPTION extends Exception> AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatMap(ThrowingExtractor<? super ELEMENT, ?, EXCEPTION> ... mappers) {
        return this.flatExtractingForProxy(mappers);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(String fieldOrPropertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(fieldOrPropertyName));
        for (Object group : extractedGroups) {
            if (Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return this.newListAssertInstanceForMethodsChangingElementType(extractedValues);
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(Function<? super ELEMENT, ?> ... extractors) {
        return this.extractingForProxy(extractors);
    }

    protected AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extractingForProxy(Function<? super ELEMENT, ?>[] extractors) {
        if (this.actual == null) {
            this.throwAssertionError(ShouldNotBeNull.shouldNotBeNull());
        }
        Function<Object, Tuple> tupleExtractor = objectToExtractValueFrom -> new Tuple(Stream.of(extractors).map((? super T extractor) -> extractor.apply(objectToExtractValueFrom)).toArray());
        List tuples = StreamSupport.stream(((Iterable)this.actual).spliterator(), false).map(tupleExtractor).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(tuples);
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> map(Function<? super ELEMENT, ?> ... mappers) {
        return this.extractingForProxy(mappers);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatExtracting(String ... fieldOrPropertyNames) {
        List extractedValues = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(fieldOrPropertyNames)).stream().flatMap((? super T tuple) -> tuple.toList().stream()).collect(Collectors.toList());
        return this.newListAssertInstanceForMethodsChangingElementType(extractedValues);
    }

    @Override
    public SELF containsExactlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    @Deprecated
    public SELF containsOnlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF containsOnlyOnceElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnlyOnce((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF hasSameElementsAs(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Deprecated
    @CheckReturnValue
    public <T> SELF usingComparatorForElementFieldsWithNames(Comparator<T> comparator, String ... elementPropertyOrFieldNames) {
        for (String elementPropertyOrField : elementPropertyOrFieldNames) {
            this.comparatorsForElementPropertyOrFieldNames.put(elementPropertyOrField, comparator);
        }
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Deprecated
    @CheckReturnValue
    public <T> SELF usingComparatorForElementFieldsWithType(Comparator<T> comparator, Class<T> type2) {
        this.getComparatorsForElementPropertyOrFieldTypes().registerComparator(type2, comparator);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForType(Comparator<T> comparator, Class<T> type2) {
        if (this.iterables.getComparator() == null) {
            this.usingElementComparator((Comparator)new ExtendedByTypesComparator(this.getComparatorsByType()));
        }
        this.getComparatorsForElementPropertyOrFieldTypes().registerComparator(type2, comparator);
        this.getComparatorsByType().registerComparator(type2, comparator);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Deprecated
    @CheckReturnValue
    public SELF usingFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new FieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes()));
    }

    @CheckReturnValue
    public SELF usingRecursiveFieldByFieldElementComparator() {
        return this.usingRecursiveFieldByFieldElementComparator(new RecursiveComparisonConfiguration());
    }

    public SELF usingRecursiveFieldByFieldElementComparator(RecursiveComparisonConfiguration configuration) {
        return (SELF)this.usingElementComparator((Comparator)new ConfigurableRecursiveFieldByFieldComparator(configuration));
    }

    @Override
    @Beta
    public RecursiveComparisonAssert<?> usingRecursiveComparison() {
        return super.usingRecursiveComparison();
    }

    @Override
    @Beta
    public RecursiveComparisonAssert<?> usingRecursiveComparison(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        return super.usingRecursiveComparison(recursiveComparisonConfiguration).withTypeComparators(this.comparatorsByType);
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion() {
        return super.usingRecursiveAssertion();
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion(RecursiveAssertionConfiguration recursiveAssertionConfiguration) {
        return super.usingRecursiveAssertion(recursiveAssertionConfiguration);
    }

    @Deprecated
    @CheckReturnValue
    public SELF usingElementComparatorOnFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new OnFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes(), fields));
    }

    @CheckReturnValue
    public SELF usingRecursiveFieldByFieldElementComparatorOnFields(String ... fields) {
        RecursiveComparisonConfiguration recursiveComparisonConfiguration = RecursiveComparisonConfiguration.builder().withComparedFields(fields).build();
        return this.usingRecursiveFieldByFieldElementComparator(recursiveComparisonConfiguration);
    }

    protected SELF usingComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        this.iterables = new Iterables(comparisonStrategy);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Deprecated
    @CheckReturnValue
    public SELF usingElementComparatorIgnoringFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new IgnoringFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes(), fields));
    }

    @CheckReturnValue
    public SELF usingRecursiveFieldByFieldElementComparatorIgnoringFields(String ... fields) {
        RecursiveComparisonConfiguration recursiveComparisonConfiguration = RecursiveComparisonConfiguration.builder().withIgnoredFields(fields).build();
        return this.usingRecursiveFieldByFieldElementComparator(recursiveComparisonConfiguration);
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractIterableAssert)super.inHexadecimal());
    }

    @Override
    @CheckReturnValue
    public SELF inBinary() {
        return (SELF)((AbstractIterableAssert)super.inBinary());
    }

    @CheckReturnValue
    public SELF filteredOn(String propertyOrFieldName, Object expectedValue) {
        Filters filter = Filters.filter((Iterable)this.actual);
        List filteredIterable = filter.with(propertyOrFieldName, expectedValue).get();
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public SELF filteredOnNull(String propertyOrFieldName) {
        Filters filter = Filters.filter((Iterable)this.actual);
        List filteredIterable = filter.with(propertyOrFieldName, null).get();
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public SELF filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters filter = Filters.filter((Iterable)this.actual).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filter.get())).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public SELF filteredOn(Condition<? super ELEMENT> condition) {
        Filters<? super ELEMENT> filter = Filters.filter((Iterable)this.actual);
        List<? super ELEMENT> filteredIterable = filter.being(condition).get();
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public <T> SELF filteredOn(Function<? super ELEMENT, T> function2, T expectedValue) {
        Preconditions.checkArgument(function2 != null, "The filter function should not be null", new Object[0]);
        return this.internalFilteredOn(element -> java.util.Objects.equals(function2.apply((Object)element), expectedValue));
    }

    public SELF filteredOnAssertions(Consumer<? super ELEMENT> elementAssertions) {
        return this.internalFilteredOnAssertions(elementAssertions);
    }

    public SELF filteredOnAssertions(ThrowingConsumer<? super ELEMENT> elementAssertions) {
        return this.internalFilteredOnAssertions(elementAssertions);
    }

    private SELF internalFilteredOnAssertions(Consumer<? super ELEMENT> elementAssertions) {
        Preconditions.checkArgument(elementAssertions != null, "The element assertions should not be null", new Object[0]);
        List filteredIterable = StreamSupport.stream(((Iterable)this.actual).spliterator(), false).filter(Iterables.byPassingAssertions(elementAssertions)).collect(Collectors.toList());
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public ELEMENT_ASSERT first() {
        return this.internalFirst();
    }

    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT first(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return ((AbstractAssert)this.internalFirst()).asInstanceOf(assertFactory);
    }

    private ELEMENT_ASSERT internalFirst() {
        this.isNotEmpty();
        return this.toAssert(((Iterable)this.actual).iterator().next(), this.navigationDescription("check first element"));
    }

    @CheckReturnValue
    public ELEMENT_ASSERT last() {
        return this.internalLast();
    }

    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT last(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return ((AbstractAssert)this.internalLast()).asInstanceOf(assertFactory);
    }

    private ELEMENT_ASSERT internalLast() {
        this.isNotEmpty();
        return this.toAssert(this.lastElement(), this.navigationDescription("check last element"));
    }

    private ELEMENT lastElement() {
        if (this.actual instanceof List) {
            List list2 = (List)this.actual;
            return (ELEMENT)list2.get(list2.size() - 1);
        }
        Iterator actualIterator = ((Iterable)this.actual).iterator();
        Object last = actualIterator.next();
        while (actualIterator.hasNext()) {
            last = actualIterator.next();
        }
        return (ELEMENT)last;
    }

    @CheckReturnValue
    public ELEMENT_ASSERT element(int index) {
        return this.internalElement(index);
    }

    @CheckReturnValue
    public SELF elements(int ... indices) {
        this.isNotEmpty();
        AbstractIterableAssert.assertIndicesIsNotNull(indices);
        AbstractIterableAssert.assertIndicesIsNotEmpty(indices);
        ArrayList indexedActual = Lists.newArrayList((Iterable)this.actual);
        List filteredIterable = java.util.Arrays.stream(indices).peek(index -> this.checkIndexValidity(index, indexedActual)).mapToObj(indexedActual::get).collect(Collectors.toList());
        return this.newAbstractIterableAssertForProxy(filteredIterable);
    }

    protected SELF newAbstractIterableAssertForProxy(List<ELEMENT> filteredIterable) {
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }

    private static void assertIndicesIsNotNull(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("indices must not be null");
        }
    }

    private static void assertIndicesIsNotEmpty(int[] indices) {
        if (indices.length == 0) {
            throw new IllegalArgumentException("indices must not be empty");
        }
    }

    private void checkIndexValidity(int index, List<ELEMENT> indexedActual) {
        ((ListAssert)((AbstractListAssert)((Object)Assertions.assertThat(indexedActual))).describedAs("check actual size is enough to get element[" + index + "]", new Object[0])).hasSizeGreaterThan(index);
    }

    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT element(int index, InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return ((AbstractAssert)this.internalElement(index)).asInstanceOf(assertFactory);
    }

    private ELEMENT_ASSERT internalElement(int index) {
        Object elementAtIndex;
        this.isNotEmpty();
        ((AbstractIntegerAssert)Assertions.assertThat(index).describedAs(this.navigationDescription("check index validity"), new Object[0])).isBetween(0, IterableUtil.sizeOf((Iterable)this.actual) - 1);
        if (this.actual instanceof List) {
            List list2 = (List)this.actual;
            elementAtIndex = list2.get(index);
        } else {
            Iterator actualIterator = ((Iterable)this.actual).iterator();
            for (int i = 0; i < index; ++i) {
                actualIterator.next();
            }
            elementAtIndex = actualIterator.next();
        }
        return this.toAssert(elementAtIndex, this.navigationDescription("element at index " + index));
    }

    @CheckReturnValue
    public ELEMENT_ASSERT singleElement() {
        return this.internalSingleElement();
    }

    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT singleElement(InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return ((AbstractAssert)this.internalSingleElement()).asInstanceOf(assertFactory);
    }

    private ELEMENT_ASSERT internalSingleElement() {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, 1);
        return this.toAssert(((Iterable)this.actual).iterator().next(), this.navigationDescription("check single element"));
    }

    protected abstract ELEMENT_ASSERT toAssert(ELEMENT var1, String var2);

    protected String navigationDescription(String propertyName) {
        String text2 = this.descriptionText();
        if (Strings.isNullOrEmpty(text2)) {
            text2 = AbstractIterableAssert.removeAssert(this.getClass().getSimpleName());
        }
        return text2 + " " + propertyName;
    }

    private static String removeAssert(String text2) {
        return text2.endsWith(ASSERT) ? text2.substring(0, text2.length() - ASSERT.length()) : text2;
    }

    public SELF filteredOn(Predicate<? super ELEMENT> predicate) {
        return this.internalFilteredOn(predicate);
    }

    @Override
    public SELF allMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertAllMatch(this.info, (Iterable)this.actual, predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF allMatch(Predicate<? super ELEMENT> predicate, String predicateDescription) {
        this.iterables.assertAllMatch(this.info, (Iterable)this.actual, predicate, new PredicateDescription(predicateDescription));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF allSatisfy(Consumer<? super ELEMENT> requirements) {
        return this.internalAllSatisfy(requirements);
    }

    @Override
    public SELF allSatisfy(ThrowingConsumer<? super ELEMENT> requirements) {
        return this.internalAllSatisfy(requirements);
    }

    private SELF internalAllSatisfy(Consumer<? super ELEMENT> requirements) {
        this.iterables.assertAllSatisfy(this.info, (Iterable)this.actual, requirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF anyMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertAnyMatch(this.info, (Iterable)this.actual, predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    public <OTHER_ELEMENT> SELF zipSatisfy(Iterable<OTHER_ELEMENT> other, BiConsumer<? super ELEMENT, OTHER_ELEMENT> zipRequirements) {
        this.iterables.assertZipSatisfy(this.info, (Iterable)this.actual, other, zipRequirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF anySatisfy(Consumer<? super ELEMENT> requirements) {
        return this.internalAnySatisfy(requirements);
    }

    @Override
    public SELF anySatisfy(ThrowingConsumer<? super ELEMENT> requirements) {
        return this.internalAnySatisfy(requirements);
    }

    private SELF internalAnySatisfy(Consumer<? super ELEMENT> requirements) {
        this.iterables.assertAnySatisfy(this.info, (Iterable)this.actual, requirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF noneSatisfy(Consumer<? super ELEMENT> restrictions) {
        return this.internalNoneSatisfy(restrictions);
    }

    @Override
    public SELF noneSatisfy(ThrowingConsumer<? super ELEMENT> restrictions) {
        return this.internalNoneSatisfy(restrictions);
    }

    private SELF internalNoneSatisfy(Consumer<? super ELEMENT> restrictions) {
        this.iterables.assertNoneSatisfy(this.info, (Iterable)this.actual, restrictions);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF satisfiesExactly(Consumer<? super ELEMENT> ... requirements) {
        return this.satisfiesExactlyForProxy(requirements);
    }

    @Override
    @SafeVarargs
    public final SELF satisfiesExactly(ThrowingConsumer<? super ELEMENT> ... requirements) {
        return this.satisfiesExactlyForProxy(requirements);
    }

    protected SELF satisfiesExactlyForProxy(Consumer<? super ELEMENT>[] requirements) {
        this.iterables.assertSatisfiesExactly(this.info, (Iterable)this.actual, requirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @SafeVarargs
    public final SELF satisfiesExactlyInAnyOrder(Consumer<? super ELEMENT> ... requirements) {
        return this.satisfiesExactlyInAnyOrderForProxy(requirements);
    }

    @Override
    @SafeVarargs
    public final SELF satisfiesExactlyInAnyOrder(ThrowingConsumer<? super ELEMENT> ... requirements) {
        return this.satisfiesExactlyInAnyOrderForProxy(requirements);
    }

    protected SELF satisfiesExactlyInAnyOrderForProxy(Consumer<? super ELEMENT>[] requirements) {
        this.iterables.assertSatisfiesExactlyInAnyOrder(this.info, (Iterable)this.actual, requirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF satisfiesOnlyOnce(Consumer<? super ELEMENT> requirements) {
        return this.satisfiesOnlyOnceForProxy(requirements);
    }

    @Override
    public SELF satisfiesOnlyOnce(ThrowingConsumer<? super ELEMENT> requirements) {
        return this.satisfiesOnlyOnceForProxy(requirements);
    }

    protected SELF satisfiesOnlyOnceForProxy(Consumer<? super ELEMENT> requirements) {
        this.iterables.assertSatisfiesOnlyOnce(this.info, (Iterable)this.actual, requirements);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.as(description, args));
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description) {
        return (SELF)((AbstractIterableAssert)super.as(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(Description description) {
        return (SELF)((AbstractIterableAssert)super.describedAs(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(String description, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.describedAs(description, args));
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.doesNotHave((Condition)condition));
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.has((Condition)condition));
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.hasSameClassAs(other));
    }

    @Override
    public SELF hasToString(String expectedToString) {
        return (SELF)((AbstractIterableAssert)super.hasToString(expectedToString));
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.is((Condition)condition));
    }

    @Override
    public SELF isEqualTo(Object expected) {
        return (SELF)((AbstractIterableAssert)super.isEqualTo(expected));
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type2) {
        return (SELF)((AbstractIterableAssert)super.isExactlyInstanceOf((Class)type2));
    }

    @Override
    public SELF isIn(Iterable<?> values) {
        return (SELF)((AbstractIterableAssert)super.isIn((Iterable)values));
    }

    @Override
    public SELF isIn(Object ... values) {
        return (SELF)((AbstractIterableAssert)super.isIn(values));
    }

    @Override
    public SELF isInstanceOf(Class<?> type2) {
        return (SELF)((AbstractIterableAssert)super.isInstanceOf((Class)type2));
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.isNot((Condition)condition));
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        return (SELF)((AbstractIterableAssert)super.isNotEqualTo(other));
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type2) {
        return (SELF)((AbstractIterableAssert)super.isNotExactlyInstanceOf((Class)type2));
    }

    @Override
    public SELF isNotIn(Iterable<?> values) {
        return (SELF)((AbstractIterableAssert)super.isNotIn((Iterable)values));
    }

    @Override
    public SELF isNotIn(Object ... values) {
        return (SELF)((AbstractIterableAssert)super.isNotIn(values));
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type2) {
        return (SELF)((AbstractIterableAssert)super.isNotInstanceOf((Class)type2));
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isNotNull() {
        return (SELF)((AbstractIterableAssert)super.isNotNull());
    }

    @Override
    public SELF isNotSameAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.isNotSameAs(other));
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isSameAs(Object expected) {
        return (SELF)((AbstractIterableAssert)super.isSameAs(expected));
    }

    @Override
    public SELF noneMatch(Predicate<? super ELEMENT> predicate) {
        this.iterables.assertNoneMatch(this.info, (Iterable)this.actual, predicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.overridingErrorMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        return (SELF)((AbstractIterableAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        return (SELF)((AbstractIterableAssert)super.usingComparator((Comparator)customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF withFailMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.withFailMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF withThreadDumpOnError() {
        return (SELF)((AbstractIterableAssert)super.withThreadDumpOnError());
    }

    @CheckReturnValue
    public AbstractIterableSizeAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT> size() {
        java.util.Objects.requireNonNull((Iterable)this.actual, "Can not perform assertions on the size of a null iterable.");
        return new IterableSizeAssert(this, IterableUtil.sizeOf((Iterable)this.actual));
    }

    protected TypeComparators getComparatorsByType() {
        if (this.comparatorsByType == null) {
            this.comparatorsByType = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorsByType;
    }

    protected TypeComparators getComparatorsForElementPropertyOrFieldTypes() {
        if (this.comparatorsForElementPropertyOrFieldTypes == null) {
            this.comparatorsForElementPropertyOrFieldTypes = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorsForElementPropertyOrFieldTypes;
    }

    protected abstract SELF newAbstractIterableAssert(Iterable<? extends ELEMENT> var1);

    @Override
    SELF withAssertionState(AbstractAssert assertInstance) {
        if (assertInstance instanceof AbstractIterableAssert) {
            AbstractIterableAssert iterableAssert = (AbstractIterableAssert)assertInstance;
            return ((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)super.withAssertionState(assertInstance)).withIterables(iterableAssert.iterables)).withTypeComparators(iterableAssert.comparatorsByType)).withComparatorsForElementPropertyOrFieldNames(iterableAssert.comparatorsForElementPropertyOrFieldNames)).withComparatorsForElementPropertyOrFieldTypes(iterableAssert.comparatorsForElementPropertyOrFieldTypes);
        }
        if (assertInstance instanceof AbstractObjectArrayAssert) {
            AbstractObjectArrayAssert objectArrayAssert = (AbstractObjectArrayAssert)assertInstance;
            return ((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)((AbstractIterableAssert)super.withAssertionState(assertInstance)).withIterables(objectArrayAssert.iterables)).withTypeComparators(objectArrayAssert.comparatorsByType)).withComparatorsForElementPropertyOrFieldNames(objectArrayAssert.comparatorsForElementPropertyOrFieldNames)).withComparatorsForElementPropertyOrFieldTypes(objectArrayAssert.comparatorsForElementPropertyOrFieldTypes);
        }
        return (SELF)((AbstractIterableAssert)super.withAssertionState(assertInstance));
    }

    SELF withIterables(Iterables iterables) {
        this.iterables = iterables;
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    SELF withTypeComparators(TypeComparators comparatorsByType) {
        this.comparatorsByType = comparatorsByType;
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    SELF withComparatorsForElementPropertyOrFieldNames(Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames) {
        this.comparatorsForElementPropertyOrFieldNames = comparatorsForElementPropertyOrFieldNames;
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    SELF withComparatorsForElementPropertyOrFieldTypes(TypeComparators comparatorsForElementPropertyOrFieldTypes) {
        this.comparatorsForElementPropertyOrFieldTypes = comparatorsForElementPropertyOrFieldTypes;
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    private SELF internalFilteredOn(Predicate<? super ELEMENT> predicate) {
        Preconditions.checkArgument(predicate != null, "The filter predicate should not be null", new Object[0]);
        List filteredIterable = StreamSupport.stream(((Iterable)this.actual).spliterator(), false).filter(predicate).collect(Collectors.toList());
        return (SELF)((AbstractIterableAssert)this.newAbstractIterableAssert(filteredIterable)).withAssertionState(this.myself);
    }
}

