/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;

final class WindowMetrics {
    @Nonnull
    @RunsInCurrentThread
    static Point absoluteCenterOf(@Nonnull Window window) {
        Insets insets = window.getInsets();
        int w = window.getWidth() - (insets.left + insets.right);
        int h = window.getHeight() - (insets.top + insets.bottom);
        int x = window.getX() + insets.left;
        int y2 = window.getY() + insets.top;
        return new Point(x + w / 2, y2 + h / 2);
    }

    private WindowMetrics() {
    }
}

