/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.actions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\tJF\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/editorconfig/language/codeinsight/actions/EnterInEditorConfigFileHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "WHITE_SPACE", "Lkotlin/text/Regex;", "isCommentStart", "", "char", "", "(Ljava/lang/Character;)Z", "isWhitespace", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "intellij.editorconfig"})
public final class EnterInEditorConfigFileHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    private final Regex WHITE_SPACE = new Regex("\\s");

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(file instanceof EditorConfigPsiFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Project project = ((EditorConfigPsiFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(document2);
        Integer caretOffset = (Integer)caretOffsetRef.get();
        Intrinsics.checkNotNull((Object)caretOffset);
        PsiElement psiUnderCaret = file.findElementAt(caretOffset.intValue());
        PsiElement psiElement = psiUnderCaret;
        IElementType elementType = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null;
        Object object = psiUnderCaret;
        Character psiElementStart = object != null && (object = object.getText()) != null ? StringsKt.firstOrNull((CharSequence)((CharSequence)object)) : null;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        int n = caretOffset;
        Character charUnderCaret = StringsKt.getOrNull((CharSequence)charSequence, (int)n);
        if (!Intrinsics.areEqual((Object)elementType, (Object)EditorConfigElementTypes.LINE_COMMENT) || this.isCommentStart(charUnderCaret)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        charSequence = this.isWhitespace(charUnderCaret) ? TuplesKt.to((Object)("\n" + psiElementStart), (Object)3) : TuplesKt.to((Object)("\n" + psiElementStart + " "), (Object)3);
        String text = (String)charSequence.component1();
        int offset = ((Number)charSequence.component2()).intValue();
        document2.insertString(caretOffset.intValue(), (CharSequence)text);
        editor.getCaretModel().moveToOffset(caretOffset + offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        return EnterHandlerDelegate.Result.Stop;
    }

    private final boolean isWhitespace(Character c) {
        return c != null && this.WHITE_SPACE.matches((CharSequence)c.toString());
    }

    private final boolean isCommentStart(Character c) {
        return c != null && StringsKt.contains$default((CharSequence)"#;", (char)c.charValue(), (boolean)false, (int)2, null);
    }
}

