/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.treeAssertion;

import com.intellij.platform.testFramework.treeAssertion.SimpleTree;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001aX\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0001\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\b\n2\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00070\t\u00a2\u0006\u0002\b\n\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0001\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0001\u001a\u0016\u0010\r\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0001\u00a8\u0006\u000e"}, d2={"buildTree", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTree;", "", "treeString", "", "T", "roots", "", "nameGetter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "childrenGetter", "deepCopyTree", "getTreeString", "intellij.platform.testFramework"})
public final class SimpleTreeUtilKt {
    @NotNull
    public static final <T> SimpleTree<T> deepCopyTree(@NotNull SimpleTree<T> $this$deepCopyTree) {
        Intrinsics.checkNotNullParameter($this$deepCopyTree, (String)"<this>");
        ArrayDeque queue2 = new ArrayDeque();
        SimpleTree tree = new SimpleTree();
        for (SimpleTree.Node<T> root : $this$deepCopyTree.getRoots()) {
            SimpleTree.Node<T> mutableRoot = new SimpleTree.Node<T>(root.getName(), root.getValue());
            tree.getRoots().add(mutableRoot);
            queue2.add((Object)TuplesKt.to(root, mutableRoot));
        }
        while (!((Collection)queue2).isEmpty()) {
            Pair pair = (Pair)queue2.removeFirst();
            SimpleTree.Node node2 = (SimpleTree.Node)pair.component1();
            SimpleTree.Node mutableNode = (SimpleTree.Node)pair.component2();
            for (SimpleTree.Node child : node2.getChildren()) {
                SimpleTree.Node mutableChild = new SimpleTree.Node(child.getName(), child.getValue());
                mutableNode.getChildren().add(mutableChild);
                queue2.add((Object)TuplesKt.to(child, mutableChild));
            }
        }
        return tree;
    }

    @NotNull
    public static final <T> String getTreeString(@NotNull SimpleTree<T> $this$getTreeString) {
        Intrinsics.checkNotNullParameter($this$getTreeString, (String)"<this>");
        StringJoiner result2 = new StringJoiner("\n");
        ArrayDeque stack = new ArrayDeque();
        for (SimpleTree.Node root : CollectionsKt.asReversedMutable($this$getTreeString.getRoots())) {
            stack.addLast((Object)TuplesKt.to((Object)0, (Object)root));
        }
        while (!((Collection)stack).isEmpty()) {
            Pair pair = (Pair)stack.removeLast();
            int indent = ((Number)pair.component1()).intValue();
            SimpleTree.Node node2 = (SimpleTree.Node)pair.component2();
            String indentString = StringsKt.repeat((CharSequence)" ", (int)indent);
            String nodeMarker = !((Collection)node2.getChildren()).isEmpty() ? "-" : "";
            result2.add(indentString + nodeMarker + node2.getName());
            for (SimpleTree.Node child : CollectionsKt.asReversedMutable(node2.getChildren())) {
                stack.addLast((Object)TuplesKt.to((Object)(indent + 1), (Object)child));
            }
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final <T> SimpleTree<T> buildTree(@NotNull List<? extends T> roots, @NotNull Function1<? super T, String> nameGetter, @NotNull Function1<? super T, ? extends List<? extends T>> childrenGetter) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter(nameGetter, (String)"nameGetter");
        Intrinsics.checkNotNullParameter(childrenGetter, (String)"childrenGetter");
        SimpleTree tree = new SimpleTree();
        ArrayDeque queue2 = new ArrayDeque();
        for (T root : roots) {
            SimpleTree.Node<T> node2 = new SimpleTree.Node<T>((String)nameGetter.invoke(root), root);
            tree.getRoots().add(node2);
            queue2.add(node2);
        }
        while (!((Collection)queue2).isEmpty()) {
            SimpleTree.Node node3 = (SimpleTree.Node)queue2.removeLast();
            for (Object child : (List)childrenGetter.invoke(node3.getValue())) {
                SimpleTree.Node childNode = new SimpleTree.Node((String)nameGetter.invoke(child), child);
                node3.getChildren().add(childNode);
                queue2.addFirst(childNode);
            }
        }
        return tree;
    }

    @NotNull
    public static final SimpleTree buildTree(@NotNull String treeString) {
        Intrinsics.checkNotNullParameter((Object)treeString, (String)"treeString");
        ArrayDeque stack = new ArrayDeque();
        String[] stringArray = new String[]{"\n"};
        Iterator iterator = StringsKt.split$default((CharSequence)treeString, (String[])stringArray, (boolean)false, (int)0, (int)6, null).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String nodeString = (String)iterator.next();
            int indent = nodeString.length() - ((Object)StringsKt.trimStart((CharSequence)nodeString)).toString().length();
            String name = StringsKt.removePrefix((String)((Object)StringsKt.trimStart((CharSequence)nodeString)).toString(), (CharSequence)"-");
            SimpleTree.Node<Object> node2 = new SimpleTree.Node<Object>(name, null);
            Pair parentNode = (Pair)stack.lastOrNull();
            while (parentNode != null && ((Number)parentNode.getFirst()).intValue() >= indent) {
                stack.removeLast();
                parentNode = (Pair)stack.lastOrNull();
            }
            Pair pair = parentNode;
            if (!((pair != null ? ((Number)pair.getFirst()).intValue() : -1) == indent - 1)) {
                boolean bl = false;
                String string = "Incorrect tree structure at " + index + ":\n" + treeString;
                throw new IllegalArgumentException(string.toString());
            }
            Pair pair2 = parentNode;
            if ((pair2 != null ? (SimpleTree.Node)pair2.getSecond() : null) != null) {
                ((SimpleTree.Node)parentNode.getSecond()).getChildren().add(node2);
            }
            stack.add((Object)TuplesKt.to((Object)indent, node2));
        }
        SimpleTree tree = new SimpleTree();
        for (Pair index : stack) {
            int indent = ((Number)index.component1()).intValue();
            SimpleTree.Node node3 = (SimpleTree.Node)index.component2();
            if (indent != 0) continue;
            tree.getRoots().add(node3);
        }
        if (!Intrinsics.areEqual((Object)treeString, (Object)SimpleTreeUtilKt.getTreeString(tree))) {
            boolean bl = false;
            String string = "Incorrect tree structure:\n" + treeString;
            throw new IllegalArgumentException(string.toString());
        }
        return tree;
    }
}

