/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.lineMarkers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.LineMarkerActionModel;
import com.jetbrains.rd.ide.model.LineMarkerHighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.lineMarkers.FrontendLineMarkerModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.lineMarkers.UtilKt;
import com.jetbrains.rdclient.daemon.highlighters.lineMarkers.renderers.DelegatingFrontendLineMarkerRenderer;
import com.jetbrains.rdclient.daemon.highlighters.lineMarkers.renderers.FrontendLineMarkerRendererProvider;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/lineMarkers/FrontendLineMarkerModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "actionModel", "Lcom/jetbrains/rd/ide/model/LineMarkerActionModel;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rd/ide/model/LineMarkerActionModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;Lcom/intellij/openapi/project/Project;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "createRenderer", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "Lcom/jetbrains/rd/ide/model/LineMarkerHighlighterModel;", "initialize", "", "move", "startOffset", "", "endOffset", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendLineMarkerModelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendLineMarkerModelHandler.kt\ncom/jetbrains/rdclient/daemon/highlighters/lineMarkers/FrontendLineMarkerModelHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n11#2:79\n*S KotlinDebug\n*F\n+ 1 FrontendLineMarkerModelHandler.kt\ncom/jetbrains/rdclient/daemon/highlighters/lineMarkers/FrontendLineMarkerModelHandler\n*L\n23#1:79\n*E\n"})
public final class FrontendLineMarkerModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final LineMarkerActionModel actionModel;
    @Nullable
    private final FrontendTooltipProvider tooltipProvider;
    @Nullable
    private final Project project;
    @NotNull
    private static final Logger logger;

    public FrontendLineMarkerModelHandler(@Nullable LineMarkerActionModel actionModel, @Nullable FrontendTooltipProvider tooltipProvider, @Nullable Project project) {
        this.actionModel = actionModel;
        this.tooltipProvider = tooltipProvider;
        this.project = project;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof LineMarkerHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        LineMarkerHighlighterModel cfr_ignored_0 = (LineMarkerHighlighterModel)model;
        LineMarkerRenderer lineMarkerRenderer = this.createRenderer((LineMarkerHighlighterModel)model, highlighter2);
        if (lineMarkerRenderer == null) {
            return;
        }
        LineMarkerRenderer renderer = lineMarkerRenderer;
        LineMarkerRenderer resultRenderer = ((LineMarkerHighlighterModel)model).isActive() ? (LineMarkerRenderer)new DelegatingFrontendLineMarkerRenderer(renderer, model.getId(), UtilKt.fromModel(((LineMarkerHighlighterModel)model).getPosition()), this.actionModel, this.tooltipProvider) : renderer;
        highlighter2.setLineMarkerRenderer(resultRenderer);
    }

    private final LineMarkerRenderer createRenderer(LineMarkerHighlighterModel model, RangeHighlighter highlighter2) {
        String rendererId = model.getRenderer().getRendererId();
        FrontendLineMarkerRendererProvider rendererProvider2 = (FrontendLineMarkerRendererProvider)FrontendLineMarkerRendererProvider.Companion.getEP_NAME().findFirstSafe(arg_0 -> FrontendLineMarkerModelHandler.createRenderer$lambda$0((Function1)new Function1<FrontendLineMarkerRendererProvider, Boolean>(rendererId){
            final /* synthetic */ String $rendererId;
            {
                this.$rendererId = $rendererId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FrontendLineMarkerRendererProvider it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getId(), (Object)this.$rendererId);
            }
        }, arg_0));
        if (rendererProvider2 == null) {
            logger.warn("Renderer provider with ID=" + rendererId + " was not found");
            Object object = FrontendLineMarkerRendererProvider.Companion.getEP_NAME().findFirstSafe(arg_0 -> FrontendLineMarkerModelHandler.createRenderer$lambda$1(createRenderer.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)object);
            rendererProvider2 = (FrontendLineMarkerRendererProvider)object;
        }
        return rendererProvider2.createRenderer(model, highlighter2, this.project);
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        LineMarkerHighlighterModel $this$move_u24lambda_u242 = (LineMarkerHighlighterModel)model;
        boolean bl = false;
        return (HighlighterModel)new LineMarkerHighlighterModel($this$move_u24lambda_u242.getRenderer(), $this$move_u24lambda_u242.getPosition(), $this$move_u24lambda_u242.isActive(), $this$move_u24lambda_u242.getLayer(), false, $this$move_u24lambda_u242.getDocumentVersion(), $this$move_u24lambda_u242.isGreedyToLeft(), $this$move_u24lambda_u242.isGreedyToRight(), $this$move_u24lambda_u242.isThinErrorStripeMark(), $this$move_u24lambda_u242.getTextToHighlight(), $this$move_u24lambda_u242.getTextAttributesKey(), $this$move_u24lambda_u242.getId(), $this$move_u24lambda_u242.getProperties(), startOffset, endOffset);
    }

    private static final boolean createRenderer$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean createRenderer$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendLineMarkerModelHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendLineMarkerModelHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/lineMarkers/FrontendLineMarkerModelHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

