/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.IgnoredStorage;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.InstructionsUtil;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.StringsPool;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import com.intellij.rt.coverage.util.TestTrackingIOUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData
implements CoverageData,
Serializable {
    public static ProjectData ourProjectData;
    private final File myDataFile;
    private final boolean myBranchCoverage;
    private List<Pattern> myIncludePatterns;
    private List<Pattern> myExcludePatterns;
    private List<Pattern> myAnnotationsToIgnore;
    private final Map<String, ClassData> myClasses = new ConcurrentHashMap<String, ClassData>(1000);
    private final StringsPool myStringPool = new StringsPool();
    private final IgnoredStorage myIgnoredStorage = new IgnoredStorage();
    private volatile Map<String, FileMapData[]> myLinesMap;
    private final AtomicReference<Map<Object, boolean[]>> myTrace = new AtomicReference();
    private final TestTrackingCallback myTestTrackingCallback;
    private File myTracesDir;
    private boolean myCollectInstructions;
    private Map<String, ClassInstructions> myInstructions;
    private boolean myStopped;

    public ProjectData() {
        this(null, true, null);
    }

    /*
     * WARNING - void declaration
     */
    public ProjectData(File dataFile, boolean branchCoverage, TestTrackingCallback testTrackingCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myDataFile = var1_1;
        this.myBranchCoverage = var2_2;
        this.myTestTrackingCallback = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ClassData getClassData(String name) {
        void var1_1;
        return this.myClasses.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassData getOrCreateClassData(String name) {
        void var2_2;
        ClassData classData = this.myClasses.get(name = this.getFromPool(name));
        if (classData == null) {
            void var1_1;
            classData = new ClassData(name);
            this.myClasses.put((String)var1_1, classData);
        }
        return var2_2;
    }

    public int getClassesNumber() {
        return this.myClasses.size();
    }

    public Map<String, ClassData> getClasses() {
        return new HashMap<String, ClassData>(this.myClasses);
    }

    public Collection<ClassData> getClassesCollection() {
        return this.myClasses.values();
    }

    public void stop() {
        this.myStopped = true;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public boolean isBranchCoverage() {
        return this.myBranchCoverage;
    }

    public boolean isTestTracking() {
        return this.myTestTrackingCallback != null;
    }

    public boolean isInstructionsCoverageEnabled() {
        return this.myCollectInstructions;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstructionsCoverage(boolean collectInstructions) {
        void var1_1;
        this.myCollectInstructions = var1_1;
    }

    public Map<String, FileMapData[]> getLinesMap() {
        return this.myLinesMap;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, ClassInstructions> getInstructions() {
        void var1_1;
        Map<String, ClassInstructions> instructions = this.myInstructions;
        if (instructions == null) {
            ProjectData projectData = this;
            synchronized (projectData) {
                instructions = this.myInstructions;
                if (instructions == null) {
                    this.myInstructions = instructions = new ConcurrentHashMap<String, ClassInstructions>();
                }
            }
        }
        return var1_1;
    }

    public List<Pattern> getIncudePatterns() {
        return this.myIncludePatterns;
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludePatterns(List<Pattern> patterns) {
        void var1_1;
        this.myIncludePatterns = var1_1;
    }

    public List<Pattern> getExcludePatterns() {
        return this.myExcludePatterns;
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludePatterns(List<Pattern> patterns) {
        void var1_1;
        this.myExcludePatterns = var1_1;
    }

    public List<Pattern> getAnnotationsToIgnore() {
        return this.myAnnotationsToIgnore;
    }

    /*
     * WARNING - void declaration
     */
    public void setAnnotationsToIgnore(List<Pattern> annotations) {
        void var1_1;
        this.myAnnotationsToIgnore = var1_1;
    }

    public IgnoredStorage getIgnoredStorage() {
        return this.myIgnoredStorage;
    }

    /*
     * WARNING - void declaration
     */
    public String getFromPool(String s) {
        void var1_1;
        return this.myStringPool.getFromPool((String)var1_1);
    }

    public Map<Object, boolean[]> getTraces() {
        return this.myTrace.get();
    }

    /*
     * WARNING - void declaration
     */
    public boolean[] traceLineByTest(ClassData classData, int line) {
        void var2_2;
        void var1_1;
        if (this.myTestTrackingCallback == null) {
            return null;
        }
        return this.myTestTrackingCallback.traceLine((ClassData)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void merge(CoverageData data) {
        void var1_1;
        ProjectData projectData = (ProjectData)data;
        for (Map.Entry<String, ClassData> entry : projectData.myClasses.entrySet()) {
            void var3_3;
            String key = entry.getKey();
            ClassData mergedData = entry.getValue();
            ClassData classData = this.myClasses.get(key);
            if (classData == null) {
                classData = new ClassData(mergedData.getName());
                this.myClasses.put(key, classData);
            }
            classData.merge((CoverageData)var3_3);
        }
        InstructionsUtil.merge((ProjectData)var1_1, this, null);
    }

    /*
     * WARNING - void declaration
     */
    public void dropLineMappings() {
        if (this.myLinesMap == null) {
            return;
        }
        for (Map.Entry<String, FileMapData[]> entry : this.myLinesMap.entrySet()) {
            void var2_2;
            void var3_3;
            ClassData classData = this.getClassData(entry.getKey());
            FileMapData[] mappings = entry.getValue();
            classData.dropMappedLines(mappings);
            InstructionsUtil.dropMappedLines(this, var3_3.getName(), (FileMapData[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void applyLineMappings() {
        if (this.myLinesMap != null) {
            for (Map.Entry<String, FileMapData[]> entry : this.myLinesMap.entrySet()) {
                void var2_2;
                String className = entry.getKey();
                ClassData classData = this.getClassData(className);
                FileMapData[] fileData = entry.getValue();
                FileMapData mainData = null;
                for (void aFileData : var2_2) {
                    ClassData classInfo;
                    String mappedClassName = aFileData.getClassName();
                    if (mappedClassName.equals(className)) {
                        mainData = aFileData;
                        continue;
                    }
                    if (!ClassNameUtil.matchesPatterns(mappedClassName, this.myExcludePatterns) && (this.myIncludePatterns == null || this.myIncludePatterns.isEmpty() || ClassNameUtil.matchesPatterns(mappedClassName, this.myIncludePatterns))) {
                        classInfo = this.getOrCreateClassData(mappedClassName);
                        if (classInfo.getSource() == null || classInfo.getSource().isEmpty()) {
                            classInfo.setSource(aFileData.getFileName());
                        }
                    } else {
                        classInfo = new ClassData((String)((Object)classInfo));
                    }
                    ClassData.checkLineMappings(aFileData.getLines(), classInfo, classData);
                    InstructionsUtil.applyInstructionsSMAP(this, aFileData.getLines(), classInfo, classData);
                }
                if (mainData == null) continue;
                ClassData classData2 = classData;
                ClassData.checkLineMappings(mainData.getLines(), classData2, classData2);
                ClassData classData3 = classData;
                InstructionsUtil.applyInstructionsSMAP(this, mainData.getLines(), classData3, classData3);
            }
        }
    }

    public void applyHits() {
        for (ClassData classData : this.myClasses.values()) {
            classData.applyHits();
        }
    }

    public void dropIgnoredLines() {
        for (ClassData classData : this.getClassesCollection()) {
            classData.dropIgnoredLines();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addLineMaps(String className, FileMapData[] fileDatas) {
        void var2_2;
        void var1_1;
        if (this.myLinesMap == null) {
            Class<FileMapData> clazz = FileMapData.class;
            // MONITORENTER : com.intellij.rt.coverage.data.FileMapData.class
            if (this.myLinesMap == null) {
                this.myLinesMap = new ConcurrentHashMap<String, FileMapData[]>();
            }
            // MONITOREXIT : clazz
        }
        this.myLinesMap.put((String)var1_1, (FileMapData[])var2_2);
    }

    public static ProjectData getProjectData() {
        return ourProjectData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEnded(String name) {
        Iterator iterator;
        File file;
        Map trace = this.myTrace.getAndSet(null);
        if (trace == null) {
            return;
        }
        File tracesDir = this.getTracesDir();
        try {
            try {
                TestTrackingIOUtil.saveTestResults(tracesDir, name, trace);
            }
            catch (IOException e) {
                ErrorReporter.warn("Error writing traces for test '" + name + "' to directory " + file.getPath(), e);
                file = null;
                iterator = iterator.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    Map.Entry entry = iterator.next();
                    ClassData classData = (ClassData)entry.getKey();
                    boolean[] touched = (boolean[])entry.getValue();
                    Object[] lines = classData.getLines();
                    int lineCount = Math.min(lines.length, touched.length);
                    for (int i = 1; i < lineCount; ++i) {
                        LineData lineData = (LineData)lines[i];
                        if (lineData == null || !touched[i]) continue;
                        lineData.setTestName(name);
                    }
                    this.myTestTrackingCallback.clearTrace(classData);
                }
            }
            file = null;
            iterator = iterator.entrySet().iterator();
        }
        catch (Throwable throwable) {
            file = null;
            iterator = iterator.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                Map.Entry entry = iterator.next();
                ClassData classData = (ClassData)entry.getKey();
                boolean[] touched = (boolean[])entry.getValue();
                Object[] lines = classData.getLines();
                int lineCount = Math.min(lines.length, touched.length);
                for (int i = 1; i < lineCount; ++i) {
                    LineData lineData = (LineData)lines[i];
                    if (lineData == null || !touched[i]) continue;
                    lineData.setTestName(name);
                }
                this.myTestTrackingCallback.clearTrace(classData);
            }
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ClassData classData = (ClassData)entry.getKey();
            boolean[] touched = (boolean[])entry.getValue();
            Object[] lines = classData.getLines();
            int lineCount = Math.min(lines.length, touched.length);
            for (int i = 1; i < lineCount; ++i) {
                LineData lineData = (LineData)lines[i];
                if (lineData == null || !touched[i]) continue;
                lineData.setTestName(name);
            }
            this.myTestTrackingCallback.clearTrace(classData);
        }
    }

    public void testStarted(String ignoredName) {
        if (this.isTestTracking()) {
            this.myTrace.compareAndSet(null, new ConcurrentHashMap());
        }
    }

    private File getTracesDir() {
        if (this.myTracesDir == null) {
            this.myTracesDir = ProjectData.createTracesDir(this.myDataFile);
        }
        return this.myTracesDir;
    }

    /*
     * WARNING - void declaration
     */
    public static File createTracesDir(File dataFile) {
        File file;
        void var1_1;
        void dirName;
        void var2_2;
        String fileName = dataFile.getName();
        int i = fileName.lastIndexOf(46);
        dirName = i != -1 ? fileName.substring(0, (int)var2_2) : dirName;
        File result = new File(dataFile.getParent(), (String)var1_1);
        if (!result.exists()) {
            result.mkdirs();
        }
        return file;
    }
}

