/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.methods;

import com.intellij.rt.coverage.data.IgnoredStorage;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import com.intellij.rt.coverage.util.OptionsUtil;

public class KotlinLocalFunctionInsideIgnoredMethodFilter
implements MethodFilter {
    public boolean shouldFilter(InstrumentationData data) {
        String outerMethodName;
        if (!OptionsUtil.IGNORE_LOCAL_FUNCTIONS_IN_IGNORED_METHODS) {
            return false;
        }
        int access = data.getMethodAccess();
        if ((access & 2) == 0 || (access & 0x10) == 0 || (access & 8) == 0) {
            return false;
        }
        int idx = -1;
        String name = data.getMethodName();
        String className = data.get(Key.CLASS_NAME);
        IgnoredStorage ignoredStorage = data.get(Key.PROJECT_DATA).getIgnoredStorage();
        do {
            if ((idx = name.indexOf(36, idx + 1)) >= 0) continue;
            return false;
        } while (!ignoredStorage.isMethodIgnored(className, outerMethodName = name.substring(0, idx)));
        ignoredStorage.addIgnoredMethod(className, data.getMethodName(), data.getMethodDesc());
        return true;
    }
}

