/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.openapi.components.SettingsCategory;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncState;
import com.intellij.settingsSync.config.SettingsSyncSubcategoryDescriptor;
import com.intellij.settingsSync.config.SyncPluginsGroup;
import com.intellij.settingsSync.config.SyncSubcategoryGroup;
import com.intellij.settingsSync.config.SyncUiGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u000fJ\u0006\u0010\u001c\u001a\u00020\u001aR\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00070\b\u00a2\u0006\u0002\b\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/settingsSync/config/SyncCategoryHolder;", "", "descriptor", "Lcom/intellij/settingsSync/config/SyncCategoryHolder$Category;", "state", "Lcom/intellij/settingsSync/SettingsSyncState;", "(Lcom/intellij/settingsSync/config/SyncCategoryHolder$Category;Lcom/intellij/settingsSync/SettingsSyncState;)V", "description", "", "Lorg/jetbrains/annotations/Nls;", "getDescription", "()Ljava/lang/String;", "getDescriptor", "()Lcom/intellij/settingsSync/config/SyncCategoryHolder$Category;", "isSynchronized", "", "()Z", "setSynchronized", "(Z)V", "name", "getName", "secondaryGroup", "Lcom/intellij/settingsSync/config/SyncSubcategoryGroup;", "getSecondaryGroup", "()Lcom/intellij/settingsSync/config/SyncSubcategoryGroup;", "apply", "", "isModified", "reset", "Category", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSyncCategoryHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncCategoryHolder.kt\ncom/intellij/settingsSync/config/SyncCategoryHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1855#2,2:103\n1855#2,2:105\n1855#2,2:107\n*S KotlinDebug\n*F\n+ 1 SyncCategoryHolder.kt\ncom/intellij/settingsSync/config/SyncCategoryHolder\n*L\n29#1:103,2\n39#1:105,2\n52#1:107,2\n*E\n"})
public final class SyncCategoryHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Category descriptor;
    @NotNull
    private final SettingsSyncState state;
    private boolean isSynchronized;

    public SyncCategoryHolder(@NotNull Category descriptor, @NotNull SettingsSyncState state) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.descriptor = descriptor;
        this.state = state;
        this.isSynchronized = this.state.isCategoryEnabled(this.descriptor.getCategory());
    }

    @NotNull
    public final Category getDescriptor() {
        return this.descriptor;
    }

    public final boolean isSynchronized() {
        return this.isSynchronized;
    }

    public final void setSynchronized(boolean bl) {
        this.isSynchronized = bl;
    }

    @NotNull
    public final String getName() {
        return this.descriptor.getName();
    }

    @NotNull
    public final String getDescription() {
        return this.descriptor.getDescription();
    }

    @Nullable
    public final SyncSubcategoryGroup getSecondaryGroup() {
        return this.descriptor.getSecondaryGroup();
    }

    public final void reset() {
        Category $this$reset_u24lambda_u241 = this.descriptor;
        boolean bl = false;
        this.isSynchronized = this.state.isCategoryEnabled($this$reset_u24lambda_u241.getCategory());
        if ($this$reset_u24lambda_u241.getSecondaryGroup() != null) {
            Iterable $this$forEach$iv = $this$reset_u24lambda_u241.getSecondaryGroup().getDescriptors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsSyncSubcategoryDescriptor it = (SettingsSyncSubcategoryDescriptor)element$iv;
                boolean bl2 = false;
                it.setSelected(this.isSynchronized && this.state.isSubcategoryEnabled($this$reset_u24lambda_u241.getCategory(), it.getId()));
            }
        }
    }

    public final void apply() {
        Category $this$apply_u24lambda_u243 = this.descriptor;
        boolean bl = false;
        if ($this$apply_u24lambda_u243.getSecondaryGroup() != null) {
            Iterable $this$forEach$iv = $this$apply_u24lambda_u243.getSecondaryGroup().getDescriptors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsSyncSubcategoryDescriptor it = (SettingsSyncSubcategoryDescriptor)element$iv;
                boolean bl2 = false;
                this.state.setSubcategoryEnabled($this$apply_u24lambda_u243.getCategory(), it.getId(), !this.isSynchronized || it.isSelected());
            }
        }
        this.state.setCategoryEnabled($this$apply_u24lambda_u243.getCategory(), this.isSynchronized);
    }

    public final boolean isModified() {
        Category $this$isModified_u24lambda_u245 = this.descriptor;
        boolean bl = false;
        if (this.isSynchronized != this.state.isCategoryEnabled($this$isModified_u24lambda_u245.getCategory())) {
            return true;
        }
        if ($this$isModified_u24lambda_u245.getSecondaryGroup() != null && this.isSynchronized) {
            Iterable $this$forEach$iv = $this$isModified_u24lambda_u245.getSecondaryGroup().getDescriptors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsSyncSubcategoryDescriptor it = (SettingsSyncSubcategoryDescriptor)element$iv;
                boolean bl2 = false;
                if (it.isSelected() == this.state.isSubcategoryEnabled($this$isModified_u24lambda_u245.getCategory(), it.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00070\n\u00a2\u0006\u0002\b\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0016\u0010\u0010\u001a\u00070\n\u00a2\u0006\u0002\b\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/settingsSync/config/SyncCategoryHolder$Category;", "", "category", "Lcom/intellij/openapi/components/SettingsCategory;", "secondaryGroup", "Lcom/intellij/settingsSync/config/SyncSubcategoryGroup;", "(Lcom/intellij/openapi/components/SettingsCategory;Lcom/intellij/settingsSync/config/SyncSubcategoryGroup;)V", "getCategory", "()Lcom/intellij/openapi/components/SettingsCategory;", "categoryKey", "", "getCategoryKey", "()Ljava/lang/String;", "description", "Lorg/jetbrains/annotations/Nls;", "getDescription", "name", "getName", "getSecondaryGroup", "()Lcom/intellij/settingsSync/config/SyncSubcategoryGroup;", "Companion", "intellij.settingsSync"})
    public static final class Category {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SettingsCategory category;
        @Nullable
        private final SyncSubcategoryGroup secondaryGroup;
        @NotNull
        private static final List<Category> DESCRIPTORS;

        public Category(@NotNull SettingsCategory category, @Nullable SyncSubcategoryGroup secondaryGroup) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.category = category;
            this.secondaryGroup = secondaryGroup;
        }

        public /* synthetic */ Category(SettingsCategory settingsCategory, SyncSubcategoryGroup syncSubcategoryGroup, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                syncSubcategoryGroup = null;
            }
            this(settingsCategory, syncSubcategoryGroup);
        }

        @NotNull
        public final SettingsCategory getCategory() {
            return this.category;
        }

        @Nullable
        public final SyncSubcategoryGroup getSecondaryGroup() {
            return this.secondaryGroup;
        }

        @NotNull
        public final String getName() {
            return SettingsSyncBundle.INSTANCE.message(this.getCategoryKey() + ".name", new Object[0]);
        }

        @NotNull
        public final String getDescription() {
            return SettingsSyncBundle.INSTANCE.message(this.getCategoryKey() + ".description", new Object[0]);
        }

        private final String getCategoryKey() {
            String string = this.category.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return "settings.category." + string2;
        }

        static {
            Object[] objectArray = new Category[]{new Category(SettingsCategory.UI, new SyncUiGroup()), new Category(SettingsCategory.KEYMAP, null, 2, null), new Category(SettingsCategory.CODE, null, 2, null), new Category(SettingsCategory.PLUGINS, new SyncPluginsGroup()), new Category(SettingsCategory.TOOLS, null, 2, null), new Category(SettingsCategory.SYSTEM, null, 2, null)};
            DESCRIPTORS = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/config/SyncCategoryHolder$Category$Companion;", "", "()V", "DESCRIPTORS", "", "Lcom/intellij/settingsSync/config/SyncCategoryHolder$Category;", "getDESCRIPTORS$intellij_settingsSync", "()Ljava/util/List;", "intellij.settingsSync"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<Category> getDESCRIPTORS$intellij_settingsSync() {
                return DESCRIPTORS;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/config/SyncCategoryHolder$Companion;", "", "()V", "createAllForState", "", "Lcom/intellij/settingsSync/config/SyncCategoryHolder;", "state", "Lcom/intellij/settingsSync/SettingsSyncState;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<SyncCategoryHolder> createAllForState(@NotNull SettingsSyncState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            ArrayList<SyncCategoryHolder> retval = new ArrayList<SyncCategoryHolder>();
            for (Category descriptor : Category.Companion.getDESCRIPTORS$intellij_settingsSync()) {
                retval.add(new SyncCategoryHolder(descriptor, state));
            }
            return retval;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

