/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.git.record;

import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0001\u001cB'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/settingsSync/git/record/HistoryRecord;", "", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "isFirstCommit", "", "isLastCommit", "(ILcom/intellij/vcs/log/VcsFullCommitDetails;ZZ)V", "getCommitId", "()I", "id", "Lcom/intellij/vcs/log/Hash;", "Lorg/jetbrains/annotations/NotNull;", "getId", "()Lcom/intellij/vcs/log/Hash;", "()Z", "position", "Lcom/intellij/settingsSync/git/record/HistoryRecord$RecordPosition;", "getPosition", "()Lcom/intellij/settingsSync/git/record/HistoryRecord$RecordPosition;", "time", "", "getTime", "()Ljava/lang/String;", "commitTime", "", "RecordPosition", "Lcom/intellij/settingsSync/git/record/ChangeRecord;", "Lcom/intellij/settingsSync/git/record/MergeRecord;", "intellij.settingsSync.git"})
public abstract class HistoryRecord {
    private final int commitId;
    @NotNull
    private final VcsFullCommitDetails commitDetails;
    private final boolean isFirstCommit;
    @NotNull
    private final Hash id;
    @NotNull
    private final RecordPosition position;

    private HistoryRecord(int commitId, VcsFullCommitDetails commitDetails, boolean isFirstCommit, boolean isLastCommit) {
        this.commitId = commitId;
        this.commitDetails = commitDetails;
        this.isFirstCommit = isFirstCommit;
        Object object = this.commitDetails.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        this.id = (Hash)object;
        this.position = this.isFirstCommit && isLastCommit ? RecordPosition.SINGLE : (this.isFirstCommit ? RecordPosition.BOTTOM : (isLastCommit ? RecordPosition.TOP : RecordPosition.MIDDLE));
    }

    public final int getCommitId() {
        return this.commitId;
    }

    public final boolean isFirstCommit() {
        return this.isFirstCommit;
    }

    @NotNull
    public final Hash getId() {
        return this.id;
    }

    @NotNull
    public final RecordPosition getPosition() {
        return this.position;
    }

    @NotNull
    public final String getTime() {
        return this.getTime(this.commitDetails.getCommitTime());
    }

    @NotNull
    protected final String getTime(long commitTime) {
        String string;
        Date commitTimeDate = new Date(commitTime);
        DateFormat timeFormatter = DateFormat.getTimeInstance(3, Locale.getDefault());
        String timePart = timeFormatter.format(commitTimeDate);
        if (HistoryRecord.getTime$isToday(commitTimeDate)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)timePart);
            objectArray[0] = timePart;
            string = SettingsSyncBundle.INSTANCE.message("ui.toolwindow.time.today", objectArray);
        } else if (HistoryRecord.getTime$isYesterday(commitTimeDate)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)timePart);
            objectArray[0] = timePart;
            string = SettingsSyncBundle.INSTANCE.message("ui.toolwindow.time.yesterday", objectArray);
        } else {
            DateFormat dateFormatter = DateFormat.getDateInstance(2, Locale.getDefault());
            String datePart = dateFormatter.format(commitTimeDate);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)datePart);
            objectArray[0] = datePart;
            Intrinsics.checkNotNull((Object)timePart);
            objectArray[1] = timePart;
            string = SettingsSyncBundle.INSTANCE.message("ui.toolwindow.time.date", objectArray);
        }
        return string;
    }

    private static final boolean getTime$isDateOffsetBy(Date date, int offset) {
        Calendar now = Calendar.getInstance();
        now.add(6, offset);
        Calendar givenTime = Calendar.getInstance();
        givenTime.setTime(date);
        return now.get(1) == givenTime.get(1) && now.get(6) == givenTime.get(6);
    }

    private static final boolean getTime$isToday(Date date) {
        return HistoryRecord.getTime$isDateOffsetBy(date, 0);
    }

    private static final boolean getTime$isYesterday(Date date) {
        return HistoryRecord.getTime$isDateOffsetBy(date, -1);
    }

    public /* synthetic */ HistoryRecord(int commitId, VcsFullCommitDetails commitDetails, boolean isFirstCommit, boolean isLastCommit, DefaultConstructorMarker $constructor_marker) {
        this(commitId, commitDetails, isFirstCommit, isLastCommit);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/git/record/HistoryRecord$RecordPosition;", "", "(Ljava/lang/String;I)V", "SINGLE", "TOP", "MIDDLE", "BOTTOM", "intellij.settingsSync.git"})
    public static final class RecordPosition
    extends Enum<RecordPosition> {
        public static final /* enum */ RecordPosition SINGLE = new RecordPosition();
        public static final /* enum */ RecordPosition TOP = new RecordPosition();
        public static final /* enum */ RecordPosition MIDDLE = new RecordPosition();
        public static final /* enum */ RecordPosition BOTTOM = new RecordPosition();
        private static final /* synthetic */ RecordPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RecordPosition[] values() {
            return (RecordPosition[])$VALUES.clone();
        }

        public static RecordPosition valueOf(String value) {
            return Enum.valueOf(RecordPosition.class, value);
        }

        @NotNull
        public static EnumEntries<RecordPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = recordPositionArray = new RecordPosition[]{RecordPosition.SINGLE, RecordPosition.TOP, RecordPosition.MIDDLE, RecordPosition.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

