/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.settingsSync.RestartForPluginInstall;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.plugins.SettingsSyncPluginInstaller;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0010\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl;", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstaller;", "notifyErrors", "", "(Z)V", "createDownloader", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createDownloader$intellij_settingsSync", "install", "installer", "install$intellij_settingsSync", "installCollected", "", "installers", "", "installPlugins", "pluginsToInstall", "Companion", "PrepareInstallationRunnable", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncPluginInstallerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncPluginInstallerImpl.kt\ncom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n11#2:112\n*S KotlinDebug\n*F\n+ 1 SettingsSyncPluginInstallerImpl.kt\ncom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl\n*L\n19#1:112\n*E\n"})
public class SettingsSyncPluginInstallerImpl
implements SettingsSyncPluginInstaller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean notifyErrors;
    @NotNull
    private static final Logger LOG;

    public SettingsSyncPluginInstallerImpl(boolean notifyErrors) {
        this.notifyErrors = notifyErrors;
    }

    @Override
    @RequiresBackgroundThread
    public void installPlugins(@NotNull List<PluginId> pluginsToInstall) {
        Intrinsics.checkNotNullParameter(pluginsToInstall, (String)"pluginsToInstall");
        if (pluginsToInstall.isEmpty()) {
            return;
        }
        String string = SettingsSyncBundle.INSTANCE.message("installing.plugins.indicator", new Object[0]);
        Task.Backgroundable pluginInstallation2 = new Task.Backgroundable(pluginsToInstall, this, string){
            final /* synthetic */ List<PluginId> $pluginsToInstall;
            final /* synthetic */ SettingsSyncPluginInstallerImpl this$0;
            {
                this.$pluginsToInstall = $pluginsToInstall;
                this.this$0 = $receiver;
                super(null, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                PrepareInstallationRunnable prepareRunnable2 = new PrepareInstallationRunnable(this.$pluginsToInstall, indicator, (Function2<? super PluginId, ? super ProgressIndicator, PluginDownloader>)((Function2)new Function2<PluginId, ProgressIndicator, PluginDownloader>(this.this$0){
                    final /* synthetic */ SettingsSyncPluginInstallerImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @Nullable
                    public final PluginDownloader invoke(@NotNull PluginId pluginId, @NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        return this.this$0.createDownloader$intellij_settingsSync(pluginId, indicator);
                    }
                }));
                prepareRunnable2.run();
                SettingsSyncPluginInstallerImpl.access$installCollected(this.this$0, prepareRunnable2.getInstallers());
            }
        };
        ProgressManager.getInstance().run((Task)pluginInstallation2);
    }

    private final void installCollected(List<PluginDownloader> installers) {
        List pluginsRequiredRestart = new ArrayList();
        boolean settingsChanged = false;
        SettingsSyncSettings settings = SettingsSyncSettings.Companion.getInstance();
        for (PluginDownloader installer : installers) {
            try {
                if (!this.install$intellij_settingsSync(installer)) {
                    String string = installer.getPluginName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPluginName(...)");
                    pluginsRequiredRestart.add(string);
                }
                LOG.info("Setting sync installed plugin ID: " + installer.getId().getIdString());
            }
            catch (Exception ex) {
                LOG.warn("An exception occurred while installing plugin " + installer.getId().getIdString() + ". Will disable syncing this plugin");
                String string = installer.getId().getIdString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
                settings.setSubcategoryEnabled(SettingsCategory.PLUGINS, string, false);
                settingsChanged = true;
            }
        }
        if (settingsChanged) {
            SettingsSyncEvents.Companion.getInstance().fireCategoriesChanged();
        }
        if (pluginsRequiredRestart.size() > 0) {
            SettingsSyncEvents.Companion.getInstance().fireRestartRequired(new RestartForPluginInstall(pluginsRequiredRestart));
        }
    }

    public boolean install$intellij_settingsSync(@NotNull PluginDownloader installer) {
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        return installer.installDynamically(null);
    }

    @Nullable
    public PluginDownloader createDownloader$intellij_settingsSync(@NotNull PluginId pluginId, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        PluginNode descriptor = MarketplaceRequests.getLastCompatiblePluginUpdate$default((MarketplaceRequests)MarketplaceRequests.Companion.getInstance(), (PluginId)pluginId, null, (ProgressIndicator)indicator, (int)2, null);
        if (descriptor != null) {
            PluginDownloader pluginDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)((IdeaPluginDescriptor)descriptor));
            Intrinsics.checkNotNullExpressionValue((Object)pluginDownloader, (String)"createDownloader(...)");
            PluginDownloader downloader = pluginDownloader;
            if (downloader.prepareToInstall(indicator)) {
                return downloader;
            }
        } else {
            Object[] objectArray = new Object[]{pluginId};
            String message = SettingsSyncBundle.INSTANCE.message("install.plugin.failed.no.compatible.notification.error.message", objectArray);
            LOG.info(message);
            if (this.notifyErrors) {
                NotificationGroupManager.getInstance().getNotificationGroup("settingsSync.errors").createNotification("", message, NotificationType.ERROR).notify(null);
            }
        }
        return null;
    }

    public static final /* synthetic */ void access$installCollected(SettingsSyncPluginInstallerImpl $this, List installers) {
        $this.installCollected(installers);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncPluginInstallerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00128\u0010\u0007\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0005\u0012\u0006\u0012\u0004\u0018\u00010\f0\b\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000fj\b\u0012\u0004\u0012\u00020\f`\u0010J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\b\u0010\u0016\u001a\u00020\u0015H\u0017R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000fj\b\u0012\u0004\u0012\u00020\f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RC\u0010\u0007\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0005\u0012\u0006\u0012\u0004\u0018\u00010\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl$PrepareInstallationRunnable;", "Ljava/lang/Runnable;", "pluginIds", "", "Lcom/intellij/openapi/extensions/PluginId;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dwnldPreparer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "pluginId", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "(Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)V", "collectedInstallers", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getDwnldPreparer", "()Lkotlin/jvm/functions/Function2;", "getInstallers", "prepareToInstall", "", "run", "intellij.settingsSync"})
    @SourceDebugExtension(value={"SMAP\nSettingsSyncPluginInstallerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncPluginInstallerImpl.kt\ncom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl$PrepareInstallationRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1855#2,2:112\n*S KotlinDebug\n*F\n+ 1 SettingsSyncPluginInstallerImpl.kt\ncom/intellij/settingsSync/plugins/SettingsSyncPluginInstallerImpl$PrepareInstallationRunnable\n*L\n96#1:112,2\n*E\n"})
    public static final class PrepareInstallationRunnable
    implements Runnable {
        @NotNull
        private final List<PluginId> pluginIds;
        @NotNull
        private final ProgressIndicator indicator;
        @NotNull
        private final Function2<PluginId, ProgressIndicator, PluginDownloader> dwnldPreparer;
        @NotNull
        private final ArrayList<PluginDownloader> collectedInstallers;

        public PrepareInstallationRunnable(@NotNull List<PluginId> pluginIds, @NotNull ProgressIndicator indicator, @NotNull Function2<? super PluginId, ? super ProgressIndicator, PluginDownloader> dwnldPreparer) {
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(dwnldPreparer, (String)"dwnldPreparer");
            this.pluginIds = pluginIds;
            this.indicator = indicator;
            this.dwnldPreparer = dwnldPreparer;
            this.collectedInstallers = new ArrayList();
        }

        @NotNull
        public final Function2<PluginId, ProgressIndicator, PluginDownloader> getDwnldPreparer() {
            return this.dwnldPreparer;
        }

        @Override
        @RequiresBackgroundThread
        public void run() {
            Iterable $this$forEach$iv = this.pluginIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginId it = (PluginId)element$iv;
                boolean bl = false;
                this.prepareToInstall(it, this.indicator);
                this.indicator.checkCanceled();
            }
        }

        @RequiresBackgroundThread
        private final void prepareToInstall(PluginId pluginId, ProgressIndicator indicator) {
            block0: {
                PluginDownloader pluginDownloader;
                PluginDownloader pluginDownloader2 = (PluginDownloader)this.dwnldPreparer.invoke((Object)pluginId, (Object)indicator);
                if (pluginDownloader2 == null) break block0;
                PluginDownloader it = pluginDownloader = pluginDownloader2;
                boolean bl = false;
                this.collectedInstallers.add(it);
            }
        }

        @NotNull
        public final ArrayList<PluginDownloader> getInstallers() {
            return this.collectedInstallers;
        }
    }
}

