/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0010\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a)\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"PARSE_DELAY", "", "githubActionsFilePattern", "Lkotlin/text/Regex;", "getGithubActionsFilePattern", "()Lkotlin/text/Regex;", "githubWorkflowsFilePattern", "isGithubActionFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "isGithubActionsFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isGithubWorkflowFile", "matchesDefaultFilePath", "pattern", "", "(Lcom/intellij/psi/PsiFile;[Lkotlin/text/Regex;)Z", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\ngithubYamlFileDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 githubYamlFileDetection.kt\norg/jetbrains/plugins/github/extensions/GithubYamlFileDetectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n1#2:61\n12474#3,2:62\n*S KotlinDebug\n*F\n+ 1 githubYamlFileDetection.kt\norg/jetbrains/plugins/github/extensions/GithubYamlFileDetectionKt\n*L\n52#1:62,2\n*E\n"})
public final class GithubYamlFileDetectionKt {
    public static final long PARSE_DELAY = 1000L;
    @NotNull
    private static final Regex githubActionsFilePattern = new Regex("^.*(/|^)action\\.ya?ml$");
    @NotNull
    private static final Regex githubWorkflowsFilePattern = new Regex("^.*/\\.github/workflows/.*\\.(ya?ml)$");

    public static final boolean isGithubActionsFile(@NotNull VirtualFile virtualFile, @Nullable Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (project == null) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl2 = false;
            bl = GithubYamlFileDetectionKt.isGithubActionsFile(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isGithubActionsFile(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), () -> GithubYamlFileDetectionKt.isGithubActionsFile$lambda$1(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    public static final boolean isGithubActionFile(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), () -> GithubYamlFileDetectionKt.isGithubActionFile$lambda$2(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    public static final boolean isGithubWorkflowFile(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), () -> GithubYamlFileDetectionKt.isGithubWorkflowFile$lambda$3(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    private static final boolean matchesDefaultFilePath(PsiFile psiFile, Regex ... pattern) {
        boolean bl;
        block2: {
            VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            Regex[] $this$any$iv = pattern;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Regex element$iv;
                Regex it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)virtualFile.getPath(), (long)1000L);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
                if (!it.matches(charSequence)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Regex getGithubActionsFilePattern() {
        return githubActionsFilePattern;
    }

    private static final CachedValueProvider.Result isGithubActionsFile$lambda$1(PsiFile $psiFile) {
        Object[] objectArray = new Regex[]{githubActionsFilePattern, githubWorkflowsFilePattern};
        Boolean bl = GithubYamlFileDetectionKt.matchesDefaultFilePath($psiFile, (Regex[])objectArray);
        objectArray = new Object[]{$psiFile};
        return CachedValueProvider.Result.create((Object)bl, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result isGithubActionFile$lambda$2(PsiFile $psiFile) {
        Object[] objectArray = new Regex[]{githubActionsFilePattern};
        Boolean bl = GithubYamlFileDetectionKt.matchesDefaultFilePath($psiFile, (Regex[])objectArray);
        objectArray = new Object[]{$psiFile};
        return CachedValueProvider.Result.create((Object)bl, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result isGithubWorkflowFile$lambda$3(PsiFile $psiFile) {
        Object[] objectArray = new Regex[]{githubWorkflowsFilePattern};
        Boolean bl = GithubYamlFileDetectionKt.matchesDefaultFilePath($psiFile, (Regex[])objectArray);
        objectArray = new Object[]{$psiFile};
        return CachedValueProvider.Result.create((Object)bl, (Object[])objectArray);
    }
}

