/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.markdown.utils.CodeFenceSyntaxHighlighterGeneratingProvider;
import com.intellij.markdown.utils.MarkdownToHtmlConverter;
import com.intellij.markdown.utils.lang.CodeBlockHtmlSyntaxHighlighter;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.project.Project;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestionHtmlSyntaxHighlighter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u000b\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007J2\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u000b\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u000b\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\u0006\u00a2\u0006\u0002\b\u000bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "convertMarkdown", "", "Lcom/intellij/openapi/util/NlsSafe;", "markdownText", "convertMarkdownWithSuggestedChange", "filePath", "Lorg/jetbrains/annotations/NonNls;", "reviewContent", "GithubFlavourDescriptor", "intellij.vcs.github"})
public final class GHMarkdownToHtmlConverter {
    @Nullable
    private final Project project;

    public GHMarkdownToHtmlConverter(@Nullable Project project) {
        this.project = project;
    }

    @NotNull
    public final String convertMarkdown(@NotNull String markdownText) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        String text = StringsKt.replace$default((String)markdownText, (String)"\r", (String)"", (boolean)false, (int)4, null);
        GithubFlavourDescriptor flavourDescriptor = new GithubFlavourDescriptor((HtmlSyntaxHighlighter)new CodeBlockHtmlSyntaxHighlighter(this.project));
        return new MarkdownToHtmlConverter((MarkdownFlavourDescriptor)flavourDescriptor).convertMarkdownToHtml(text, null);
    }

    @NotNull
    public final String convertMarkdownWithSuggestedChange(@NotNull String markdownText, @NotNull String filePath, @NotNull String reviewContent) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)reviewContent, (String)"reviewContent");
        String text = StringsKt.replace$default((String)markdownText, (String)"\r", (String)"", (boolean)false, (int)4, null);
        GHSuggestionHtmlSyntaxHighlighter htmlSyntaxHighlighter = new GHSuggestionHtmlSyntaxHighlighter(this.project, filePath, reviewContent);
        GithubFlavourDescriptor flavourDescriptor = new GithubFlavourDescriptor(htmlSyntaxHighlighter);
        return new MarkdownToHtmlConverter((MarkdownFlavourDescriptor)flavourDescriptor).convertMarkdownToHtml(text, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter$GithubFlavourDescriptor;", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "(Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;)V", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "intellij.vcs.github"})
    private static final class GithubFlavourDescriptor
    extends GFMFlavourDescriptor {
        @NotNull
        private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;

        public GithubFlavourDescriptor(@NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter) {
            Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
            super(false, false, false, 7, null);
            this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
        }

        @NotNull
        public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
            Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
            Map parentProviders = MapsKt.toMutableMap((Map)super.createHtmlGeneratingProviders(linkMap, baseURI));
            parentProviders.put(MarkdownElementTypes.CODE_FENCE, new CodeFenceSyntaxHighlighterGeneratingProvider(this.htmlSyntaxHighlighter));
            return parentProviders;
        }
    }
}

