/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0016\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0017H\u0016J/\u0010\u0018\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u000f2\u000b\u0010\u0016\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR \u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestionHtmlSyntaxHighlighter;", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "reviewContent", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "coloredReviewChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "getColoredReviewChunk", "()Lcom/intellij/openapi/util/text/HtmlChunk;", "coloredReviewChunk$delegate", "Lkotlin/Lazy;", "fileLanguage", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/NotNull;", "getFileLanguage", "()Lcom/intellij/lang/Language;", "fileLanguage$delegate", "color", "language", "rawContent", "Lcom/intellij/openapi/util/NlsSafe;", "createColoredChunk", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Companion", "intellij.vcs.github"})
public final class GHSuggestionHtmlSyntaxHighlighter
implements HtmlSyntaxHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final String filePath;
    @NotNull
    private final String reviewContent;
    @NotNull
    private final Lazy fileLanguage$delegate;
    @NotNull
    private final Lazy coloredReviewChunk$delegate;

    public GHSuggestionHtmlSyntaxHighlighter(@Nullable Project project, @NotNull String filePath, @NotNull String reviewContent) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)reviewContent, (String)"reviewContent");
        this.project = project;
        this.filePath = filePath;
        this.reviewContent = reviewContent;
        this.fileLanguage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Language>(this){
            final /* synthetic */ GHSuggestionHtmlSyntaxHighlighter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Language invoke() {
                String string = PathUtil.getFileName((String)GHSuggestionHtmlSyntaxHighlighter.access$getFilePath$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                String name = string;
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(name);
                LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
                if (languageFileType == null) {
                    languageFileType = (LanguageFileType)PlainTextFileType.INSTANCE;
                }
                LanguageFileType fileType2 = languageFileType;
                return fileType2.getLanguage();
            }
        }));
        this.coloredReviewChunk$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HtmlChunk>(this){
            final /* synthetic */ GHSuggestionHtmlSyntaxHighlighter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HtmlChunk invoke() {
                Project project = GHSuggestionHtmlSyntaxHighlighter.access$getProject$p(this.this$0);
                Language language = GHSuggestionHtmlSyntaxHighlighter.access$getFileLanguage(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"access$getFileLanguage(...)");
                String string = GHSuggestionHtmlSyntaxHighlighter.Companion.trimStartWithMinIndent(GHSuggestionHtmlSyntaxHighlighter.access$getReviewContent$p(this.this$0));
                TextAttributesKey textAttributesKey = DiffColors.DIFF_DELETED;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_DELETED");
                return GHSuggestionHtmlSyntaxHighlighter.access$createColoredChunk(this.this$0, project, language, string, textAttributesKey);
            }
        }));
    }

    private final Language getFileLanguage() {
        Lazy lazy = this.fileLanguage$delegate;
        return (Language)lazy.getValue();
    }

    private final HtmlChunk getColoredReviewChunk() {
        Lazy lazy = this.coloredReviewChunk$delegate;
        return (HtmlChunk)lazy.getValue();
    }

    @NotNull
    public HtmlChunk color(@Nullable String language, @NotNull String rawContent) {
        Intrinsics.checkNotNullParameter((Object)rawContent, (String)"rawContent");
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(this.getColoredReviewChunk());
        Language language2 = this.getFileLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"<get-fileLanguage>(...)");
        String string = Companion.trimStartWithMinIndent(rawContent);
        TextAttributesKey textAttributesKey = DiffColors.DIFF_INSERTED;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_INSERTED");
        HtmlChunk htmlChunk = htmlBuilder.append(this.createColoredChunk(this.project, language2, string, textAttributesKey)).toFragment();
        Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
        return htmlChunk;
    }

    private final HtmlChunk createColoredChunk(Project project, Language language, String rawContent, TextAttributesKey textAttributesKey) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalOrDefaultColorScheme(...)");
        EditorColorsScheme colorsScheme = editorColorsScheme;
        Color backgroundColor = colorsScheme.getAttributes(textAttributesKey).getBackgroundColor();
        String styles = StringsKt.trimIndent((String)("\n      background-color: " + ColorUtil.toHtmlColor((Color)backgroundColor) + "; \n      margin: 0;\n      padding: " + GHSuggestionHtmlSyntaxHighlighter.Companion.getPADDING() + " " + GHSuggestionHtmlSyntaxHighlighter.Companion.getPADDING() + ";\n    "));
        HtmlChunk.Element element = HtmlChunk.tag((String)"pre").style(styles).child(HtmlSyntaxHighlighter.Companion.colorHtmlChunk(project, language, rawContent));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
        return (HtmlChunk)element;
    }

    public static final /* synthetic */ String access$getFilePath$p(GHSuggestionHtmlSyntaxHighlighter $this) {
        return $this.filePath;
    }

    public static final /* synthetic */ HtmlChunk access$createColoredChunk(GHSuggestionHtmlSyntaxHighlighter $this, Project project, Language language, String rawContent, TextAttributesKey textAttributesKey) {
        return $this.createColoredChunk(project, language, rawContent, textAttributesKey);
    }

    public static final /* synthetic */ Project access$getProject$p(GHSuggestionHtmlSyntaxHighlighter $this) {
        return $this.project;
    }

    public static final /* synthetic */ Language access$getFileLanguage(GHSuggestionHtmlSyntaxHighlighter $this) {
        return $this.getFileLanguage();
    }

    public static final /* synthetic */ String access$getReviewContent$p(GHSuggestionHtmlSyntaxHighlighter $this) {
        return $this.reviewContent;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\bH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestionHtmlSyntaxHighlighter$Companion;", "", "()V", "PADDING", "", "getPADDING", "()I", "trimStartWithMinIndent", "", "Lcom/intellij/openapi/util/NlsSafe;", "text", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final int getPADDING() {
            return JBUI.scale((int)2);
        }

        @VisibleForTesting
        @NotNull
        public final String trimStartWithMinIndent(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Object it = StringsKt.lines((CharSequence)text);
            boolean bl = false;
            Object object = Intrinsics.areEqual((Object)CollectionsKt.last((List)it), (Object)"") ? CollectionsKt.dropLast((List)it, (int)1) : it;
            Object lines = object;
            if (lines.isEmpty()) {
                return text;
            }
            int minIndent = Integer.MAX_VALUE;
            it = lines.iterator();
            while (it.hasNext()) {
                char symbol;
                String line2 = (String)it.next();
                int currentIndent = 0;
                int n = line2.length();
                for (int i = 0; i < n && (symbol = line2.charAt(i)) == ' '; ++i) {
                    ++currentIndent;
                }
                minIndent = Integer.min(minIndent, currentIndent);
            }
            String startIndent = StringsKt.repeat((CharSequence)" ", (int)minIndent);
            return CollectionsKt.joinToString$default((Iterable)((Iterable)lines), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(startIndent){
                final /* synthetic */ String $startIndent;
                {
                    this.$startIndent = $startIndent;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return StringsKt.removePrefix((String)it, (CharSequence)this.$startIndent);
                }
            }), (int)30, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

