/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.actions.InstallVSCodePluginAction;
import org.jetbrains.plugins.textmate.actions.Plugin;
import org.jetbrains.plugins.textmate.configuration.TextMateUserBundlesSettings;
import org.jetbrains.plugins.textmate.plist.JsonPlistReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/textmate/actions/InstallVSCodePluginAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "fetchPlugins", "", "Lorg/jetbrains/plugins/textmate/actions/Plugin;", "install", "project", "Lcom/intellij/openapi/project/Project;", "selectedValue", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "loadPlugins", "reader", "Ljava/io/BufferedReader;", "updateList", "list", "Lcom/intellij/ui/components/JBList;", "model", "Lcom/intellij/ui/SortedListModel;", "intellij.textmate"})
public final class InstallVSCodePluginAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        SortedListModel model2 = new SortedListModel(Comparator.comparing(arg_0 -> InstallVSCodePluginAction.actionPerformed$lambda$0(actionPerformed.model.1.INSTANCE, arg_0)));
        JBList list = new JBList((ListModel)model2);
        this.updateList((JBList<Plugin>)list, (SortedListModel<Plugin>)model2);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)list));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scroll = jScrollPane;
        scroll.setBorder((Border)JBUI.Borders.empty());
        JComponent jComponent = ListWithFilter.wrap((JList)((JList)list), (JScrollPane)scroll, arg_0 -> InstallVSCodePluginAction.actionPerformed$lambda$1(actionPerformed.pane.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"wrap(...)");
        JComponent pane2 = jComponent;
        Component[] componentArray = new Component[]{list};
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(pane2, (JComponent)list).setMayBeParent(true).setRequestFocus(true).setFocusable(true).setFocusOwners(componentArray).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(true).setMovable(true).setResizable(true).setTitle("Install VSCode Plugin").setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).setDimensionServiceKey(project2, "install.vscode.plugin", true).setMinSize(new Dimension(JBUI.scale((int)350), JBUI.scale((int)300))).setCancelButton(new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered));
        Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"setCancelButton(...)");
        ComponentPopupBuilder builder = componentPopupBuilder;
        JBPopup jBPopup = builder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        list.addKeyListener((KeyListener)new KeyAdapter((JBList<Plugin>)list, this, project2, popup){
            final /* synthetic */ JBList<Plugin> $list;
            final /* synthetic */ InstallVSCodePluginAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JBPopup $popup;
            {
                this.$list = $list;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$popup = $popup;
            }

            public void keyPressed(@Nullable KeyEvent e) {
                if (this.$list.getSelectedValue() == null) {
                    return;
                }
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 10 : false;
                if (bl) {
                    e.consume();
                    Object object = this.$list.getSelectedValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSelectedValue(...)");
                    InstallVSCodePluginAction.access$install(this.this$0, this.$project, (Plugin)object, this.$popup);
                }
            }
        });
        new DoubleClickListener((JBList<Plugin>)list, this, project2, popup){
            final /* synthetic */ JBList<Plugin> $list;
            final /* synthetic */ InstallVSCodePluginAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JBPopup $popup;
            {
                this.$list = $list;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$popup = $popup;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$list.getSelectedValue() == null) {
                    return true;
                }
                Object object = this.$list.getSelectedValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSelectedValue(...)");
                InstallVSCodePluginAction.access$install(this.this$0, this.$project, (Plugin)object, this.$popup);
                return true;
            }
        }.installOn((Component)list);
        popup.showCenteredInCurrentWindow(project2);
    }

    private final void updateList(JBList<Plugin> list, SortedListModel<Plugin> model2) {
        list.setPaintBusy(true);
        model2.clear();
        ApplicationManager.getApplication().executeOnPooledThread(() -> InstallVSCodePluginAction.updateList$lambda$3(this, model2, list));
    }

    private final List<Plugin> fetchPlugins() {
        Ref.ObjectRef plugins = new Ref.ObjectRef();
        plugins.element = CollectionsKt.emptyList();
        HttpRequests.request((String)"https://vscode.blob.core.windows.net/gallery/index").connect(arg_0 -> InstallVSCodePluginAction.fetchPlugins$lambda$4(plugins, this, arg_0));
        return (List)plugins.element;
    }

    private final List<Plugin> loadPlugins(BufferedReader reader) {
        List plugins = new ArrayList();
        Object response = JsonPlistReader.createJsonReader().readValue((Reader)reader, Object.class);
        Map map = response instanceof Map ? (Map)response : null;
        Object results = map != null ? map.get("results") : null;
        List list = results instanceof List ? (List)results : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (Object result : list) {
            Map map2 = result instanceof Map ? (Map)result : null;
            Object extensions = map2 != null ? map2.get("extensions") : null;
            List list2 = extensions instanceof List ? (List)extensions : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (Object extension : list2) {
                Map map3 = extension instanceof Map ? (Map)extension : null;
                Object extensionName = map3 != null ? map3.get("extensionName") : null;
                if (!(extensionName instanceof String)) continue;
                Map map4 = extension instanceof Map ? (Map)extension : null;
                Object publisher = map4 != null ? map4.get("publisher") : null;
                Map map5 = publisher instanceof Map ? (Map)publisher : null;
                Object publisherName = map5 != null ? map5.get("publisherName") : null;
                if (!(publisherName instanceof String)) continue;
                Map map6 = extension instanceof Map ? (Map)extension : null;
                Object versions = map6 != null ? map6.get("versions") : null;
                List list3 = versions instanceof List ? (List)versions : null;
                Object version = list3 != null ? CollectionsKt.first((List)list3) : null;
                Map map7 = version instanceof Map ? (Map)version : null;
                Object url = map7 != null ? map7.get("assetUri") : null;
                if (!(url instanceof String)) continue;
                plugins.add(new Plugin((String)extensionName, (String)publisherName, (String)url));
            }
        }
        return plugins;
    }

    private final void install(Project project, Plugin selectedValue, JBPopup popup) {
        popup.closeOk(null);
        String string = "Installing " + selectedValue;
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, selectedValue, string, performInBackgroundOption){
            final /* synthetic */ Plugin $selectedValue;
            {
                this.$selectedValue = $selectedValue;
                super($project, $super_call_param$1, false, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText("Downloading " + this.$selectedValue + "...");
                File file = FileUtil.createTempFile((String)"vscode", (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
                File temp = file;
                DownloadUtil.downloadAtomically((ProgressIndicator)indicator, (String)(this.$selectedValue.getUrl() + "/Microsoft.VisualStudio.Services.VSIXPackage"), (File)temp);
                indicator.setText("Unzipping " + this.$selectedValue + "...");
                Path extensionDir = PathManager.getConfigDir().resolve("vscode").resolve(this.$selectedValue.getName());
                ZipUtil.extract((Path)temp.toPath(), (Path)extensionDir, null);
                indicator.setText("Applying " + this.$selectedValue);
                TextMateUserBundlesSettings textMateUserBundlesSettings = TextMateUserBundlesSettings.Companion.getInstance();
                if (textMateUserBundlesSettings != null) {
                    Path path = extensionDir.resolve("extension");
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                    textMateUserBundlesSettings.addBundle(((Object)path).toString(), this.$selectedValue.toString());
                }
                TextMateService.getInstance().reloadEnabledBundles();
            }
        });
    }

    private static final String actionPerformed$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void updateList$lambda$3$lambda$2(SortedListModel $model, List $plugins, JBList $list) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$plugins, (String)"$plugins");
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        $model.addAll((Collection)$plugins);
        $list.setPaintBusy(false);
    }

    private static final void updateList$lambda$3(InstallVSCodePluginAction this$0, SortedListModel $model, JBList $list) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        List<Plugin> plugins = this$0.fetchPlugins();
        ApplicationManager.getApplication().invokeLater(() -> InstallVSCodePluginAction.updateList$lambda$3$lambda$2($model, plugins, $list));
    }

    private static final Unit fetchPlugins$lambda$4(Ref.ObjectRef $plugins, InstallVSCodePluginAction this$0, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)$plugins, (String)"$plugins");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BufferedReader bufferedReader = request.getReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getReader(...)");
        $plugins.element = this$0.loadPlugins(bufferedReader);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$install(InstallVSCodePluginAction $this, Project project, Plugin selectedValue, JBPopup popup) {
        $this.install(project, selectedValue, popup);
    }
}

