/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.PreciseVerticalScrollHelper;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final long PARSING_CALL_TIMEOUT_MS = 50L;
    private static final long RENDERING_DELAY_MS = 20L;
    public static final Key<WeakReference<MarkdownHtmlPanel>> PREVIEW_BROWSER = Key.create((String)"PREVIEW_BROWSER");
    private final Project myProject;
    private final VirtualFile myFile;
    @Nullable
    private final Document myDocument;
    private final JPanel myHtmlPanelWrapper;
    @Nullable
    private MarkdownHtmlPanel myPanel;
    @Nullable
    private MarkdownHtmlPanelProvider.ProviderInfo myLastPanelProviderInfo;
    private final Alarm myPooledAlarm;
    private final Alarm mySwingAlarm;
    private final Object REQUESTS_LOCK;
    @Nullable
    private Runnable myLastScrollRequest;
    @Nullable
    private Runnable myLastHtmlOrRefreshRequest;
    private volatile int myLastScrollOffset;
    @NotNull
    private String myLastRenderedHtml;
    private Editor mainEditor;
    private boolean isDisposed;

    public MarkdownPreviewFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(1);
        }
        this.myLastPanelProviderInfo = null;
        this.myPooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySwingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.REQUESTS_LOCK = new Object();
        this.myLastScrollRequest = null;
        this.myLastHtmlOrRefreshRequest = null;
        this.myLastRenderedHtml = "";
        this.isDisposed = false;
        this.myProject = project;
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (this.myDocument != null) {
            this.myDocument.addDocumentListener((DocumentListener)new ReparseContentDocumentListener(), (Disposable)this);
        }
        this.myHtmlPanelWrapper = new JPanel(new BorderLayout());
        this.myHtmlPanelWrapper.addComponentListener(new AttachPanelOnVisibilityChangeListener());
        this.attachHtmlPanel();
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        MyUpdatePanelOnSettingsChangedListener settingsChangedListener = new MyUpdatePanelOnSettingsChangedListener();
        messageBusConnection.subscribe(MarkdownSettings.ChangeListener.TOPIC, (Object)settingsChangedListener);
        messageBusConnection.subscribe(MarkdownExtensionsSettings.ChangeListener.TOPIC, fromSettingsDialog -> {
            if (!fromSettingsDialog) {
                this.addImmediateRequest(this.mySwingAlarm, () -> {
                    if (this.myPanel != null) {
                        this.myPanel.reloadWithOffset(this.mainEditor.getCaretModel().getOffset());
                    }
                });
            }
        });
    }

    private void setupScrollHelper() {
        EditorImpl actualEditor = (EditorImpl)ObjectUtils.tryCast((Object)this.mainEditor, EditorImpl.class);
        if (actualEditor == null) {
            return;
        }
        JScrollPane scrollPane = actualEditor.getScrollPane();
        PreciseVerticalScrollHelper helper = new PreciseVerticalScrollHelper(actualEditor, () -> (MarkdownHtmlPanelEx)ObjectUtils.tryCast((Object)this.myPanel, MarkdownHtmlPanelEx.class));
        scrollPane.addMouseWheelListener(helper);
        Disposer.register((Disposable)this, () -> scrollPane.removeMouseWheelListener(helper));
    }

    public void setMainEditor(Editor editor2) {
        this.mainEditor = editor2;
        if (Registry.is((String)"markdown.experimental.boundary.precise.scroll.enable")) {
            this.setupScrollHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToSrcOffset(int offset) {
        if (this.myPanel == null) {
            return;
        }
        if (!this.myPooledAlarm.isEmpty()) {
            this.myLastScrollOffset = offset;
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.mySwingAlarm.isDisposed()) {
                return;
            }
            if (this.myLastScrollRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastScrollRequest);
            }
            this.myLastScrollRequest = () -> {
                if (this.myPanel != null) {
                    this.myLastScrollOffset = offset;
                    this.myPanel.scrollToMarkdownSrcOffset(this.myLastScrollOffset, true);
                    Object object = this.REQUESTS_LOCK;
                    synchronized (object) {
                        this.myLastScrollRequest = null;
                    }
                }
            };
            this.mySwingAlarm.addRequest(this.myLastScrollRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myHtmlPanelWrapper;
        if (jPanel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel != null ? this.myPanel.getComponent() : null;
    }

    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.editor.preview.name", new Object[0]);
        if (string == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (this.myPanel != null) {
            this.updateHtmlPooled();
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        if (this.myPanel != null) {
            this.detachHtmlPanel();
        }
        this.myLastRenderedHtml = "";
        this.isDisposed = true;
    }

    @Nullable
    public MarkdownHtmlPanelProvider.ProviderInfo getLastPanelProviderInfo() {
        return this.myLastPanelProviderInfo;
    }

    @NotNull
    private MarkdownHtmlPanelProvider retrievePanelProvider(@NotNull MarkdownSettings settings) {
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo;
        MarkdownHtmlPanelProvider provider;
        if (settings == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(8);
        }
        if ((provider = MarkdownHtmlPanelProvider.createFromInfo(providerInfo = settings.getPreviewPanelProviderInfo())).isAvailable() != MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE) {
            MarkdownHtmlPanelProvider defaultProvider = MarkdownHtmlPanelProvider.createFromInfo(MarkdownSettings.getDefaultProviderInfo());
            Messages.showMessageDialog((Component)this.myHtmlPanelWrapper, (String)MarkdownBundle.message("dialog.message.tried.to.use.preview.panel.provider", providerInfo.getName()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            MarkdownSettings.getInstance(this.myProject).setPreviewPanelProviderInfo(defaultProvider.getProviderInfo());
            provider = Objects.requireNonNull((MarkdownHtmlPanelProvider)ContainerUtil.find(MarkdownHtmlPanelProvider.getProviders(), p -> p.isAvailable() == MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE));
        }
        this.myLastPanelProviderInfo = settings.getPreviewPanelProviderInfo();
        MarkdownHtmlPanelProvider markdownHtmlPanelProvider = provider;
        if (markdownHtmlPanelProvider == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(9);
        }
        return markdownHtmlPanelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtml() {
        if (this.myPanel == null || this.myDocument == null || !this.myFile.isValid() || this.isDisposed()) {
            return;
        }
        String html2 = (String)ReadAction.nonBlocking(() -> MarkdownUtil.INSTANCE.generateMarkdownHtml(this.myFile, this.myDocument.getText(), this.myProject)).executeSynchronously();
        if (!this.myFile.isValid() || this.isDisposed()) {
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.mySwingAlarm.isDisposed()) {
                return;
            }
            if (this.myLastHtmlOrRefreshRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastHtmlOrRefreshRequest);
            }
            this.myLastHtmlOrRefreshRequest = () -> {
                if (this.myPanel == null) {
                    return;
                }
                String currentHtml = "<html><head></head>" + html2 + "</html>";
                if (!currentHtml.equals(this.myLastRenderedHtml)) {
                    this.myLastRenderedHtml = currentHtml;
                    this.myPanel.setHtml(this.myLastRenderedHtml, this.mainEditor.getCaretModel().getOffset(), this.myFile);
                }
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastHtmlOrRefreshRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastHtmlOrRefreshRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    private void detachHtmlPanel() {
        if (this.myPanel != null) {
            this.myHtmlPanelWrapper.remove(this.myPanel.getComponent());
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
        this.putUserData(PREVIEW_BROWSER, null);
    }

    private void attachHtmlPanel() {
        MarkdownSettings settings = MarkdownSettings.getInstance(this.myProject);
        this.myPanel = this.retrievePanelProvider(settings).createHtmlPanel(this.myProject, this.myFile);
        this.myHtmlPanelWrapper.add((Component)this.myPanel.getComponent(), "Center");
        if (this.myHtmlPanelWrapper.isShowing()) {
            this.myHtmlPanelWrapper.validate();
        }
        this.myHtmlPanelWrapper.repaint();
        this.myLastRenderedHtml = "";
        this.putUserData(PREVIEW_BROWSER, new WeakReference<MarkdownHtmlPanel>(this.myPanel));
        this.updateHtmlPooled();
    }

    private void updateHtmlPooled() {
        this.myPooledAlarm.cancelAllRequests();
        this.myPooledAlarm.addRequest(() -> this.updateHtml(), 0);
    }

    private void addImmediateRequest(@NotNull Alarm alarm, @NotNull Runnable request) {
        if (alarm == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(10);
        }
        if (request == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(11);
        }
        if (!alarm.isDisposed()) {
            alarm.addRequest(request, 0, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "retrievePanelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "retrievePanelProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addImmediateRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 9 -> new IllegalStateException(string);
        };
    }

    private class ReparseContentDocumentListener
    implements DocumentListener {
        private ReparseContentDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            if (event == null) {
                ReparseContentDocumentListener.$$$reportNull$$$0(0);
            }
            MarkdownPreviewFileEditor.this.myPooledAlarm.cancelAllRequests();
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                ReparseContentDocumentListener.$$$reportNull$$$0(1);
            }
            if (!MarkdownPreviewFileEditor.this.myPooledAlarm.isDisposed()) {
                MarkdownPreviewFileEditor.this.myPooledAlarm.addRequest(() -> MarkdownPreviewFileEditor.this.updateHtml(), 50L);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$ReparseContentDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AttachPanelOnVisibilityChangeListener
    extends ComponentAdapter {
        private AttachPanelOnVisibilityChangeListener() {
        }

        @Override
        public void componentShown(ComponentEvent event) {
            MarkdownPreviewFileEditor.this.addImmediateRequest(MarkdownPreviewFileEditor.this.mySwingAlarm, () -> {
                if (MarkdownPreviewFileEditor.this.myPanel == null) {
                    MarkdownPreviewFileEditor.this.attachHtmlPanel();
                }
            });
        }

        @Override
        public void componentHidden(ComponentEvent event) {
            MarkdownPreviewFileEditor.this.addImmediateRequest(MarkdownPreviewFileEditor.this.mySwingAlarm, () -> {
                if (MarkdownPreviewFileEditor.this.myPanel != null) {
                    MarkdownPreviewFileEditor.this.detachHtmlPanel();
                }
            });
        }
    }

    private class MyUpdatePanelOnSettingsChangedListener
    implements MarkdownSettings.ChangeListener {
        private MyUpdatePanelOnSettingsChangedListener() {
        }

        @Override
        public void beforeSettingsChanged(@NotNull MarkdownSettings settings) {
            if (settings == null) {
                MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void settingsChanged(@NotNull MarkdownSettings settings) {
            if (settings == null) {
                MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(1);
            }
            MarkdownPreviewFileEditor.this.addImmediateRequest(MarkdownPreviewFileEditor.this.mySwingAlarm, () -> {
                if (settings.getSplitLayout() != TextEditorWithPreview.Layout.SHOW_EDITOR) {
                    if (MarkdownPreviewFileEditor.this.myPanel == null) {
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    } else if (MarkdownPreviewFileEditor.this.myLastPanelProviderInfo == null || MarkdownHtmlPanelProvider.createFromInfo(MarkdownPreviewFileEditor.this.myLastPanelProviderInfo).equals(MarkdownPreviewFileEditor.this.retrievePanelProvider(settings))) {
                        MarkdownPreviewFileEditor.this.detachHtmlPanel();
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    }
                }
                if (MarkdownPreviewFileEditor.this.myPanel != null) {
                    MarkdownPreviewFileEditor.this.myPanel.reloadWithOffset(MarkdownPreviewFileEditor.this.mainEditor.getCaretModel().getOffset());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$MyUpdatePanelOnSettingsChangedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSettingsChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "settingsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

