/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J:\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/RoundedBorder;", "Ljavax/swing/border/Border;", "unscaledAreaThickness", "", "unscaledThickness", "color", "Ljava/awt/Color;", "backgroundColor", "Lkotlin/Function0;", "unscaledRadius", "(IILjava/awt/Color;Lkotlin/jvm/functions/Function0;I)V", "arcSize", "areaThickness", "thickness", "createArea", "Ljava/awt/geom/Area;", "x", "y", "width", "height", "th", "", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "isBorderOpaque", "", "paintBorder", "", "g", "Ljava/awt/Graphics;", "intellij.ide.startup.importSettings"})
public class RoundedBorder
implements Border {
    @NotNull
    private final Color color;
    @NotNull
    private final Function0<Color> backgroundColor;
    private final int areaThickness;
    private final int thickness;
    private final int arcSize;

    public RoundedBorder(int unscaledAreaThickness, int unscaledThickness, @NotNull Color color, @NotNull Function0<? extends Color> backgroundColor, int unscaledRadius) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(backgroundColor, (String)"backgroundColor");
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.areaThickness = JBUI.scale((int)unscaledAreaThickness);
        this.thickness = JBUI.scale((int)unscaledThickness);
        this.arcSize = JBUI.scale((int)unscaledRadius);
    }

    @Override
    public void paintBorder(@NotNull Component c, @Nullable Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Area area = this.createArea(x, y, width, height, this.arcSize, 0.0);
        Area bkgArea = this.createArea(x, y, width, height, this.arcSize, (double)this.thickness / (double)2);
        ((Graphics2D)g).setColor((Color)this.backgroundColor.invoke());
        ((Graphics2D)g).fill(bkgArea);
        ((Graphics2D)g).setColor(this.color);
        Area innerArea = this.createArea(x, y, width, height, this.arcSize, this.thickness);
        area.subtract(innerArea);
        ((Graphics2D)g).fill(area);
        config.restore();
    }

    private final Area createArea(int x, int y, int width, int height, int arcSize, double th) {
        int innerArc = (int)Math.max((double)arcSize - th, 0.0);
        return new Area(new RoundRectangle2D.Double((double)x + th, (double)y + th, (double)width - (double)2 * th, (double)height - (double)2 * th, innerArc, innerArc));
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@Nullable Component c) {
        JBInsets jBInsets = JBUI.insets((int)this.areaThickness);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

