/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.indices;

import ai.grazie.emb.FloatTextEmbedding;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.platform.ml.embeddings.search.indices.EmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.EmbeddingSearchIndexKt;
import com.intellij.platform.ml.embeddings.search.indices.InMemoryEmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.LocalEmbeddingIndexFileManager;
import com.intellij.platform.ml.embeddings.search.utils.LockedSequenceWrapper;
import com.intellij.platform.ml.embeddings.search.utils.ScoredText;
import com.intellij.util.containers.CollectionFactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\u0011\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u000bH\u0096\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J-\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u00052\b\u0010/\u001a\u0004\u0018\u000100H\u0016\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u00020\u001bH\u0016J\u000e\u00106\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u00103J\u000e\u00107\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u00103J%\u00108\u001a\b\u0012\u0004\u0012\u00020,092\u0006\u0010-\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u000100H\u0016\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/platform/ml/embeddings/search/indices/InMemoryEmbeddingSearchIndex;", "Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;", "root", "Ljava/nio/file/Path;", "limit", "", "(Ljava/nio/file/Path;Ljava/lang/Integer;)V", "fileManager", "Lcom/intellij/platform/ml/embeddings/search/indices/LocalEmbeddingIndexFileManager;", "idToEmbedding", "", "", "Lai/grazie/emb/FloatTextEmbedding;", "value", "getLimit", "()Ljava/lang/Integer;", "setLimit", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "size", "getSize", "()I", "uncheckedIds", "", "addEntries", "", "values", "", "Lkotlin/Pair;", "shouldCount", "", "(Ljava/lang/Iterable;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkCanAddEntry", "clear", "contains", "id", "estimateLimitByMemory", "memory", "", "estimateMemoryUsage", "findClosest", "", "Lcom/intellij/platform/ml/embeddings/search/utils/ScoredText;", "searchEmbedding", "topK", "similarityThreshold", "", "(Lai/grazie/emb/FloatTextEmbedding;ILjava/lang/Double;)Ljava/util/List;", "loadFromDisk", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onIndexingFinish", "onIndexingStart", "save", "saveToDisk", "streamFindClose", "Lkotlin/sequences/Sequence;", "(Lai/grazie/emb/FloatTextEmbedding;Ljava/lang/Double;)Lkotlin/sequences/Sequence;", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nInMemoryEmbeddingSearchIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryEmbeddingSearchIndex.kt\ncom/intellij/platform/ml/embeddings/search/indices/InMemoryEmbeddingSearchIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1#2:103\n1855#3,2:104\n*S KotlinDebug\n*F\n+ 1 InMemoryEmbeddingSearchIndex.kt\ncom/intellij/platform/ml/embeddings/search/indices/InMemoryEmbeddingSearchIndex\n*L\n53#1:104,2\n*E\n"})
public final class InMemoryEmbeddingSearchIndex
implements EmbeddingSearchIndex {
    @NotNull
    private Map<String, FloatTextEmbedding> idToEmbedding;
    @NotNull
    private final Set<String> uncheckedIds;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final LocalEmbeddingIndexFileManager fileManager;
    @Nullable
    private Integer limit;

    public InMemoryEmbeddingSearchIndex(@NotNull Path root, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        this.idToEmbedding = map2;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.uncheckedIds = set;
        this.lock = new ReentrantReadWriteLock();
        this.fileManager = new LocalEmbeddingIndexFileManager(root, 0, 2, null);
        this.limit = limit;
    }

    public /* synthetic */ InMemoryEmbeddingSearchIndex(Path path, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(path, n);
    }

    @Override
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLimit(@Nullable Integer value) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (value != null && value < this.idToEmbedding.size()) {
                this.idToEmbedding = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)CollectionsKt.take((Iterable)MapsKt.toList(this.idToEmbedding), (int)value)));
            }
            this.limit = value;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.idToEmbedding.size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@NotNull String id) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            this.uncheckedIds.remove(id);
            bl = this.idToEmbedding.containsKey(id);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.idToEmbedding.clear();
            this.uncheckedIds.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    public void onIndexingStart() {
        this.uncheckedIds.clear();
        this.uncheckedIds.addAll((Collection<String>)this.idToEmbedding.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIndexingFinish() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = this.uncheckedIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                this.idToEmbedding.remove(it);
            }
            this.uncheckedIds.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object addEntries(@NotNull Iterable<Pair<String, FloatTextEmbedding>> values, boolean shouldCount, @NotNull Continuation<? super Unit> $completion) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.getLimit() != null) {
                List list = CollectionsKt.toList(values);
                Iterable iterable = list;
                Integer n2 = this.getLimit();
                Intrinsics.checkNotNull((Object)n2);
                MapsKt.putAll(this.idToEmbedding, (Iterable)CollectionsKt.take((Iterable)iterable, (int)Math.min(n2 - this.idToEmbedding.size(), list.size())));
            } else {
                MapsKt.putAll(this.idToEmbedding, values);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object saveToDisk(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof saveToDisk.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ InMemoryEmbeddingSearchIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveToDisk((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this.lock.readLock();
                var2_5.lock();
                $i$a$-read-InMemoryEmbeddingSearchIndex$saveToDisk$2 = false;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = this.save((Continuation<? super Unit>)$continuation);
                ** if (v0 != var6_4) goto lbl22
lbl21:
                // 1 sources

                return var6_4;
lbl22:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                $i$a$-read-InMemoryEmbeddingSearchIndex$saveToDisk$2 = false;
                var2_5 = (ReentrantReadWriteLock.ReadLock)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    var3_8 = Unit.INSTANCE;
                }
                catch (Throwable var3_9) {
                    throw var3_9;
                }
                finally {
                    var2_5.unlock();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object loadFromDisk(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof loadFromDisk.1)) ** GOTO lbl-1000
        var12_2 = var1_1;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ InMemoryEmbeddingSearchIndex this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadFromDisk((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this.lock;
                var3_6 = var2_5.readLock();
                var4_7 = var2_5.getWriteHoldCount() == 0 ? var2_5.getReadHoldCount() : 0;
                for (var5_8 = 0; var5_8 < var4_7; ++var5_8) {
                    var3_6.unlock();
                }
                var5_9 = var2_5.writeLock();
                var5_9.lock();
                $i$a$-write-InMemoryEmbeddingSearchIndex$loadFromDisk$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = var3_6;
                $continuation.L$2 = var5_9;
                $continuation.I$0 = var4_7;
                $continuation.label = 1;
                v0 = this.fileManager.loadIndex((Continuation<? super Pair<? extends List<String>, ? extends List<FloatTextEmbedding>>>)$continuation);
                ** if (v0 != var13_4) goto lbl31
lbl30:
                // 1 sources

                return var13_4;
lbl31:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                $i$a$-write-InMemoryEmbeddingSearchIndex$loadFromDisk$2 = false;
                var4_7 = $continuation.I$0;
                var5_9 = (ReentrantReadWriteLock.WriteLock)$continuation.L$2;
                var3_6 = (ReentrantReadWriteLock.ReadLock)$continuation.L$1;
                this = (InMemoryEmbeddingSearchIndex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl42:
                // 2 sources

                if ((Pair)v0 == null) {
                    var10_13 = Unit.INSTANCE;
                    return var10_13;
                }
                var8_18 = v1;
                ids = (List)var8_18.component1();
                embeddings = (List)var8_18.component2();
                this.idToEmbedding = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)ids, (Iterable)embeddings)));
                var6_11 = Unit.INSTANCE;
                ** GOTO lbl60
            }
            catch (Throwable var6_12) {
                throw var6_12;
            }
            {
                finally {
                    for (var7_14 = 0; var7_14 < var4_7; ++var7_14) {
                        var3_6.lock();
                    }
                    var5_9.unlock();
                }
lbl60:
                // 1 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ScoredText> findClosest(@NotNull FloatTextEmbedding searchEmbedding, int topK, @Nullable Double similarityThreshold) {
        Intrinsics.checkNotNullParameter((Object)searchEmbedding, (String)"searchEmbedding");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            List<ScoredText> list = EmbeddingSearchIndexKt.findClosest(this.idToEmbedding, searchEmbedding, topK, similarityThreshold);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    @NotNull
    public Sequence<ScoredText> streamFindClose(@NotNull FloatTextEmbedding searchEmbedding, @Nullable Double similarityThreshold) {
        Intrinsics.checkNotNullParameter((Object)searchEmbedding, (String)"searchEmbedding");
        return new LockedSequenceWrapper((Function0<? extends Lock>)((Function0)new Function0<ReentrantReadWriteLock.ReadLock>((Object)this.lock){

            public final ReentrantReadWriteLock.ReadLock invoke() {
                return ((ReentrantReadWriteLock)this.receiver).readLock();
            }
        }), (Function0)new Function0<Sequence<? extends ScoredText>>(this, searchEmbedding, similarityThreshold){
            final /* synthetic */ InMemoryEmbeddingSearchIndex this$0;
            final /* synthetic */ FloatTextEmbedding $searchEmbedding;
            final /* synthetic */ Double $similarityThreshold;
            {
                this.this$0 = $receiver;
                this.$searchEmbedding = $searchEmbedding;
                this.$similarityThreshold = $similarityThreshold;
                super(0);
            }

            @NotNull
            public final Sequence<ScoredText> invoke() {
                return EmbeddingSearchIndexKt.streamFindClose((Sequence<Pair<String, FloatTextEmbedding>>)SequencesKt.map((Sequence)MapsKt.asSequence((Map)InMemoryEmbeddingSearchIndex.access$getIdToEmbedding$p(this.this$0)), (Function1)streamFindClose.1.INSTANCE), this.$searchEmbedding, this.$similarityThreshold);
            }
        });
    }

    @Override
    public long estimateMemoryUsage() {
        return (long)this.fileManager.getEmbeddingSizeInBytes() * (long)this.getSize();
    }

    @Override
    public int estimateLimitByMemory(long memory) {
        return (int)(memory / (long)this.fileManager.getEmbeddingSizeInBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean checkCanAddEntry() {
        var1_1 = this.lock.readLock();
        var1_1.lock();
        try {
            $i$a$-read-InMemoryEmbeddingSearchIndex$checkCanAddEntry$1 = false;
            if (this.getLimit() == null) ** GOTO lbl-1000
            v0 = this.idToEmbedding.size();
            v1 = this.getLimit();
            Intrinsics.checkNotNull((Object)v1);
            if (v0 < v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            var3_4 = v2;
            return var3_4;
        }
        finally {
            var1_1.unlock();
        }
    }

    private final Object save(Continuation<? super Unit> $completion) {
        Pair pair = CollectionsKt.unzip((Iterable)MapsKt.toList(this.idToEmbedding));
        List ids = (List)pair.component1();
        List embeddings = (List)pair.component2();
        Object object = this.fileManager.saveIndex(ids, embeddings, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Map access$getIdToEmbedding$p(InMemoryEmbeddingSearchIndex $this) {
        return $this.idToEmbedding;
    }

    public static final /* synthetic */ Object access$save(InMemoryEmbeddingSearchIndex $this, Continuation $completion) {
        return $this.save((Continuation<? super Unit>)$completion);
    }
}

