/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.pointers.LongPointer;
import io.kinference.ndarray.arrays.pointers.LongPointerKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0000J\u0016\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\"\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\f2\b\b\u0002\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u0003J\u0011\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0003J\u0019\u0010-\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\fH\u0086\u0002J\u0006\u0010.\u001a\u00020\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u00060"}, d2={"Lio/kinference/ndarray/arrays/tiled/LongTiledArray;", "", "size", "", "blockSize", "(II)V", "blocks", "", "", "([[J)V", "init", "Lkotlin/Function1;", "", "(IILkotlin/jvm/functions/Function1;)V", "getBlockSize", "()I", "getBlocks", "()[[J", "[[J", "blocksNum", "getBlocksNum", "getSize", "copyInto", "", "dest", "destOffset", "srcStart", "srcEnd", "copyOf", "copyOfRange", "fromIndex", "toIndex", "fill", "value", "from", "to", "get", "i", "indexFor", "Lkotlin/Pair;", "plus", "other", "pointer", "Lio/kinference/ndarray/arrays/pointers/LongPointer;", "startIndex", "set", "toArray", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nLongTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongTiledArray.kt\nio/kinference/ndarray/arrays/tiled/LongTiledArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LongPointer.kt\nio/kinference/ndarray/arrays/pointers/LongPointerKt\n*L\n1#1,183:1\n1#2:184\n1#2:186\n1#2:218\n1052#3:185\n1054#3,30:187\n1052#3:217\n1054#3,30:219\n*S KotlinDebug\n*F\n+ 1 LongTiledArray.kt\nio/kinference/ndarray/arrays/tiled/LongTiledArray\n*L\n142#1:186\n148#1:218\n142#1:185\n142#1:187,30\n148#1:217\n148#1:219,30\n*E\n"})
public final class LongTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private final long[][] blocks;

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final long[][] getBlocks() {
        return this.blocks;
    }

    public LongTiledArray(int size2, int blockSize) {
        if (blockSize != 0 && !(size2 % blockSize == 0)) {
            boolean bl = false;
            String string = "Size must divide blockSize";
            throw new IllegalArgumentException(string.toString());
        }
        this.blocksNum = blockSize == 0 ? 0 : size2 / blockSize;
        int n = 0;
        int n2 = this.blocksNum;
        long[][] lArrayArray = new long[n2][];
        LongTiledArray longTiledArray = this;
        while (n < n2) {
            int n3 = n++;
            lArrayArray[n3] = new long[blockSize];
        }
        longTiledArray.blocks = lArrayArray;
        this.blockSize = blockSize;
        this.size = size2;
    }

    public LongTiledArray(@NotNull long[][] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = ((Object[])blocks).length == 0 ? 0 : ((long[])ArraysKt.first((Object[])((Object[])blocks))).length;
        this.blocksNum = ((Object[])blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    public LongTiledArray(int size2, int blockSize, @NotNull Function1<? super Integer, Long> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(size2, blockSize);
        int count = 0;
        long[][] lArray = this.blocks;
        int n = ((Object[])lArray).length;
        for (int i = 0; i < n; ++i) {
            long[] block = lArray[i];
            for (int idx = 0; idx < blockSize; ++idx) {
                block[idx] = ((Number)init.invoke((Object)count++)).longValue();
            }
        }
    }

    @NotNull
    public final LongPointer pointer(int startIndex2) {
        return new LongPointer(this, startIndex2);
    }

    public static /* synthetic */ LongPointer pointer$default(LongTiledArray longTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return longTiledArray.pointer(n);
    }

    @NotNull
    public final long[] toArray() {
        if (this.size == 0) {
            return new long[0];
        }
        long[] array = new long[this.size];
        int offset = 0;
        long[][] lArray = this.blocks;
        int n = ((Object[])lArray).length;
        for (int i = 0; i < n; ++i) {
            long[] block = lArray[i];
            ArraysKt.copyInto$default((long[])block, (long[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    public final long get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, long value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    @NotNull
    public final LongTiledArray copyOf() {
        LongTiledArray copyArray = new LongTiledArray(this.size, this.blockSize);
        int n = this.blocksNum;
        for (int blockNum = 0; blockNum < n; ++blockNum) {
            long[] thisBlock = this.blocks[blockNum];
            long[] destBlock = copyArray.blocks[blockNum];
            ArraysKt.copyInto$default((long[])thisBlock, (long[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
        }
        return copyArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull LongTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        LongPointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        LongPointer thisPtr = new LongPointer(this, srcStart);
        LongPointer longPointer = destPtr = new LongPointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!LongPointerKt.isCompatibleBySize((LongPointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-LongPointerKt$accept$4$iv22 = false;
            String $i$a$-require-LongPointerKt$accept$4$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-LongPointerKt$accept$4$iv22.toString());
        }
        if (LongPointerKt.isCompatibleWith((LongPointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            long[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                long[] srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    long cfr_ignored_0 = dstBlock$iv[index$iv];
                    long l2 = srcBlock$iv[index$iv];
                    int n2 = index$iv++;
                    long[] lArray = dstBlock$iv;
                    boolean bl = false;
                    void var22_26 = src;
                    lArray[n2] = var22_26;
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                long src = thisPtr.getAndIncrement();
                void var19_23 = $this$accept$iv;
                boolean bl = false;
                long l3 = src;
                var19_23.set(l3);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(LongTiledArray longTiledArray, LongTiledArray longTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = longTiledArray.size;
        }
        longTiledArray.copyInto(longTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LongTiledArray plus(@NotNull LongTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LongPointer thisPtr = new LongPointer(this, 0, 2, null);
        LongPointer destPtr = new LongPointer(other, 0, 2, null);
        LongPointer longPointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!LongPointerKt.isCompatibleBySize((LongPointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-LongPointerKt$accept$4$iv22 = false;
            String $i$a$-require-LongPointerKt$accept$4$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-LongPointerKt$accept$4$iv22.toString());
        }
        if (LongPointerKt.isCompatibleWith((LongPointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            long[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                long[] srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    long l2 = srcBlock$iv[index$iv];
                    long l3 = dstBlock$iv[index$iv];
                    int n2 = index$iv++;
                    long[] lArray = dstBlock$iv;
                    boolean bl = false;
                    void var21_25 = src + dst;
                    lArray[n2] = var21_25;
                }
            }
        } else {
            while (end$iv > 0) {
                long dst = destPtr.getAndIncrement();
                long src = $this$accept$iv.get();
                void var18_22 = $this$accept$iv;
                boolean bl = false;
                long l4 = src + dst;
                var18_22.set(l4);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final long[] copyOfRange(int fromIndex, int toIndex) {
        long[] array = new long[toIndex - fromIndex];
        LongPointer pointer = new LongPointer(this, fromIndex);
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = pointer.getAndIncrement();
        }
        return array;
    }

    public final void fill(long value, int from, int to) {
        if (from == to) {
            return;
        }
        LongPointer pointer = new LongPointer(this, from);
        for (int count = to - from; count > 0; count -= this.blockSize) {
            long[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            ArraysKt.fill((long[])block, (long)value, (int)offset, (int)Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(LongTiledArray longTiledArray, long l2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = longTiledArray.size;
        }
        longTiledArray.fill(l2, n, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a8\u0006\u0010"}, d2={"Lio/kinference/ndarray/arrays/tiled/LongTiledArray$Companion;", "", "()V", "invoke", "Lio/kinference/ndarray/arrays/tiled/LongTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "init", "Lkotlin/Function1;", "", "", "array", "", "shape", "", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nLongTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongTiledArray.kt\nio/kinference/ndarray/arrays/tiled/LongTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongTiledArray invoke(@NotNull Strides strides2) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new LongTiledArray(strides2.getLinearSize(), blockSize);
        }

        @NotNull
        public final LongTiledArray invoke(@NotNull Strides strides2, @NotNull Function1<? super Integer, Long> init) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new LongTiledArray(strides2.getLinearSize(), blockSize, init);
        }

        @NotNull
        public final LongTiledArray invoke(@NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return this.invoke(new Strides(shape));
        }

        @NotNull
        public final LongTiledArray invoke(@NotNull int[] shape, @NotNull Function1<? super Integer, Long> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @NotNull
        public final LongTiledArray invoke(@NotNull Strides strides2, @NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            int countBlocks = array.length / blockSize;
            int n = 0;
            long[][] lArrayArray = new long[countBlocks][];
            while (n < countBlocks) {
                int n2 = n++;
                lArrayArray[n2] = new long[blockSize];
            }
            long[][] blocksArray = lArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                ArraysKt.copyInto$default((long[])array, (long[])blocksArray[blockNum], (int)0, (int)(blockNum * blockSize), (int)((blockNum + 1) * blockSize), (int)2, null);
            }
            return new LongTiledArray(blocksArray);
        }

        @NotNull
        public final LongTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, Long> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-LongTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-LongTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-LongTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            long[][] lArrayArray = new long[blocksNum][];
            while (n < blocksNum) {
                int n2 = n++;
                lArrayArray[n2] = new long[blockSize];
            }
            long[][] blocks = lArrayArray;
            int n3 = ((Object[])blocks).length;
            for (n = 0; n < n3; ++n) {
                long[] block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block[idx] = ((Number)init.invoke((Object)count++)).longValue();
                }
            }
            return new LongTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

