/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.hardmax;

import io.kinference.ndarray.arrays.DoubleNDArray;
import io.kinference.ndarray.arrays.MutableDoubleNDArray;
import io.kinference.ndarray.arrays.NDArrayUtilsKt;
import io.kinference.ndarray.extensions.NumberExtensionKt;
import io.kinference.ndarray.extensions.constants.DoubleConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"hardmax", "Lio/kinference/ndarray/arrays/DoubleNDArray;", "axis", "", "ndarray-core"})
public final class HardmaxDoubleKt {
    @NotNull
    public static final DoubleNDArray hardmax(@NotNull DoubleNDArray $this$hardmax, int axis2) {
        Intrinsics.checkNotNullParameter((Object)$this$hardmax, (String)"<this>");
        MutableDoubleNDArray output = new MutableDoubleNDArray($this$hardmax.getStrides());
        int actualAxis = NDArrayUtilsKt.indexAxis($this$hardmax, axis2);
        int rows = NDArrayUtilsKt.computeBlockSize$default($this$hardmax, 0, actualAxis, 1, null);
        int columns = NDArrayUtilsKt.computeBlockSize$default($this$hardmax, actualAxis, 0, 2, null);
        int blockSize = $this$hardmax.getArray().getBlockSize();
        int blocksPerColumn = columns / blockSize;
        double[][] inputBlocks = $this$hardmax.getArray().getBlocks();
        double[][] outputBlocks = output.getArray().getBlocks();
        for (int i = 0; i < rows; ++i) {
            int startBlockOffset;
            int row = i;
            boolean bl = false;
            double maxValue = NumberExtensionKt.getMIN_VALUE_FOR_MAX(DoubleCompanionObject.INSTANCE);
            int maxBlockIdx = 0;
            int maxIndex = 0;
            int n = startBlockOffset + blocksPerColumn;
            for (int blockIdx = startBlockOffset = blocksPerColumn * row; blockIdx < n; ++blockIdx) {
                double[] block = inputBlocks[blockIdx];
                int n2 = block.length;
                for (int idx = 0; idx < n2; ++idx) {
                    if (!(block[idx] > maxValue)) continue;
                    maxValue = block[idx];
                    maxIndex = idx;
                    maxBlockIdx = blockIdx;
                }
            }
            outputBlocks[maxBlockIdx][maxIndex] = DoubleConstants.INSTANCE.getONE();
        }
        return output;
    }

    public static /* synthetic */ DoubleNDArray hardmax$default(DoubleNDArray doubleNDArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return HardmaxDoubleKt.hardmax(doubleNDArray, n);
    }
}

