/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.protobuf.arrays;

import io.kinference.ndarray.extensions.ArrayFactoriesKt;
import io.kinference.protobuf.ProtobufReader;
import io.kinference.protobuf.arrays.ArrayContainer;
import io.kinference.protobuf.arrays.PrimitiveArraySerializer;
import io.kinference.protobuf.arrays.TiledArraySerializer;
import io.kinference.protobuf.message.TensorProto;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/kinference/protobuf/arrays/TiledArrayContainer;", "Lio/kinference/protobuf/arrays/ArrayContainer;", "()V", "_array", "", "array", "getArray", "()Ljava/lang/Object;", "tiled", "tiledInitialized", "", "decode", "", "reader", "Lio/kinference/protobuf/ProtobufReader;", "tag", "", "dataType", "Lio/kinference/protobuf/message/TensorProto$DataType;", "shape", "", "get", "hasData", "setData", "newArray", "serializer-tiled"})
public final class TiledArrayContainer
implements ArrayContainer {
    @Nullable
    private Object _array;
    @Nullable
    private Object tiled;
    private boolean tiledInitialized;

    @Override
    @Nullable
    public Object getArray() {
        return this.tiled;
    }

    @Override
    public boolean hasData() {
        return this.getArray() != null || this.tiled != null;
    }

    @Override
    public void setData(@NotNull Object newArray) {
        Intrinsics.checkNotNullParameter((Object)newArray, (String)"newArray");
        this.tiled = newArray;
        this.tiledInitialized = true;
    }

    @Override
    public void decode(@NotNull ProtobufReader reader, int tag, @NotNull TensorProto.DataType dataType, @Nullable int[] shape) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        if (shape != null) {
            this.tiled = TiledArraySerializer.Companion.tiledSerializer(dataType).decode(reader, shape, tag);
            this.tiledInitialized = true;
        } else {
            this._array = PrimitiveArraySerializer.Companion.arraySerializer(dataType).decode(reader, tag);
        }
    }

    @Override
    @Nullable
    public Object get(@NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (!this.hasData()) {
            return null;
        }
        if (!this.tiledInitialized) {
            Object object = this.getArray();
            Intrinsics.checkNotNull((Object)object);
            this.tiled = ArrayFactoriesKt.tiledFromPrimitiveArray(shape, object);
            this._array = null;
            this.tiledInitialized = true;
        }
        Object object = this.tiled;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }
}

