/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.cache;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.h2.mvstore.DataUtils;

public class CacheLongKeyLIRS<V> {
    private long maxMemory;
    private final Segment<V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;
    private final int nonResidentQueueSize;
    private final int nonResidentQueueSizeHigh;

    public CacheLongKeyLIRS(Config config) {
        this.setMaxMemory(config.maxMemory);
        this.nonResidentQueueSize = config.nonResidentQueueSize;
        this.nonResidentQueueSizeHigh = config.nonResidentQueueSizeHigh;
        DataUtils.checkArgument(Integer.bitCount(config.segmentCount) == 1, "The segment count must be a power of 2, is {0}", config.segmentCount);
        this.segmentCount = config.segmentCount;
        this.segmentMask = this.segmentCount - 1;
        this.stackMoveDistance = config.stackMoveDistance;
        this.segments = new Segment[this.segmentCount];
        this.clear();
        this.segmentShift = 32 - Integer.bitCount(this.segmentMask);
    }

    public void clear() {
        long l2 = this.getMaxItemSize();
        for (int i = 0; i < this.segmentCount; ++i) {
            this.segments[i] = new Segment(l2, this.stackMoveDistance, 8, this.nonResidentQueueSize, this.nonResidentQueueSizeHigh);
        }
    }

    public long getMaxItemSize() {
        return Math.max(1L, this.maxMemory / (long)this.segmentCount);
    }

    private Entry<V> find(long l2) {
        int n = CacheLongKeyLIRS.getHash(l2);
        return this.getSegment(n).find(l2, n);
    }

    public boolean containsKey(long l2) {
        Entry<V> entry2 = this.find(l2);
        return entry2 != null && entry2.value != null;
    }

    public V peek(long l2) {
        Entry<V> entry2 = this.find(l2);
        return entry2 == null ? null : (V)entry2.getValue();
    }

    public V put(long l2, V v) {
        return this.put(l2, v, this.sizeOf(v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(long l2, V v, long l3) {
        Segment<V> segment;
        if (v == null) {
            throw DataUtils.newIllegalArgumentException("The value may not be null", new Object[0]);
        }
        int n = CacheLongKeyLIRS.getHash(l2);
        int n2 = this.getSegmentIndex(n);
        Segment<V> segment2 = segment = this.segments[n2];
        synchronized (segment2) {
            segment = this.resizeIfNeeded(segment, n2);
            return segment.put(l2, n, v, l3);
        }
    }

    private Segment<V> resizeIfNeeded(Segment<V> segment, int n) {
        int n2 = segment.getNewMapLen();
        if (n2 == 0) {
            return segment;
        }
        Segment<V> segment2 = this.segments[n];
        if (segment == segment2) {
            segment = new Segment<V>(segment, n2);
            this.segments[n] = segment;
        }
        return segment;
    }

    protected long sizeOf(V v) {
        return 16L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long l2) {
        Segment<V> segment;
        int n = CacheLongKeyLIRS.getHash(l2);
        int n2 = this.getSegmentIndex(n);
        Segment<V> segment2 = segment = this.segments[n2];
        synchronized (segment2) {
            segment = this.resizeIfNeeded(segment, n2);
            return segment.remove(l2, n);
        }
    }

    public long getMemory(long l2) {
        Entry<V> entry2 = this.find(l2);
        return entry2 == null ? 0L : entry2.getMemory();
    }

    public static int getMemoryOverhead() {
        return 112;
    }

    public V get(long l2) {
        int n = CacheLongKeyLIRS.getHash(l2);
        Segment<V> segment = this.getSegment(n);
        Entry<V> entry2 = segment.find(l2, n);
        return segment.get(entry2);
    }

    private Segment<V> getSegment(int n) {
        return this.segments[this.getSegmentIndex(n)];
    }

    private int getSegmentIndex(int n) {
        return n >>> this.segmentShift & this.segmentMask;
    }

    static int getHash(long l2) {
        int n = (int)(l2 >>> 32 ^ l2);
        n = (n >>> 16 ^ n) * 73244475;
        n = (n >>> 16 ^ n) * 73244475;
        n = n >>> 16 ^ n;
        return n;
    }

    public long getUsedMemory() {
        long l2 = 0L;
        for (Segment<V> segment : this.segments) {
            l2 += segment.usedMemory;
        }
        return l2;
    }

    public void setMaxMemory(long l2) {
        DataUtils.checkArgument(l2 > 0L, "Max memory must be larger than 0, is {0}", l2);
        this.maxMemory = l2;
        if (this.segments != null) {
            long l3 = 1L + l2 / (long)this.segments.length;
            for (Segment<V> segment : this.segments) {
                segment.setMaxMemory(l3);
            }
        }
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public synchronized Set<Map.Entry<Long, V>> entrySet() {
        return this.getMap().entrySet();
    }

    public Set<Long> keySet() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Segment<V> segment : this.segments) {
            hashSet.addAll(segment.keySet());
        }
        return hashSet;
    }

    public int sizeNonResident() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.queue2Size;
        }
        return n;
    }

    public int sizeMapArray() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.entries.length;
        }
        return n;
    }

    public int sizeHot() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.mapSize - segment.queueSize - segment.queue2Size;
        }
        return n;
    }

    public long getHits() {
        long l2 = 0L;
        for (Segment<V> segment : this.segments) {
            l2 += segment.hits;
        }
        return l2;
    }

    public long getMisses() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n = (int)((long)n + segment.misses);
        }
        return n;
    }

    public int size() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.mapSize - segment.queue2Size;
        }
        return n;
    }

    public List<Long> keys(boolean bl, boolean bl2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Segment<V> segment : this.segments) {
            arrayList.addAll(segment.keys(bl, bl2));
        }
        return arrayList;
    }

    public List<V> values() {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (long l2 : this.keySet()) {
            V v = this.peek(l2);
            if (v == null) continue;
            arrayList.add(v);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(V v) {
        return this.getMap().containsValue(v);
    }

    public Map<Long, V> getMap() {
        HashMap<Long, V> hashMap = new HashMap<Long, V>();
        for (long l2 : this.keySet()) {
            V v = this.peek(l2);
            if (v == null) continue;
            hashMap.put(l2, v);
        }
        return hashMap;
    }

    public void putAll(Map<Long, ? extends V> map2) {
        for (Map.Entry<Long, V> entry2 : map2.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimNonResidentQueue() {
        Segment<V>[] segmentArray = this.segments;
        int n = segmentArray.length;
        for (int i = 0; i < n; ++i) {
            Segment<V> segment;
            Segment<V> segment2 = segment = segmentArray[i];
            synchronized (segment2) {
                segment.trimNonResidentQueue();
                continue;
            }
        }
    }

    public static class Config {
        public long maxMemory = 1L;
        public int segmentCount = 16;
        public int stackMoveDistance = 32;
        public final int nonResidentQueueSize = 3;
        public final int nonResidentQueueSizeHigh = 12;
    }

    static class Entry<V> {
        static final int TOTAL_MEMORY_OVERHEAD = 112;
        final long key;
        V value;
        WeakReference<V> reference;
        final long memory;
        int topMove;
        Entry<V> stackNext;
        Entry<V> stackPrev;
        Entry<V> queueNext;
        Entry<V> queuePrev;
        Entry<V> mapNext;

        Entry() {
            this(0L, null, 0L);
        }

        Entry(long l2, V v, long l3) {
            this.key = l2;
            this.memory = l3 + 112L;
            this.value = v;
        }

        Entry(Entry<V> entry2) {
            this.key = entry2.key;
            this.memory = entry2.memory;
            this.value = entry2.value;
            this.reference = entry2.reference;
            this.topMove = entry2.topMove;
        }

        boolean isHot() {
            return this.queueNext == null;
        }

        V getValue() {
            return (V)(this.value == null ? this.reference.get() : this.value);
        }

        long getMemory() {
            return this.value == null ? 0L : this.memory;
        }
    }

    private static class Segment<V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        long hits;
        long misses;
        final Entry<V>[] entries;
        long usedMemory;
        private final int stackMoveDistance;
        private long maxMemory;
        private final int mask;
        private final int nonResidentQueueSize;
        private final int nonResidentQueueSizeHigh;
        private final Entry<V> stack;
        private int stackSize;
        private final Entry<V> queue;
        private final Entry<V> queue2;
        private int stackMoveCounter;

        Segment(long l2, int n, int n2, int n3, int n4) {
            this.setMaxMemory(l2);
            this.stackMoveDistance = n;
            this.nonResidentQueueSize = n3;
            this.nonResidentQueueSizeHigh = n4;
            this.mask = n2 - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            Entry[] entryArray = new Entry[n2];
            this.entries = entryArray;
        }

        Segment(Segment<V> segment, int n) {
            this(segment.maxMemory, segment.stackMoveDistance, n, segment.nonResidentQueueSize, segment.nonResidentQueueSizeHigh);
            Entry entry2;
            this.hits = segment.hits;
            this.misses = segment.misses;
            Entry entry3 = segment.stack.stackPrev;
            while (entry3 != segment.stack) {
                entry2 = new Entry(entry3);
                super.addToMap(entry2);
                super.addToStack(entry2);
                entry3 = entry3.stackPrev;
            }
            entry3 = segment.queue.queuePrev;
            while (entry3 != segment.queue) {
                entry2 = this.find(entry3.key, CacheLongKeyLIRS.getHash(entry3.key));
                if (entry2 == null) {
                    entry2 = new Entry(entry3);
                    super.addToMap(entry2);
                }
                super.addToQueue(this.queue, entry2);
                entry3 = entry3.queuePrev;
            }
            entry3 = segment.queue2.queuePrev;
            while (entry3 != segment.queue2) {
                entry2 = this.find(entry3.key, CacheLongKeyLIRS.getHash(entry3.key));
                if (entry2 == null) {
                    entry2 = new Entry(entry3);
                    super.addToMap(entry2);
                }
                super.addToQueue(this.queue2, entry2);
                entry3 = entry3.queuePrev;
            }
        }

        int getNewMapLen() {
            int n = this.mask + 1;
            if (n * 3 < this.mapSize * 4 && n < 0x10000000) {
                return n * 2;
            }
            if (n > 32 && n / 8 > this.mapSize) {
                return n / 2;
            }
            return 0;
        }

        private void addToMap(Entry<V> entry2) {
            int n = CacheLongKeyLIRS.getHash(entry2.key) & this.mask;
            entry2.mapNext = this.entries[n];
            this.entries[n] = entry2;
            this.usedMemory += entry2.getMemory();
            ++this.mapSize;
        }

        synchronized V get(Entry<V> entry2) {
            V v;
            V v2 = v = entry2 == null ? null : (V)entry2.getValue();
            if (v == null) {
                ++this.misses;
            } else {
                this.access(entry2);
                ++this.hits;
            }
            return v;
        }

        private void access(Entry<V> entry2) {
            if (entry2.isHot()) {
                if (entry2 != this.stack.stackNext && entry2.stackNext != null && this.stackMoveCounter - entry2.topMove > this.stackMoveDistance) {
                    boolean bl = entry2 == this.stack.stackPrev;
                    this.removeFromStack(entry2);
                    if (bl) {
                        this.pruneStack();
                    }
                    this.addToStack(entry2);
                }
            } else {
                V v = entry2.getValue();
                if (v != null) {
                    this.removeFromQueue(entry2);
                    if (entry2.reference != null) {
                        entry2.value = v;
                        entry2.reference = null;
                        this.usedMemory += entry2.memory;
                    }
                    if (entry2.stackNext != null) {
                        this.removeFromStack(entry2);
                        this.convertOldestHotToCold();
                    } else {
                        this.addToQueue(this.queue, entry2);
                    }
                    this.addToStack(entry2);
                    this.pruneStack();
                }
            }
        }

        synchronized V put(long l2, int n, V v, long l3) {
            Entry<V> entry2 = this.find(l2, n);
            boolean bl = entry2 != null;
            V v2 = null;
            if (bl) {
                v2 = entry2.getValue();
                this.remove(l2, n);
            }
            if (l3 + 112L > this.maxMemory) {
                return v2;
            }
            entry2 = new Entry<V>(l2, v, l3);
            int n2 = n & this.mask;
            entry2.mapNext = this.entries[n2];
            this.entries[n2] = entry2;
            this.usedMemory += entry2.memory;
            if (this.usedMemory > this.maxMemory) {
                this.evict();
                if (this.stackSize > 0) {
                    this.addToQueue(this.queue, entry2);
                }
            }
            ++this.mapSize;
            this.addToStack(entry2);
            if (bl) {
                this.access(entry2);
            }
            return v2;
        }

        synchronized V remove(long l2, int n) {
            Entry<V> entry2;
            int n2 = n & this.mask;
            Entry<V> entry3 = this.entries[n2];
            if (entry3 == null) {
                return null;
            }
            if (entry3.key == l2) {
                this.entries[n2] = entry3.mapNext;
            } else {
                do {
                    entry2 = entry3;
                    entry3 = entry3.mapNext;
                    if (entry3 != null) continue;
                    return null;
                } while (entry3.key != l2);
                entry2.mapNext = entry3.mapNext;
            }
            entry2 = entry3.getValue();
            --this.mapSize;
            this.usedMemory -= entry3.getMemory();
            if (entry3.stackNext != null) {
                this.removeFromStack(entry3);
            }
            if (entry3.isHot()) {
                entry3 = this.queue.queueNext;
                if (entry3 != this.queue) {
                    this.removeFromQueue(entry3);
                    if (entry3.stackNext == null) {
                        this.addToStackBottom(entry3);
                    }
                }
                this.pruneStack();
            } else {
                this.removeFromQueue(entry3);
            }
            return (V)entry2;
        }

        private void evict() {
            do {
                this.evictBlock();
            } while (this.usedMemory > this.maxMemory);
        }

        private void evictBlock() {
            while (this.queueSize <= this.mapSize - this.queue2Size >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 0) {
                Entry entry2 = this.queue.queuePrev;
                this.usedMemory -= entry2.memory;
                this.removeFromQueue(entry2);
                entry2.reference = new WeakReference(entry2.value);
                entry2.value = null;
                this.addToQueue(this.queue2, entry2);
                this.trimNonResidentQueue();
            }
        }

        void trimNonResidentQueue() {
            int n = this.mapSize - this.queue2Size;
            int n2 = this.nonResidentQueueSizeHigh * n;
            int n3 = this.nonResidentQueueSize * n;
            while (this.queue2Size > n3) {
                WeakReference weakReference;
                Entry entry2 = this.queue2.queuePrev;
                if (this.queue2Size <= n2 && (weakReference = entry2.reference) != null && weakReference.get() != null) break;
                int n4 = CacheLongKeyLIRS.getHash(entry2.key);
                this.remove(entry2.key, n4);
            }
        }

        private void convertOldestHotToCold() {
            Entry entry2 = this.stack.stackPrev;
            if (entry2 == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(entry2);
            this.addToQueue(this.queue, entry2);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry entry2;
            while (!(entry2 = this.stack.stackPrev).isHot()) {
                this.removeFromStack(entry2);
            }
        }

        Entry<V> find(long l2, int n) {
            int n2 = n & this.mask;
            Entry<V> entry2 = this.entries[n2];
            while (entry2 != null && entry2.key != l2) {
                entry2 = entry2.mapNext;
            }
            return entry2;
        }

        private void addToStack(Entry<V> entry2) {
            entry2.stackPrev = this.stack;
            entry2.stackNext = this.stack.stackNext;
            entry2.stackNext.stackPrev = entry2;
            this.stack.stackNext = entry2;
            ++this.stackSize;
            entry2.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<V> entry2) {
            entry2.stackNext = this.stack;
            entry2.stackPrev = this.stack.stackPrev;
            entry2.stackPrev.stackNext = entry2;
            this.stack.stackPrev = entry2;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<V> entry2) {
            entry2.stackPrev.stackNext = entry2.stackNext;
            entry2.stackNext.stackPrev = entry2.stackPrev;
            entry2.stackNext = null;
            entry2.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<V> entry2, Entry<V> entry3) {
            entry3.queuePrev = entry2;
            entry3.queueNext = entry2.queueNext;
            entry3.queueNext.queuePrev = entry3;
            entry2.queueNext = entry3;
            if (entry3.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<V> entry2) {
            entry2.queuePrev.queueNext = entry2.queueNext;
            entry2.queueNext.queuePrev = entry2.queuePrev;
            entry2.queueNext = null;
            entry2.queuePrev = null;
            if (entry2.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<Long> keys(boolean bl, boolean bl2) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (bl) {
                Entry<V> entry2 = bl2 ? this.queue2 : this.queue;
                Entry entry3 = entry2.queueNext;
                while (entry3 != entry2) {
                    arrayList.add(entry3.key);
                    entry3 = entry3.queueNext;
                }
            } else {
                Entry entry4 = this.stack.stackNext;
                while (entry4 != this.stack) {
                    arrayList.add(entry4.key);
                    entry4 = entry4.stackNext;
                }
            }
            return arrayList;
        }

        synchronized Set<Long> keySet() {
            HashSet<Long> hashSet = new HashSet<Long>();
            Entry entry2 = this.stack.stackNext;
            while (entry2 != this.stack) {
                hashSet.add(entry2.key);
                entry2 = entry2.stackNext;
            }
            entry2 = this.queue.queueNext;
            while (entry2 != this.queue) {
                hashSet.add(entry2.key);
                entry2 = entry2.queueNext;
            }
            return hashSet;
        }

        void setMaxMemory(long l2) {
            this.maxMemory = l2;
        }
    }
}

