/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.loader;

import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.util.lang.PathClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;

public final class IntellijLoader {
    private static final String RUNTIME_REPOSITORY_PATH_PROPERTY = "intellij.platform.runtime.repository.path";

    public static void main(String[] args) throws Throwable {
        long startTimeNano = System.nanoTime();
        long startTimeUnixNano = System.currentTimeMillis() * 1000000L;
        ArrayList<Object> startupTimings = new ArrayList<Object>(16);
        startupTimings.add("startup begin");
        startupTimings.add(startTimeNano);
        String repositoryPathString = System.getProperty(RUNTIME_REPOSITORY_PATH_PROPERTY);
        if (repositoryPathString == null) {
            IntellijLoader.reportError("intellij.platform.runtime.repository.path is not specified");
        }
        RuntimeModuleRepository repository = RuntimeModuleRepository.create(Path.of(repositoryPathString, new String[0]).toAbsolutePath());
        List<Path> bootstrapClasspath = repository.getBootstrapClasspath("intellij.platform.bootstrap");
        startupTimings.add("calculating bootstrap classpath");
        startupTimings.add(System.nanoTime());
        ClassLoader appClassLoader = IntellijLoader.class.getClassLoader();
        if (!(appClassLoader instanceof PathClassLoader)) {
            IntellijLoader.reportError("JVM for IntelliJ must be started with -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader parameter");
        }
        ((PathClassLoader)appClassLoader).getClassPath().addFiles(bootstrapClasspath);
        String bootstrapClassName = "com.intellij.platform.bootstrap.ModularMain";
        Class<?> bootstrapClass = Class.forName(bootstrapClassName, true, appClassLoader);
        MethodHandle methodHandle = MethodHandles.publicLookup().findStatic(bootstrapClass, "main", MethodType.methodType(Void.TYPE, RuntimeModuleRepository.class, String[].class, ArrayList.class, Long.TYPE));
        startupTimings.add("obtaining main method handle");
        startupTimings.add(System.nanoTime());
        methodHandle.invokeExact(repository, args, startupTimings, startTimeUnixNano);
    }

    @Contract(value="_ -> fail")
    private static void reportError(String message) {
        System.err.println(message);
        System.exit(3);
    }
}

