/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes;

import com.vladsch.flexmark.ast.LinkRendered;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.util.ast.DelimitedNode;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.ReferencingNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class Footnote
extends Node
implements DelimitedNode,
DoNotDecorate,
LinkRendered,
ReferencingNode<FootnoteRepository, FootnoteBlock> {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected FootnoteBlock footnoteBlock;
    protected int referenceOrdinal;

    public int getReferenceOrdinal() {
        return this.referenceOrdinal;
    }

    public void setReferenceOrdinal(int referenceOrdinal) {
        this.referenceOrdinal = referenceOrdinal;
    }

    @Override
    @NotNull
    public BasedSequence getReference() {
        return this.text;
    }

    @Override
    public FootnoteBlock getReferenceNode(Document document2) {
        if (this.footnoteBlock != null || this.text.isEmpty()) {
            return this.footnoteBlock;
        }
        this.footnoteBlock = this.getFootnoteBlock(FootnoteExtension.FOOTNOTES.get(document2));
        return this.footnoteBlock;
    }

    @Override
    public FootnoteBlock getReferenceNode(FootnoteRepository repository) {
        if (this.footnoteBlock != null || this.text.isEmpty()) {
            return this.footnoteBlock;
        }
        this.footnoteBlock = this.getFootnoteBlock(repository);
        return this.footnoteBlock;
    }

    @Override
    public boolean isDefined() {
        return this.footnoteBlock != null;
    }

    @Override
    public boolean isTentative() {
        return this.footnoteBlock == null;
    }

    public FootnoteBlock getFootnoteBlock(FootnoteRepository footnoteRepository) {
        return this.text.isEmpty() ? null : (FootnoteBlock)footnoteRepository.get(this.text.toString());
    }

    public FootnoteBlock getFootnoteBlock() {
        return this.footnoteBlock;
    }

    public void setFootnoteBlock(FootnoteBlock footnoteBlock) {
        this.footnoteBlock = footnoteBlock;
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        out.append(" ordinal: ").append(this.footnoteBlock != null ? this.footnoteBlock.getFootnoteOrdinal() : 0).append(" ");
        Footnote.delimitedSegmentSpanChars(out, this.openingMarker, this.text, this.closingMarker, "text");
    }

    public Footnote() {
    }

    public Footnote(BasedSequence chars) {
        super(chars);
    }

    public Footnote(BasedSequence openingMarker, BasedSequence text2, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.text = text2;
        this.closingMarker = closingMarker;
    }

    @Override
    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    @Override
    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    @Override
    public BasedSequence getText() {
        return this.text;
    }

    @Override
    public void setText(BasedSequence text2) {
        this.text = text2;
    }

    @Override
    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    @Override
    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

