/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.RomanNumeral;

public enum NumberFormat {
    NONE,
    ARABIC,
    LETTERS,
    ROMAN,
    CUSTOM;


    public static String getFormat(NumberFormat format2, int count) {
        switch (format2) {
            case NONE: {
                return "";
            }
            case ARABIC: {
                return String.valueOf(count);
            }
            case LETTERS: {
                if (count < 1) {
                    throw new NumberFormatException("Letter format count must be > 0, actual " + count);
                }
                return NumberFormat.getFormat(count - 1, "abcdefghijklmnopqrstuvwxyz");
            }
            case ROMAN: {
                return new RomanNumeral(count).toString();
            }
            case CUSTOM: {
                throw new IllegalStateException("CounterFormat.CUSTOM has to use custom conversion, possibly by calling getFormat(int count, CharSequence digitSet)");
            }
        }
        return "";
    }

    public static String getFormat(int count, CharSequence digitSet) {
        int next;
        StringBuilder sb = new StringBuilder(10);
        int base = digitSet.length();
        do {
            next = count / base;
            int dig = count - next * base;
            sb.append(digitSet.charAt(dig));
        } while ((count = next) > 0);
        int iMax = sb.length();
        StringBuilder out = new StringBuilder(iMax);
        int i = iMax;
        while (i-- > 0) {
            out.append(sb.charAt(i));
        }
        return out.toString();
    }
}

