/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmpbox.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmpbox.xml.XmpParsingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DomHelper {
    private DomHelper() {
    }

    public static Element getUniqueElementChild(Element description2) throws XmpParsingException {
        NodeList nl = description2.getChildNodes();
        int pos = -1;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            if (pos >= 0) {
                throw new XmpParsingException(XmpParsingException.ErrorType.Undefined, "Found two child elements in " + description2);
            }
            pos = i;
        }
        return (Element)nl.item(pos);
    }

    public static Element getFirstChildElement(Element description2) throws XmpParsingException {
        NodeList nl = description2.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static List<Element> getElementChildren(Element description2) throws XmpParsingException {
        NodeList nl = description2.getChildNodes();
        ArrayList<Element> ret = new ArrayList<Element>(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            ret.add((Element)nl.item(i));
        }
        return ret;
    }

    public static QName getQName(Element element2) {
        return new QName(element2.getNamespaceURI(), element2.getLocalName(), element2.getPrefix());
    }

    public static boolean isRdfDescription(Element element2) {
        return "rdf".equals(element2.getPrefix()) && "Description".equals(element2.getLocalName());
    }

    public static boolean isParseTypeResource(Element element2) {
        Attr parseType = element2.getAttributeNodeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
        return parseType != null && "Resource".equals(parseType.getValue());
    }
}

