/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.AnimatedIcon;
import icons.QodanaIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.inspectionKts.ui.InspectionKtsBannerViewModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/inspectionKts/ui/CompilationStatusAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "viewModel", "Lorg/jetbrains/qodana/inspectionKts/ui/InspectionKtsBannerViewModel;", "(Lorg/jetbrains/qodana/inspectionKts/ui/InspectionKtsBannerViewModel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionIcon", "Ljavax/swing/Icon;", "compilationStatus", "Lorg/jetbrains/qodana/inspectionKts/ui/InspectionKtsBannerViewModel$CompilationStatus;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.qodana"})
public final class CompilationStatusAction
extends AnAction
implements DumbAware {
    @NotNull
    private final InspectionKtsBannerViewModel viewModel;

    public CompilationStatusAction(@NotNull InspectionKtsBannerViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.viewModel = viewModel;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InspectionKtsBannerViewModel.CompilationStatus compilationStatus2 = (InspectionKtsBannerViewModel.CompilationStatus)this.viewModel.getCompilationStatus().getValue();
        if (compilationStatus2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Icon icon = this.getActionIcon(compilationStatus2);
        e.getPresentation().setText("");
        e.getPresentation().setIcon(this.getActionIcon(compilationStatus2));
        e.getPresentation().setDisabledIcon(icon);
        e.getPresentation().setEnabled(false);
        if (compilationStatus2 instanceof InspectionKtsBannerViewModel.CompilationStatus.Failed) {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setText(QodanaBundle.message("inspectionKts.open.log", new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = this.viewModel.getCompilationStatus().getValue();
        InspectionKtsBannerViewModel.CompilationStatus.Failed failed = object instanceof InspectionKtsBannerViewModel.CompilationStatus.Failed ? (InspectionKtsBannerViewModel.CompilationStatus.Failed)object : null;
        if (failed == null) {
            return;
        }
        InspectionKtsBannerViewModel.CompilationStatus.Failed failed2 = failed;
        failed2.getOpenExceptionInLogAction().invoke();
    }

    private final Icon getActionIcon(InspectionKtsBannerViewModel.CompilationStatus compilationStatus2) {
        Icon icon;
        InspectionKtsBannerViewModel.CompilationStatus compilationStatus3 = compilationStatus2;
        if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Cancelled) {
            Icon icon2 = AllIcons.Actions.Cancel;
            Intrinsics.checkNotNull((Object)icon2);
            icon = icon2;
        } else if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Compiling) {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNull((Object)animatedIcon);
            icon = (Icon)animatedIcon;
        } else if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Failed) {
            Icon icon3 = ((InspectionKtsBannerViewModel.CompilationStatus.Failed)compilationStatus2).isOutdated() ? QodanaIcons.Icons.InspectionKts.ErrorOutdated : QodanaIcons.Icons.InspectionKts.Error;
            Intrinsics.checkNotNull((Object)icon3);
            icon = icon3;
        } else if (compilationStatus3 instanceof InspectionKtsBannerViewModel.CompilationStatus.Compiled) {
            Icon icon4 = ((InspectionKtsBannerViewModel.CompilationStatus.Compiled)compilationStatus2).isOutdated() ? QodanaIcons.Icons.InspectionKts.OkOutdated : QodanaIcons.Icons.InspectionKts.OK;
            Intrinsics.checkNotNull((Object)icon4);
            icon = icon4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return icon;
    }
}

