/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.assertj.core.util.Preconditions;

final class RotatingQueue<T>
extends AbstractQueue<T> {
    private final Queue<T> data;
    private final int capacity;

    RotatingQueue(int capacity) {
        Preconditions.checkArgument(capacity >= 0, "capacity must be non-negative but was %d", capacity);
        this.capacity = capacity;
        this.data = new LinkedList<T>();
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean offer(T element2) {
        if (this.capacity == 0) {
            return false;
        }
        if (this.data.size() == this.capacity) {
            this.data.remove();
        }
        return this.data.add(element2);
    }

    @Override
    public T poll() {
        return this.data.poll();
    }

    @Override
    public T peek() {
        return this.data.peek();
    }
}

