/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.AbstractComponentMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public abstract class GenericTypeMatcher<T extends Component>
extends AbstractComponentMatcher {
    private final Class<T> supportedType;

    public GenericTypeMatcher(@Nonnull Class<T> supportedType) {
        this(supportedType, false);
    }

    public GenericTypeMatcher(@Nonnull Class<T> supportedType, boolean requireShowing) {
        super(requireShowing);
        this.supportedType = Preconditions.checkNotNull(supportedType);
    }

    @Override
    @RunsInCurrentThread
    public final boolean matches(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        if (!this.supportedType.isInstance(c)) {
            return false;
        }
        try {
            return this.requireShowingMatches(c) && this.isMatching((Component)this.supportedType.cast(c));
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }

    @Nonnull
    public final Class<T> supportedType() {
        return this.supportedType;
    }

    @RunsInCurrentThread
    protected abstract boolean isMatching(@Nonnull T var1);
}

