/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.exception.ActionFailedException;

final class Actions {
    @Nonnull
    static Object findActionKey(@Nonnull String name, @Nonnull ActionMap actionMap) {
        Action action = actionMap.get(name);
        if (action != null) {
            return name;
        }
        Object[] allKeys = actionMap.allKeys();
        if (allKeys != null) {
            for (Object key : allKeys) {
                action = actionMap.get(key);
                if (!name.equals(action.getValue("Name"))) continue;
                return Preconditions.checkNotNull(key);
            }
        }
        String message = String.format("The action '%s' is not available", name);
        if (allKeys != null && allKeys.length > 0) {
            message = Strings.concat(message, ", available actions:", Actions.formatAllActionKeys(allKeys));
        }
        throw ActionFailedException.actionFailure(message);
    }

    @Nonnull
    private static List<String> formatAllActionKeys(@Nonnull Object[] keys) {
        ArrayList<String> formattedKeys = Lists.newArrayList();
        for (Object key : keys) {
            String keyAsString = Actions.keyAsString(key);
            if (keyAsString == null) continue;
            formattedKeys.add(keyAsString);
        }
        Collections.sort(formattedKeys);
        return formattedKeys;
    }

    @Nullable
    private static String keyAsString(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return (String)Strings.quote(key);
        }
        return String.format("%s(%s)", key.toString(), key.getClass().getName());
    }

    private Actions() {
    }
}

