/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.ChangedRangesShifter;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.model.ModelPatch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesBrowser;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsFacadeImpl
extends VcsFacade {
    @NotNull
    public static VcsFacadeImpl getVcsInstance() {
        VcsFacadeImpl vcsFacadeImpl = (VcsFacadeImpl)VcsFacade.getInstance();
        if (vcsFacadeImpl == null) {
            VcsFacadeImpl.$$$reportNull$$$0(0);
        }
        return vcsFacadeImpl;
    }

    public boolean hasActiveVcss(@NotNull Project project2) {
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(1);
        }
        return ProjectLevelVcsManager.getInstance(project2).hasActiveVcss();
    }

    public boolean hasChanges(@NotNull PsiFile file) {
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(2);
        }
        Project project2 = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance(project2).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public boolean hasChanges(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(4);
        }
        Collection<Change> changes2 = ChangeListManager.getInstance(project2).getChangesIn(file);
        for (Change change : changes2) {
            if (change.getType() == Change.Type.DELETED) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Boolean isFileUnderVcs(@NotNull PsiFile psiFile2) {
        ProjectLevelVcsManager vcsManager2;
        if (psiFile2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(5);
        }
        Boolean bl = (vcsManager2 = ProjectLevelVcsManager.getInstance(psiFile2.getProject())).getVcsFor(psiFile2.getVirtualFile()) != null;
        if (bl == null) {
            VcsFacadeImpl.$$$reportNull$$$0(6);
        }
        return bl;
    }

    @NotNull
    public Set<String> getVcsIgnoreFileNames(@NotNull Project project2) {
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(7);
        }
        Set<String> set = VcsUtil.getVcsIgnoreFileNames(project2);
        if (set == null) {
            VcsFacadeImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file) {
        CharSequence testContent;
        List trackerRanges;
        Project project2;
        Document document2;
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(9);
        }
        if ((document2 = PsiDocumentManager.getInstance((Project)(project2 = file.getProject())).getDocument(file)) == null) {
            return null;
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(document2);
        List list2 = trackerRanges = tracker != null ? tracker.getRanges() : null;
        if (trackerRanges != null) {
            return VcsFacadeImpl.getChangedRangesInfo(document2, trackerRanges);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsFacadeImpl.getChangedRangesInfo(document2, VcsFacadeImpl.computeRanges(document2, testContent));
        }
        Change change = ChangeListManager.getInstance(project2).getChange(file.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file.getTextRange();
            return new ChangedRangesInfo(List.of(fileRange), null);
        }
        String contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change.getBeforeRevision());
        if (contentFromVcs == null) {
            return null;
        }
        return VcsFacadeImpl.getChangedRangesInfo(document2, VcsFacadeImpl.computeRanges(document2, contentFromVcs));
    }

    @NotNull
    public List<PsiFile> getChangedFilesFromDirs(@NotNull Project project2, @NotNull List<? extends PsiDirectory> psiDirs) {
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(10);
        }
        if (psiDirs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(11);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        Collection<Change> allChanges = changeListManager.getAllChanges();
        List dirs = ContainerUtil.map(psiDirs, dir -> dir.getVirtualFile());
        List changes2 = VcsImplUtil.filterChangesUnderFiles(allChanges, dirs).toList();
        return VcsFacadeImpl.getChangedFiles(project2, changes2);
    }

    @NotNull
    private static List<PsiFile> getChangedFiles(@NotNull Project project2, @NotNull Collection<? extends Change> changes2) {
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(12);
        }
        if (changes2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(13);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        List list2 = ContainerUtil.mapNotNull(changes2, change -> {
            VirtualFile vFile = change.getVirtualFile();
            return vFile != null ? psiManager.findFile(vFile) : null;
        });
        if (list2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public <T extends PsiElement> List<T> getLocalChangedElements(@NotNull Project project2, @NotNull Change change, @NotNull Function<? super VirtualFile, ? extends List<T>> elementExtractor2) {
        List elements;
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(15);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(16);
        }
        if (elementExtractor2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(17);
        }
        if (change.getType() == Change.Type.DELETED) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(18);
            }
            return list2;
        }
        if (!(change.getAfterRevision() instanceof CurrentContentRevision)) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(19);
            }
            return list3;
        }
        VirtualFile file = ((CurrentContentRevision)change.getAfterRevision()).getVirtualFile();
        if (file == null) {
            List list4 = Collections.emptyList();
            if (list4 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(20);
            }
            return list4;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(file);
        if (document2 == null) {
            List list5 = Collections.emptyList();
            if (list5 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(21);
            }
            return list5;
        }
        List apply2 = (List)elementExtractor2.fun((Object)file);
        List list6 = elements = apply2 == null ? null : ContainerUtil.skipNulls((Collection)apply2);
        if (ContainerUtil.isEmpty((Collection)elements)) {
            List list7 = Collections.emptyList();
            if (list7 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(22);
            }
            return list7;
        }
        if (change.getType() == Change.Type.NEW) {
            List list8 = elements;
            if (list8 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(23);
            }
            return list8;
        }
        List<? extends com.intellij.openapi.vcs.ex.Range> ranges = VcsFacadeImpl.getChangedRangesFromLineStatusTracker(project2, document2, change);
        if (ranges == null) {
            ranges = VcsFacadeImpl.getChangedRangesFromBeforeRevision(document2, change);
        }
        if (ranges == null) {
            List list9 = elements;
            if (list9 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(24);
            }
            return list9;
        }
        BitSet changedLines = VcsFacadeImpl.createChangedLinesBitSet(ranges);
        List list10 = ContainerUtil.filter((Collection)elements, element -> VcsFacadeImpl.isElementChanged(element, document2, changedLines));
        if (list10 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(25);
        }
        return list10;
    }

    @NotNull
    public <T extends PsiElement> List<T> getPostCommitChangedElements(@NotNull Project project2, @NotNull Change change, @NotNull Function<? super VirtualFile, ? extends List<T>> elementExtractor2) {
        List elements;
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(26);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(27);
        }
        if (elementExtractor2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(28);
        }
        if (change.getType() == Change.Type.DELETED) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(29);
            }
            return list2;
        }
        VirtualFile file = ChangesUtil.getFilePath(change).getVirtualFile();
        if (file == null) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(30);
            }
            return list3;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(file);
        if (document2 == null) {
            List list4 = Collections.emptyList();
            if (list4 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(31);
            }
            return list4;
        }
        List apply2 = (List)elementExtractor2.fun((Object)file);
        List list5 = elements = apply2 == null ? null : ContainerUtil.skipNulls((Collection)apply2);
        if (ContainerUtil.isEmpty((Collection)elements)) {
            List list6 = Collections.emptyList();
            if (list6 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(32);
            }
            return list6;
        }
        if (change.getType() == Change.Type.NEW) {
            List list7 = elements;
            if (list7 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(33);
            }
            return list7;
        }
        List<com.intellij.openapi.vcs.ex.Range> ranges = VcsFacadeImpl.getChangedRangesForPostCommit(document2, change);
        if (ranges == null) {
            List list8 = elements;
            if (list8 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(34);
            }
            return list8;
        }
        BitSet changedLines = VcsFacadeImpl.createChangedLinesBitSet(ranges);
        List list9 = ContainerUtil.filter((Collection)elements, element -> VcsFacadeImpl.isElementChanged(element, document2, changedLines));
        if (list9 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(35);
        }
        return list9;
    }

    @Nullable
    private static List<? extends com.intellij.openapi.vcs.ex.Range> getChangedRangesFromLineStatusTracker(@NotNull Project project2, @NotNull Document document2, @NotNull Change change) {
        LineStatusTracker<?> tracker;
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(36);
        }
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(37);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(38);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(document2)) == null) {
            return null;
        }
        if (change instanceof ChangeListChange && tracker instanceof PartialLocalLineStatusTracker) {
            String changeListId = ((ChangeListChange)change).getChangeListId();
            List ranges = ((PartialLocalLineStatusTracker)tracker).getRanges();
            if (ranges == null) {
                return null;
            }
            return ContainerUtil.filter((Collection)ranges, range -> range.getChangelistId().equals(changeListId));
        }
        return tracker.getRanges();
    }

    @Nullable
    private static List<com.intellij.openapi.vcs.ex.Range> getChangedRangesFromBeforeRevision(@NotNull Document document2, @NotNull Change change) {
        String contentFromVcs;
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(39);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(40);
        }
        if ((contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change.getBeforeRevision())) == null) {
            return null;
        }
        return VcsFacadeImpl.computeRanges(document2, contentFromVcs);
    }

    @Nullable
    private static List<com.intellij.openapi.vcs.ex.Range> getChangedRangesForPostCommit(@NotNull Document document2, @NotNull Change change) {
        String conventBefore;
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(41);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(42);
        }
        if ((conventBefore = VcsFacadeImpl.getRevisionedContentFrom(change.getBeforeRevision())) == null) {
            return null;
        }
        String contentAfter = VcsFacadeImpl.getRevisionedContentFrom(change.getAfterRevision());
        if (contentAfter == null) {
            return null;
        }
        CharSequence beforeText = VcsFacadeImpl.fixLineSeparators(conventBefore);
        CharSequence afterText = VcsFacadeImpl.fixLineSeparators(contentAfter);
        CharSequence localText = document2.getImmutableCharSequence();
        LineOffsets beforeLineOffsets = LineOffsetsUtil.create((CharSequence)beforeText);
        LineOffsets afterLineOffsets = LineOffsetsUtil.create((CharSequence)afterText);
        LineOffsets localLineOffsets = LineOffsetsUtil.create((Document)document2);
        FairDiffIterable committedLines = RangesBuilder.compareLines((CharSequence)beforeText, (CharSequence)afterText, (LineOffsets)beforeLineOffsets, (LineOffsets)afterLineOffsets);
        FairDiffIterable localLines = RangesBuilder.compareLines((CharSequence)afterText, (CharSequence)localText, (LineOffsets)afterLineOffsets, (LineOffsets)localLineOffsets);
        ChangedRangesShifter builder2 = new ChangedRangesShifter();
        List<Range> ranges = builder2.execute(committedLines, localLines);
        return ContainerUtil.map(ranges, it -> new com.intellij.openapi.vcs.ex.Range(it.start2, it.end2, it.start1, it.end1, null));
    }

    @NotNull
    private static BitSet createChangedLinesBitSet(@NotNull List<? extends com.intellij.openapi.vcs.ex.Range> ranges) {
        if (ranges == null) {
            VcsFacadeImpl.$$$reportNull$$$0(43);
        }
        BitSet changedLines = new BitSet();
        for (com.intellij.openapi.vcs.ex.Range range : ranges) {
            if (range.hasLines()) {
                changedLines.set(range.getLine1(), range.getLine2());
                continue;
            }
            changedLines.set(Math.max(0, range.getLine1() - 1), range.getLine1() + 1);
        }
        BitSet bitSet = changedLines;
        if (bitSet == null) {
            VcsFacadeImpl.$$$reportNull$$$0(44);
        }
        return bitSet;
    }

    private static boolean isElementChanged(@NotNull PsiElement element, @NotNull Document document2, @NotNull BitSet changedLines) {
        if (element == null) {
            VcsFacadeImpl.$$$reportNull$$$0(45);
        }
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(46);
        }
        if (changedLines == null) {
            VcsFacadeImpl.$$$reportNull$$$0(47);
        }
        TextRange textRange = element.getTextRange();
        int startLine = document2.getLineNumber(textRange.getStartOffset());
        int endLine = textRange.isEmpty() ? startLine + 1 : document2.getLineNumber(textRange.getEndOffset() - 1) + 1;
        int nextSetBit = changedLines.nextSetBit(startLine);
        return nextSetBit != -1 && nextSetBit < endLine;
    }

    @Nullable
    private static String getRevisionedContentFrom(@Nullable ContentRevision contentRevision) {
        if (contentRevision == null) {
            return null;
        }
        try {
            return contentRevision.getContent();
        }
        catch (VcsException e) {
            LOG.warn("Can't get content for: " + contentRevision, (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<com.intellij.openapi.vcs.ex.Range> computeRanges(@NotNull Document document2, @NotNull CharSequence contentFromVcs) {
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(48);
        }
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(49);
        }
        List list2 = RangesBuilder.createRanges((CharSequence)document2.getImmutableCharSequence(), (CharSequence)VcsFacadeImpl.fixLineSeparators(contentFromVcs));
        if (list2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(50);
        }
        return list2;
    }

    @NotNull
    private static CharSequence fixLineSeparators(@NotNull CharSequence contentFromVcs) {
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(51);
        }
        CharSequence charSequence = StringUtilRt.convertLineSeparators((CharSequence)contentFromVcs, (String)"\n");
        if (charSequence == null) {
            VcsFacadeImpl.$$$reportNull$$$0(52);
        }
        return charSequence;
    }

    public int calculateChangedLinesNumber(@NotNull Document document2, @NotNull CharSequence contentFromVcs) {
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(53);
        }
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(54);
        }
        List<com.intellij.openapi.vcs.ex.Range> changedRanges = VcsFacadeImpl.computeRanges(document2, contentFromVcs);
        int linesChanges = 0;
        for (com.intellij.openapi.vcs.ex.Range range : changedRanges) {
            int inserted = range.getLine2() - range.getLine1();
            int deleted2 = range.getVcsLine2() - range.getVcsLine1();
            linesChanges += Math.max(inserted, deleted2);
        }
        return linesChanges;
    }

    @NotNull
    private static ChangedRangesInfo getChangedRangesInfo(@NotNull Document document2, @NotNull List<? extends com.intellij.openapi.vcs.ex.Range> changedRanges) {
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(55);
        }
        if (changedRanges == null) {
            VcsFacadeImpl.$$$reportNull$$$0(56);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<TextRange> insertedRanges = new ArrayList<TextRange>();
        for (com.intellij.openapi.vcs.ex.Range range : changedRanges) {
            if (!range.hasLines()) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document2.getLineStartOffset(changeStartLine);
            int lineEndOffset = document2.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range.hasVcsLines()) continue;
            insertedRanges.add(changedTextRange);
        }
        return new ChangedRangesInfo(ranges, insertedRanges);
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project2, @NotNull PsiFile file) {
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(57);
        }
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(58);
        }
        if (this.isFileUnderVcs(file).booleanValue()) {
            FileStatus status = ChangeListManager.getInstance(project2).getStatus(file.getVirtualFile());
            return status == FileStatus.UNKNOWN || status == FileStatus.IGNORED;
        }
        return true;
    }

    public void runHeavyModificationTask(@NotNull Project project2, @NotNull Document document2, @NotNull Runnable o) {
        LineStatusTracker<?> tracker;
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(59);
        }
        if (document2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(60);
        }
        if (o == null) {
            VcsFacadeImpl.$$$reportNull$$$0(61);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(document2)) != null) {
            tracker.doFrozen(o);
        } else {
            o.run();
        }
    }

    public void markFilesDirty(@NotNull Project project2, @NotNull List<? extends VirtualFile> virtualFiles2) {
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(62);
        }
        if (virtualFiles2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(63);
        }
        VcsFileUtil.markFilesDirty(project2, virtualFiles2);
    }

    public JComponent createPatchPreviewComponent(@NotNull Project project2, @NotNull ModelPatch patch) {
        if (project2 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(64);
        }
        if (patch == null) {
            VcsFacadeImpl.$$$reportNull$$$0(65);
        }
        List changes2 = EntryStream.of((Map)patch.getBranchChanges()).mapKeyValue((file, content) -> {
            FilePath filePath = VcsUtil.getFilePath(file);
            CurrentContentRevision current = new CurrentContentRevision(filePath);
            SimpleContentRevision changed2 = new SimpleContentRevision(content.toString(), filePath, VcsBundle.message("patched.version.name", new Object[0]));
            return new Change(current, changed2);
        }).toList();
        SimpleAsyncChangesBrowser browser = new SimpleAsyncChangesBrowser(project2, false, false);
        browser.setChangesToDisplay(changes2);
        return browser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 9, 10, 11, 12, 13, 15, 16, 17, 26, 27, 28, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 51, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/VcsFacadeImpl";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 26: 
            case 36: 
            case 57: 
            case 59: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 16: 
            case 27: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementExtractor";
                break;
            }
            case 37: 
            case 39: 
            case 41: 
            case 46: 
            case 48: 
            case 53: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedLines";
                break;
            }
            case 49: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRanges";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/VcsFacadeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isFileUnderVcs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsIgnoreFileNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalChangedElements";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostCommitChangedElements";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangedLinesBitSet";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRanges";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLineSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasActiveVcss";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderVcs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVcsIgnoreFileNames";
                break;
            }
            case 9: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFilesFromDirs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFiles";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChangedElements";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPostCommitChangedElements";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesFromLineStatusTracker";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesFromBeforeRevision";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesForPostCommit";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createChangedLinesBitSet";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isElementChanged";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "computeRanges";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fixLineSeparators";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyModificationTask";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "markFilesDirty";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createPatchPreviewComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 7, 9, 10, 11, 12, 13, 15, 16, 17, 26, 27, 28, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 51, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65 -> new IllegalArgumentException(string2);
        };
    }
}

