/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.editor.action;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.diff.DiscussionsViewOption;
import com.intellij.collaboration.ui.codereview.editor.CodeReviewInEditorViewModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\rH\u0016R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewInEditorToolbarActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "vm", "Lcom/intellij/collaboration/ui/codereview/editor/CodeReviewInEditorViewModel;", "(Lcom/intellij/collaboration/ui/codereview/editor/CodeReviewInEditorViewModel;)V", "disableReviewAction", "Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewInEditorToolbarActionGroup$ViewOptionToggleAction;", "hideResolvedAction", "showAllAction", "updateAction", "Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewInEditorToolbarActionGroup$UpdateAction;", "displayTextInToolbar", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getWarningIcon", "Ljavax/swing/Icon;", "update", "", "useSmallerFontForTextInToolbar", "UpdateAction", "ViewOptionToggleAction", "intellij.platform.collaborationTools"})
@ApiStatus.Internal
public final class CodeReviewInEditorToolbarActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    private final CodeReviewInEditorViewModel vm;
    @NotNull
    private final UpdateAction updateAction;
    @NotNull
    private final ViewOptionToggleAction disableReviewAction;
    @NotNull
    private final ViewOptionToggleAction hideResolvedAction;
    @NotNull
    private final ViewOptionToggleAction showAllAction;

    public CodeReviewInEditorToolbarActionGroup(@NotNull CodeReviewInEditorViewModel vm2) {
        Intrinsics.checkNotNullParameter((Object)vm2, (String)"vm");
        this.vm = vm2;
        this.updateAction = new UpdateAction();
        String string2 = CollaborationToolsBundle.message("review.editor.action.disable.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.disableReviewAction = new ViewOptionToggleAction(DiscussionsViewOption.DONT_SHOW, string2);
        String string3 = CollaborationToolsBundle.message("review.editor.action.show.unresolved.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.hideResolvedAction = new ViewOptionToggleAction(DiscussionsViewOption.UNRESOLVED_ONLY, string3);
        String string4 = CollaborationToolsBundle.message("review.editor.action.show.all.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        this.showAllAction = new ViewOptionToggleAction(DiscussionsViewOption.ALL, string4);
        Presentation $this$_init__u24lambda_u240 = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.setPopupGroup(true);
        $this$_init__u24lambda_u240.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
        $this$_init__u24lambda_u240.setDescription(CollaborationToolsBundle.message("review.editor.mode.description.title", new Object[0]));
        HelpTooltip tooltip2 = new HelpTooltip().setTitle(CollaborationToolsBundle.message("review.editor.mode.description.title", new Object[0])).setDescription(CollaborationToolsBundle.message("review.editor.mode.description", new Object[0]));
        $this$_init__u24lambda_u240.putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, (Object)tooltip2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[5];
        anActionArray[0] = this.updateAction;
        Intrinsics.checkNotNullExpressionValue((Object)Separator.create(), (String)"create(...)");
        anActionArray[2] = this.disableReviewAction;
        anActionArray[3] = this.hideResolvedAction;
        anActionArray[4] = this.showAllAction;
        return anActionArray;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public boolean useSmallerFontForTextInToolbar() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean shown = this.vm.getDiscussionsViewOption().getValue() != DiscussionsViewOption.DONT_SHOW;
        boolean synced = (Boolean)this.vm.getUpdateRequired().getValue() == false;
        Presentation $this$update_u24lambda_u241 = e.getPresentation();
        boolean bl = false;
        if (shown) {
            $this$update_u24lambda_u241.setText(CollaborationToolsBundle.message("review.editor.mode.title", new Object[0]));
            $this$update_u24lambda_u241.setIcon(synced ? null : this.getWarningIcon());
        } else {
            $this$update_u24lambda_u241.setText(null);
            $this$update_u24lambda_u241.setIcon(AllIcons.Actions.Preview);
        }
    }

    private final Icon getWarningIcon() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"WARNING");
        Object object = HighlightDisplayLevel.Companion.find(highlightSeverity);
        if (object == null || (object = object.getIcon()) == null) {
            Icon icon2 = AllIcons.General.Warning;
            object = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Warning");
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewInEditorToolbarActionGroup$UpdateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewInEditorToolbarActionGroup;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.collaborationTools"})
    private final class UpdateAction
    extends DumbAwareAction {
        public UpdateAction() {
            super(CollaborationToolsBundle.message("review.editor.action.update.text", new Object[0]), null, AllIcons.Actions.CheckOut);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(((Boolean)CodeReviewInEditorToolbarActionGroup.this.vm.getUpdateRequired().getValue()).booleanValue());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CodeReviewInEditorToolbarActionGroup.this.vm.updateBranch();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001a\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewInEditorToolbarActionGroup$ViewOptionToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "option", "Lcom/intellij/collaboration/ui/codereview/diff/DiscussionsViewOption;", "text", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "(Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewInEditorToolbarActionGroup;Lcom/intellij/collaboration/ui/codereview/diff/DiscussionsViewOption;Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.platform.collaborationTools"})
    private final class ViewOptionToggleAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final DiscussionsViewOption option;

        public ViewOptionToggleAction(@NotNull DiscussionsViewOption option, String text2) {
            Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(text2);
            this.option = option;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return CodeReviewInEditorToolbarActionGroup.this.vm.getDiscussionsViewOption().getValue() == this.option;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CodeReviewInEditorToolbarActionGroup.this.vm.setDiscussionsViewOption(this.option);
        }
    }
}

