/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.toolwindow;

import com.intellij.collaboration.ui.codereview.list.ReviewListViewModel;
import com.intellij.collaboration.ui.toolwindow.ReviewTab;
import com.intellij.collaboration.ui.toolwindow.ReviewTabViewModel;
import com.intellij.collaboration.ui.toolwindow.ReviewTabsComponentFactory;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowProjectViewModel;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowTabsManager;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowTabsManagerKt;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001aq\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0006\"\b\b\u0001\u0010\u0007*\u00020\b\"\u0014\b\u0002\u0010\t*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\t0\u00122\u000b\u0010\u0013\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0014H\u0007\u001a \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001d"}, d2={"createTabDebugName", "", "name", "manageReviewToolwindowTabs", "", "T", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTab;", "TVM", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabViewModel;", "PVM", "Lcom/intellij/collaboration/ui/toolwindow/ReviewToolwindowProjectViewModel;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "toolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "reviewToolwindowViewModel", "Lcom/intellij/collaboration/ui/toolwindow/ReviewToolwindowViewModel;", "tabComponentFactory", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabsComponentFactory;", "tabTitle", "Lorg/jetbrains/annotations/Nls;", "refreshListOnToolwindowShow", "listVm", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListViewModel;", "content", "Lcom/intellij/ui/content/Content;", "refreshReviewListOnTabSelection", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "intellij.platform.collaborationTools"})
public final class ReviewToolwindowTabsManagerKt {
    @ApiStatus.Experimental
    public static final <T extends ReviewTab, TVM extends ReviewTabViewModel, PVM extends ReviewToolwindowProjectViewModel<T, TVM>> void manageReviewToolwindowTabs(@NotNull CoroutineScope cs, @NotNull ToolWindow toolwindow, @NotNull ReviewToolwindowViewModel<PVM> reviewToolwindowViewModel, @NotNull ReviewTabsComponentFactory<TVM, PVM> tabComponentFactory, @NotNull String tabTitle) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)toolwindow, (String)"toolwindow");
        Intrinsics.checkNotNullParameter(reviewToolwindowViewModel, (String)"reviewToolwindowViewModel");
        Intrinsics.checkNotNullParameter(tabComponentFactory, (String)"tabComponentFactory");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        new ReviewToolwindowTabsManager(cs, toolwindow, reviewToolwindowViewModel, tabComponentFactory, tabTitle);
    }

    private static final String createTabDebugName(String name) {
        return "Review Toolwindow Tab [" + name + "]";
    }

    private static final void refreshReviewListOnTabSelection(ReviewListViewModel listVm, ContentManager contentManager, Content content) {
        ContentManagerListener listener2 = new ContentManagerListener(content, listVm){
            final /* synthetic */ Content $content;
            final /* synthetic */ ReviewListViewModel $listVm;
            {
                this.$content = $content;
                this.$listVm = $listVm;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add && event.getContent() == this.$content) {
                    this.$listVm.refresh();
                }
            }
        };
        contentManager.addContentManagerListener(listener2);
        Disposer.register((Disposable)((Disposable)content), () -> ReviewToolwindowTabsManagerKt.refreshReviewListOnTabSelection$lambda$0(contentManager, listener2));
    }

    private static final void refreshListOnToolwindowShow(ReviewListViewModel listVm, ToolWindow toolwindow, Content content) {
        MessageBusConnection messageBusConnection = toolwindow.getProject().getMessageBus().connect((Disposable)content);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(toolwindow, content, listVm){
            final /* synthetic */ ToolWindow $toolwindow;
            final /* synthetic */ Content $content;
            final /* synthetic */ ReviewListViewModel $listVm;
            {
                this.$toolwindow = $toolwindow;
                this.$content = $content;
                this.$listVm = $listVm;
            }

            public void toolWindowShown(@NotNull ToolWindow shownToolwindow) {
                Content selectedContent;
                Intrinsics.checkNotNullParameter((Object)shownToolwindow, (String)"shownToolwindow");
                if (Intrinsics.areEqual((Object)shownToolwindow.getId(), (Object)this.$toolwindow.getId()) && (selectedContent = shownToolwindow.getContentManager().getSelectedContent()) == this.$content) {
                    this.$listVm.refresh();
                }
            }
        });
    }

    private static final void refreshReviewListOnTabSelection$lambda$0(ContentManager $contentManager, refreshReviewListOnTabSelection.listener.1 $listener) {
        Intrinsics.checkNotNullParameter((Object)$contentManager, (String)"$contentManager");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $contentManager.removeContentManagerListener((ContentManagerListener)$listener);
    }

    public static final /* synthetic */ void access$refreshReviewListOnTabSelection(ReviewListViewModel listVm, ContentManager contentManager, Content content) {
        ReviewToolwindowTabsManagerKt.refreshReviewListOnTabSelection(listVm, contentManager, content);
    }

    public static final /* synthetic */ void access$refreshListOnToolwindowShow(ReviewListViewModel listVm, ToolWindow toolwindow, Content content) {
        ReviewToolwindowTabsManagerKt.refreshListOnToolwindowShow(listVm, toolwindow, content);
    }

    public static final /* synthetic */ String access$createTabDebugName(String name) {
        return ReviewToolwindowTabsManagerKt.createTabDebugName(name);
    }
}

