/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.ExternalCoverageWatchManager;
import com.intellij.coverage.actions.ExternalReportImportManagerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u00020\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\fH\u0002J\u001c\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/coverage/actions/ExternalReportImportManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "chooseAndImportCoverageReportsFromDisc", "", "Lcom/intellij/coverage/CoverageSuite;", "chooseAndOpenSuites", "", "closeBundlesThatAreNotChosen", "suitesByEngine", "", "Lcom/intellij/coverage/CoverageEngine;", "openSuites", "suites", "closeCurrentlyOpened", "", "Companion", "intellij.platform.coverage"})
@SourceDebugExtension(value={"SMAP\nExternalReportImportManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalReportImportManager.kt\ncom/intellij/coverage/actions/ExternalReportImportManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1477#2:88\n1502#2,3:89\n1505#2,3:99\n1549#2:118\n1620#2,3:119\n1603#2,9:124\n1855#2:133\n1856#2:135\n1612#2:136\n1549#2:137\n1620#2,3:138\n372#3,7:92\n37#4,2:102\n37#4,2:122\n11383#5,9:104\n13309#5:113\n13310#5:115\n11392#5:116\n1#6:114\n1#6:117\n1#6:134\n*S KotlinDebug\n*F\n+ 1 ExternalReportImportManager.kt\ncom/intellij/coverage/actions/ExternalReportImportManager\n*L\n30#1:88\n30#1:89,3\n30#1:99,3\n57#1:118\n57#1:119,3\n59#1:124,9\n59#1:133\n59#1:135\n59#1:136\n67#1:137\n67#1:138,3\n30#1:92,7\n37#1:102,2\n57#1:122,2\n51#1:104,9\n51#1:113\n51#1:115\n51#1:116\n51#1:114\n59#1:134\n*E\n"})
public final class ExternalReportImportManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ExternalReportImportManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public final void chooseAndOpenSuites() {
        List<CoverageSuite> suites = this.chooseAndImportCoverageReportsFromDisc();
        if (suites.isEmpty()) {
            return;
        }
        this.openSuites(suites, false);
    }

    /*
     * WARNING - void declaration
     */
    public final void openSuites(@NotNull List<? extends CoverageSuite> suites, boolean closeCurrentlyOpened) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(suites, (String)"suites");
        Iterable $this$groupBy$iv = suites;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            CoverageSuite it = (CoverageSuite)element$iv$iv;
            boolean bl = false;
            CoverageEngine key$iv$iv = it.getCoverageEngine();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map suitesByEngine = destination$iv$iv;
        if (closeCurrentlyOpened) {
            this.closeBundlesThatAreNotChosen(suitesByEngine);
        }
        for (List engineSuites : suitesByEngine.values()) {
            Collection $this$toTypedArray$iv = engineSuites;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CoverageSuitesBundle bundle = new CoverageSuitesBundle(thisCollection$iv.toArray(new CoverageSuite[0]));
            CoverageLogger.logSuiteImport(this.project, bundle);
            CoverageDataManager.getInstance(this.project).chooseSuitesBundle(bundle);
        }
        if (!suites.isEmpty()) {
            ExternalCoverageWatchManager.getInstance(this.project).addRootsToWatch(suites);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CoverageSuite> chooseAndImportCoverageReportsFromDisc() {
        List list2;
        List list3;
        List list4;
        Object it$iv$iv;
        CoverageRunner runner;
        void element$iv$iv$iv;
        int n;
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)new FileChooserDescriptor(){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return file != null && ExternalReportImportManagerKt.access$getCoverageRunner(file) != null;
            }
        }, (Project)this.project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
        Object[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n2 = ((void)$this$forEach$iv$iv$iv2).length;
        for (n = 0; n < n2; n += 1) {
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv2[n];
            boolean bl = false;
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)file);
            if ((ExternalReportImportManagerKt.access$getCoverageRunner(file) == null ? null : TuplesKt.to((Object)file, (Object)runner)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list4 = (List)destination$iv$iv;
        boolean bl = false;
        List list5 = list3 = !((Collection)it).isEmpty() ? list4 : null;
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            List list6;
            Iterable list7 = list6 = list3;
            boolean bl4 = false;
            Iterable $i$f$mapNotNullTo2 = list7;
            boolean $this$forEach$iv$iv$iv2 = false;
            $i$f$forEach = false;
            n = 0;
            boolean $i$f$map = false;
            element$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                runner = (Pair)item$iv$iv;
                it$iv$iv = destination$iv$iv2;
                boolean bl5 = false;
                it$iv$iv.add((VirtualFile)it2.getFirst());
            }
            it$iv$iv = (List)destination$iv$iv2;
            $this$map$iv = (Collection)it$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            VirtualFile[] virtualFileArray2 = thisCollection$iv.toArray(new VirtualFile[0]);
            VfsUtil.markDirtyAndRefresh(n != 0, (boolean)$i$f$forEach, (boolean)$this$forEach$iv$iv$iv2, (VirtualFile[])Arrays.copyOf(virtualFileArray2, virtualFileArray2.length));
            list7 = list6;
            boolean $i$f$mapNotNull2 = false;
            $this$toTypedArray$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo3 = false;
            void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv3.iterator();
            while (iterator.hasNext()) {
                CoverageSuite it$iv$iv2;
                File file;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator.next();
                boolean bl6 = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl7 = false;
                VirtualFile virtualFile = (VirtualFile)pair.component1();
                CoverageRunner runner2 = (CoverageRunner)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile), (String)"virtualToIoFile(...)");
                if (CoverageDataManager.getInstance(this.project).addExternalCoverageSuite(file, runner2) == null) continue;
                boolean bl8 = false;
                destination$iv$iv3.add(it$iv$iv2);
            }
            list2 = (List)destination$iv$iv3;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void closeBundlesThatAreNotChosen(Map<CoverageEngine, ? extends List<? extends CoverageSuite>> suitesByEngine) {
        void $this$mapTo$iv$iv;
        Collection<CoverageSuitesBundle> activeSuites = CoverageDataManager.getInstance(this.project).activeSuites();
        Intrinsics.checkNotNull(activeSuites);
        Iterable $this$map$iv = activeSuites;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CoverageSuitesBundle coverageSuitesBundle = (CoverageSuitesBundle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCoverageEngine());
        }
        HashSet activeEngines = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        activeEngines.removeAll((Collection)suitesByEngine.keySet());
        for (CoverageSuitesBundle bundle : activeSuites) {
            if (!activeEngines.contains(bundle.getCoverageEngine())) continue;
            CoverageDataManager.getInstance(this.project).closeSuitesBundle(bundle);
        }
    }

    @JvmStatic
    @NotNull
    public static final ExternalReportImportManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/coverage/actions/ExternalReportImportManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/coverage/actions/ExternalReportImportManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.coverage"})
    @SourceDebugExtension(value={"SMAP\nExternalReportImportManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalReportImportManager.kt\ncom/intellij/coverage/actions/ExternalReportImportManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,87:1\n31#2,2:88\n*S KotlinDebug\n*F\n+ 1 ExternalReportImportManager.kt\ncom/intellij/coverage/actions/ExternalReportImportManager$Companion\n*L\n20#1:88,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExternalReportImportManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ExternalReportImportManager> serviceClass$iv = ExternalReportImportManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ExternalReportImportManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

