/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageRowSorter;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageView
extends BorderLayoutPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String ACTION_DRILL_DOWN = "DrillDown";
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.Coverage";
    public static final Icon FILTER_ICON = AllIcons.General.Filter;
    private final CoverageTableModel myModel;
    private final JBTreeTable myTable;
    private final Project myProject;
    private final CoverageViewManager.StateBean myStateBean;
    private final CoverageSuitesBundle mySuitesBundle;
    private final CoverageViewExtension myViewExtension;
    private final CoverageViewTreeStructure myTreeStructure;
    private boolean myHasVCSFilter = false;
    private boolean myHasFullyCoveredFilter = false;

    public CoverageView(Project project2, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        this.myProject = project2;
        this.myStateBean = stateBean;
        this.mySuitesBundle = bundle;
        this.myViewExtension = this.mySuitesBundle.getCoverageEngine().createCoverageViewExtension(this.myProject, this.mySuitesBundle, this.myStateBean);
        this.myTreeStructure = new CoverageViewTreeStructure(project2, this.mySuitesBundle, stateBean);
        this.myModel = new CoverageTableModel(this.mySuitesBundle, stateBean, project2, this.myTreeStructure);
        Disposer.register((Disposable)this, (Disposable)this.myModel);
        this.myTable = new JBTreeTable((TreeTableModel)this.myModel);
        TreeUtil.expand((JTree)this.myTable.getTree(), (int)2);
        this.myTable.getTree().setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            @NotNull
            protected SimpleTextAttributes getSimpleTextAttributes(@NotNull PresentationData presentation2, Color color2, @NotNull Object node) {
                if (presentation2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.mySelected) {
                    color2 = null;
                }
                SimpleTextAttributes simpleTextAttributes = super.getSimpleTextAttributes(presentation2, color2, node);
                if (simpleTextAttributes == null) {
                    1.$$$reportNull$$$0(2);
                }
                return simpleTextAttributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/coverage/view/CoverageView$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/coverage/view/CoverageView$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSimpleTextAttributes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSimpleTextAttributes";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        });
        this.myTable.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column) {
                Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column);
                this.setBackground(UIUtil.getTableBackground((boolean)isSelected, (boolean)CoverageView.this.myTable.hasFocus()));
                return component2;
            }
        });
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Coverage");
        boolean isHorizontalView = toolWindow != null && toolWindow.getAnchor().isHorizontal();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("CoverageView", this.createToolbarActions(), !isHorizontalView);
        actionToolbar.setTargetComponent((JComponent)this.myTable);
        JComponent toolbarComponent = actionToolbar.getComponent();
        if (isHorizontalView) {
            this.addToLeft(toolbarComponent);
        } else {
            this.addToTop(toolbarComponent);
        }
        this.setUpShowRootNode(actionToolbar);
        CoverageLogger.logViewOpen(project2, this.myStateBean.isShowOnlyModified(), this.myHasVCSFilter, this.myStateBean.isHideFullyCovered(), this.myHasFullyCoveredFilter);
        CoverageRowSorter rowSorter = new CoverageRowSorter(this.myTable, this.myModel);
        this.myTable.setRowSorter((RowSorter)rowSorter);
        if (stateBean.mySortingColumn < 0 || stateBean.mySortingColumn >= this.myModel.getColumnCount()) {
            stateBean.myAscendingOrder = true;
            stateBean.mySortingColumn = 0;
        }
        RowSorter.SortKey sortKey = new RowSorter.SortKey(stateBean.mySortingColumn, stateBean.myAscendingOrder ? SortOrder.ASCENDING : SortOrder.DESCENDING);
        rowSorter.setSortKeys(Collections.singletonList(sortKey));
        this.addToCenter((Component)this.myTable);
        this.attachFileStatusListener();
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                CoverageView.this.enterSelected(false);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/view/CoverageView$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable.getTree());
        TreeSpeedSearch speedSearch = TreeSpeedSearch.installOn((JTree)this.myTable.getTree(), (boolean)false, path2 -> path2.getLastPathComponent().toString());
        speedSearch.setCanExpand(true);
        speedSearch.setClearSearchOnNavigateNoMatch(true);
        PopupHandler.installPopupMenu((JComponent)this.myTable, (ActionGroup)CoverageView.createPopupGroup(), (String)"CoverageViewPopup");
        this.myTable.getTree().registerKeyboardAction(e -> this.resetView(), KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 256 : 128), 0);
        this.myTable.getTree().getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_DRILL_DOWN);
        this.myTable.getTree().getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 256 : 128), ACTION_DRILL_DOWN);
        this.myTable.getTree().getActionMap().put(ACTION_DRILL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageView.this.enterSelected(true);
            }
        });
    }

    private void resetIfAllFiltered(AbstractTreeNode<?> root, ActionToolbar actionToolbar) {
        if (this.myViewExtension.hasVCSFilteredNodes() && this.myStateBean.isShowOnlyModified() && this.myStateBean.isDefaultFilters()) {
            if (!this.myViewExtension.hasChildren(root)) {
                this.myStateBean.setShowOnlyModified(false);
                this.resetView();
            } else {
                JComponent filterAction;
                String message2 = CoverageBundle.message("coverage.filter.gotit", this.myViewExtension.getElementsName());
                GotItTooltip gotIt = new GotItTooltip("coverage.view.elements.filter", message2, (Disposable)this);
                if (gotIt.canShow() && (filterAction = CoverageView.findToolbarActionButtonWithIcon(actionToolbar, FILTER_ICON)) != null) {
                    gotIt.show(filterAction, GotItTooltip.BOTTOM_MIDDLE);
                }
            }
        }
    }

    private void setUpShowRootNode(final ActionToolbar actionToolbar) {
        final Ref showFull = new Ref((Object)false);
        this.myModel.addTreeModelListener(new TreeModelListener(){
            private volatile boolean called = false;

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.onModelUpdate(e);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.onModelUpdate(e);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.onModelUpdate(e);
            }

            private void onModelUpdate(TreeModelEvent e) {
                Object root = CoverageView.this.myModel.getRoot();
                if (e.getTreePath().getLastPathComponent() == root) {
                    AbstractTreeNode<?> nodeRoot;
                    boolean showRoot;
                    CoverageView.this.setUpEmptyText();
                    int childCount = CoverageView.this.myModel.getChildCount(root);
                    boolean bl = showRoot = childCount > 1 || childCount == 1 && (Boolean)showFull.get() != false;
                    if (showRoot && !CoverageView.this.myStateBean.isShowOnlyModified() && !CoverageView.this.myStateBean.isHideFullyCovered()) {
                        showFull.set((Object)true);
                    }
                    if (showRoot != CoverageView.this.myTable.getTree().isRootVisible()) {
                        CoverageView.this.myTable.getTree().setRootVisible(showRoot);
                    }
                    if (!this.called && (nodeRoot = CoverageView.this.myModel.getCoverageNode(root)) != null) {
                        this.called = true;
                        CoverageView.this.setWidth(nodeRoot);
                        CoverageView.this.resetIfAllFiltered(nodeRoot, actionToolbar);
                    }
                }
            }
        });
    }

    private void attachFileStatusListener() {
        FileStatusListener fileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                CoverageView.this.myTable.repaint();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    6.$$$reportNull$$$0(0);
                }
                CoverageView.this.myTable.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/coverage/view/CoverageView$6", "fileStatusChanged"));
            }
        };
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(fileStatusListener, (Disposable)this);
    }

    private void setUpEmptyText() {
        boolean hasVcsFiltered = this.myViewExtension.hasVCSFilteredNodes();
        boolean hasFullyCovered = this.myViewExtension.hasFullyCoveredNodes();
        this.myTable.getTree().getEmptyText().clear();
        StatusText emptyText = this.myTable.getTable().getEmptyText();
        emptyText.setText(CoverageBundle.message("coverage.view.no.coverage.results", new Object[0]));
        RunConfigurationBase configuration = this.mySuitesBundle.getRunConfiguration();
        if (configuration != null) {
            emptyText.appendLine(CoverageBundle.message("coverage.view.edit.run.configuration.0", new Object[0]) + " ");
            emptyText.appendText(CoverageBundle.message("coverage.view.edit.run.configuration.1", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                RunnerAndConfigurationSettings configurationSettings = RunManager.getInstance((Project)this.myProject).findSettings((RunConfiguration)configuration);
                if (configurationSettings != null) {
                    RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)configurationSettings, (String)ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}));
                } else {
                    Messages.showErrorDialog((Project)this.myProject, (String)CoverageBundle.message("coverage.view.configuration.was.not.found", configuration.getName()), (String)CommonBundle.getErrorTitle());
                }
            });
            emptyText.appendText(" " + CoverageBundle.message("coverage.view.edit.run.configuration.2", new Object[0]));
        }
        if (hasVcsFiltered && this.myStateBean.isShowOnlyModified()) {
            emptyText.appendLine(CoverageBundle.message("coverage.show.unmodified.elements", this.myViewExtension.getElementsName()), SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                this.myStateBean.setShowOnlyModified(false);
                this.resetView();
            });
        }
        if (hasFullyCovered && this.myStateBean.isHideFullyCovered()) {
            emptyText.appendLine(CoverageBundle.message("coverage.show.fully.covered.elements", this.myViewExtension.getElementsName()), SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                this.myStateBean.setHideFullyCovered(false);
                this.resetView();
            });
        }
    }

    public void dispose() {
        if (!this.myProject.isDisposed()) {
            CoverageDataManager.getInstance(this.myProject).closeSuitesBundle(this.mySuitesBundle);
        }
    }

    public void saveSize() {
        List<RowSorter.SortKey> keys;
        int columns = this.myTable.getTable().getColumnCount();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        TableColumnModel columnModel = this.myTable.getTable().getColumnModel();
        for (int i = 0; i < columns; ++i) {
            widths.add(columnModel.getColumn(i).getWidth());
        }
        widths.add(this.myTable.getWidth() - this.myTable.getTable().getWidth());
        this.myStateBean.myColumnSize = widths;
        RowSorter sorter = this.myTable.getTable().getRowSorter();
        RowSorter.SortKey sortKey = null;
        if (sorter != null && (keys = sorter.getSortKeys()) != null && !keys.isEmpty()) {
            sortKey = keys.get(0);
        }
        if (sortKey != null && sortKey.getSortOrder() != SortOrder.UNSORTED) {
            this.myStateBean.mySortingColumn = sortKey.getColumn();
            this.myStateBean.myAscendingOrder = sortKey.getSortOrder() == SortOrder.ASCENDING;
        }
    }

    private void setWidth(AbstractTreeNode<?> root) {
        int nameWidth;
        int columns = this.myTable.getTable().getColumnCount();
        TableColumnModel columnModel = this.myTable.getTable().getColumnModel();
        int tableWidth = 0;
        if (this.myStateBean.myColumnSize != null && this.myStateBean.myColumnSize.size() == columns + 1) {
            for (int column = 0; column < columns; ++column) {
                int width = this.myStateBean.myColumnSize.get(column);
                columnModel.getColumn(column).setPreferredWidth(width);
                tableWidth += width;
            }
            nameWidth = this.myStateBean.myColumnSize.get(columns);
        } else {
            for (int column = 0; column < columns; ++column) {
                int width = Math.max(this.getStringWidth(this.myModel.getColumnName(column)), this.getColumnWidth(column, root));
                columnModel.getColumn(column).setPreferredWidth(width);
                tableWidth += width;
            }
            nameWidth = Math.max(this.getStringWidth(this.myModel.getColumnName(0)), JBUIScale.scale((int)150));
        }
        this.myTable.setColumnProportion((float)tableWidth / (float)(nameWidth + tableWidth) / (float)columns);
    }

    private int getColumnWidth(int column, AbstractTreeNode<?> root) {
        String preferredString = this.myViewExtension.getPercentage(column, root);
        if (preferredString == null) {
            return JBUIScale.scale((int)60);
        }
        return this.getStringWidth(preferredString);
    }

    private int getStringWidth(@NotNull String preferredString) {
        if (preferredString == null) {
            CoverageView.$$$reportNull$$$0(0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.stringWidth(preferredString);
    }

    private static ActionGroup createPopupGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        return actionGroup;
    }

    private ActionGroup createToolbarActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (this.myViewExtension.supportFlattenPackages()) {
            actionGroup.add((AnAction)new FlattenPackagesAction());
        }
        this.installAutoScrollToSource(actionGroup);
        this.installAutoScrollFromSource(actionGroup);
        actionGroup.add(ActionManager.getInstance().getAction("GenerateCoverageReport"));
        actionGroup.add(ActionManager.getInstance().getAction("ImportCoverage"));
        List<AnAction> extraActions = this.myViewExtension.createExtraToolbarActions();
        extraActions.forEach(arg_0 -> ((DefaultActionGroup)actionGroup).add(arg_0));
        boolean hasFilters = false;
        DefaultActionGroup filtersActionGroup = new DefaultActionGroup();
        if (ProjectLevelVcsManager.getInstance(this.myProject).hasActiveVcss()) {
            filtersActionGroup.add((AnAction)new ShowOnlyModifiedAction());
            hasFilters = true;
            this.myHasVCSFilter = true;
        } else {
            this.myStateBean.setShowOnlyModified(false);
        }
        if (this.myViewExtension.supportFlattenPackages()) {
            filtersActionGroup.add((AnAction)new HideFullyCoveredAction());
            hasFilters = true;
            this.myHasFullyCoveredFilter = true;
        } else {
            this.myStateBean.setHideFullyCovered(false);
        }
        if (hasFilters) {
            filtersActionGroup.setPopup(true);
            filtersActionGroup.getTemplatePresentation().setIcon(FILTER_ICON);
            filtersActionGroup.getTemplatePresentation().setText(CoverageBundle.messagePointer("coverage.view.filters.group", new Object[0]));
            actionGroup.add((AnAction)filtersActionGroup);
        }
        return actionGroup;
    }

    private void installAutoScrollFromSource(DefaultActionGroup actionGroup) {
        MyAutoScrollFromSourceHandler handler2 = new MyAutoScrollFromSourceHandler();
        handler2.install();
        actionGroup.add((AnAction)handler2.createToggleAction());
    }

    private void installAutoScrollToSource(DefaultActionGroup actionGroup) {
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return CoverageView.this.myStateBean.myAutoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                CoverageView.this.myStateBean.myAutoScrollToSource = state;
            }
        };
        autoScrollToSourceHandler.install((JTree)this.myTable.getTree());
        actionGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    private void enterSelected(boolean expand) {
        TreePath path2 = this.getSelectedPath();
        AbstractTreeNode<?> element = this.getLast(path2);
        if (element == null) {
            return;
        }
        if (this.myModel.isLeaf(path2.getLastPathComponent())) {
            if (element.canNavigate()) {
                element.navigate(true);
            }
            return;
        }
        if (!expand) {
            return;
        }
        if (!this.myTable.getTree().isExpanded(path2)) {
            this.myTable.getTree().expandPath(path2);
        } else {
            this.myTable.getTree().collapsePath(path2);
        }
    }

    private TreePath getSelectedPath() {
        return this.myTable.getTree().getSelectionPath();
    }

    private AbstractTreeNode<?> getLast(@Nullable TreePath path2) {
        if (path2 == null) {
            return null;
        }
        return this.myModel.getCoverageNode(path2.getLastPathComponent());
    }

    private AbstractTreeNode<?> getSelectedValue() {
        return this.getLast(this.getSelectedPath());
    }

    public boolean canSelect(VirtualFile file) {
        return this.myViewExtension.canSelectInCoverageView(file);
    }

    public void select(VirtualFile file) {
        this.select(this.myViewExtension.getElementToSelect(file));
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CoverageView.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getSelectedValue();
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return null;
    }

    private void resetView() {
        this.myTreeStructure.reset();
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.myModel.reset(true));
    }

    private void select(Object object) {
        ReadAction.nonBlocking(() -> {
            final PsiElement element = this.myViewExtension.getElementToSelect(object);
            final VirtualFile file = this.myViewExtension.getVirtualFile(object);
            this.myModel.accept(new TreeVisitor(){

                @NotNull
                public TreeVisitor.Action visit(@NotNull TreePath path2) {
                    CoverageListNode coverageNode;
                    AbstractTreeNode<?> node;
                    if (path2 == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if (Comparing.equal((Object)(node = CoverageView.this.getLast(path2)).getValue(), (Object)element)) {
                        TreeVisitor.Action action2 = TreeVisitor.Action.INTERRUPT;
                        if (action2 == null) {
                            8.$$$reportNull$$$0(1);
                        }
                        return action2;
                    }
                    if (node instanceof CoverageListNode && (coverageNode = (CoverageListNode)node).contains(file)) {
                        TreeVisitor.Action action3 = TreeVisitor.Action.CONTINUE;
                        if (action3 == null) {
                            8.$$$reportNull$$$0(2);
                        }
                        return action3;
                    }
                    TreeVisitor.Action action4 = TreeVisitor.Action.SKIP_CHILDREN;
                    if (action4 == null) {
                        8.$$$reportNull$$$0(3);
                    }
                    return action4;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/coverage/view/CoverageView$8";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/coverage/view/CoverageView$8";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visit";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 1, 2, 3 -> new IllegalStateException(string2);
                    };
                }
            }).onSuccess(path2 -> {
                if (path2 != null) {
                    TreeUtil.promiseSelect((JTree)this.myTable.getTree(), (TreePath)path2);
                }
            });
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static JComponent findToolbarActionButtonWithIcon(ActionToolbar toolbar2, Icon icon2) {
        return (JComponent)UIUtil.uiTraverser((Component)toolbar2.getComponent()).filter(ActionButton.class).filter(button -> button.getIcon() == icon2).first();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/view/CoverageView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringWidth";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class FlattenPackagesAction
    extends ToggleAction {
        private FlattenPackagesAction() {
            super(IdeBundle.messagePointer((String)"action.flatten.packages", (Object[])new Object[0]), CoverageBundle.messagePointer("coverage.flatten.packages", new Object[0]), AllIcons.ObjectBrowser.FlattenPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(0);
            }
            return CoverageView.this.myStateBean.isFlattenPackages();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(1);
            }
            CoverageView.this.myStateBean.setFlattenPackages(state);
            CoverageView.this.resetView();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                FlattenPackagesAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private final class ShowOnlyModifiedAction
    extends ToggleAction {
        private ShowOnlyModifiedAction() {
            super(CoverageBundle.messagePointer("coverage.show.only.modified.elements", CoverageView.this.myViewExtension.getElementsCapitalisedName()));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowOnlyModifiedAction.$$$reportNull$$$0(0);
            }
            return CoverageView.this.myStateBean.isShowOnlyModified();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowOnlyModifiedAction.$$$reportNull$$$0(1);
            }
            CoverageView.this.myStateBean.setShowOnlyModified(state);
            CoverageView.this.resetView();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowOnlyModifiedAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/view/CoverageView$ShowOnlyModifiedAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/view/CoverageView$ShowOnlyModifiedAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private final class HideFullyCoveredAction
    extends ToggleAction {
        private HideFullyCoveredAction() {
            super(CoverageBundle.messagePointer("coverage.hide.fully.covered.elements", CoverageView.this.myViewExtension.getElementsCapitalisedName()));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HideFullyCoveredAction.$$$reportNull$$$0(0);
            }
            return CoverageView.this.myStateBean.isHideFullyCovered();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                HideFullyCoveredAction.$$$reportNull$$$0(1);
            }
            CoverageView.this.myStateBean.setHideFullyCovered(state);
            CoverageView.this.resetView();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HideFullyCoveredAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/view/CoverageView$HideFullyCoveredAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/view/CoverageView$HideFullyCoveredAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        MyAutoScrollFromSourceHandler() {
            super(CoverageView.this.myProject, (JComponent)((Object)CoverageView.this), (Disposable)CoverageView.this);
        }

        protected boolean isAutoScrollEnabled() {
            return CoverageView.this.myStateBean.myAutoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            CoverageView.this.myStateBean.myAutoScrollFromSource = state;
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            if (this.myProject.isDisposed() || !CoverageView.this.isShowing()) {
                return;
            }
            if (!CoverageView.this.myStateBean.myAutoScrollFromSource) {
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            ReadAction.nonBlocking(() -> {
                VirtualFile file = editor.getFile();
                if (file != null && CoverageView.this.canSelect(file)) {
                    VirtualFile e = null;
                    if (editor instanceof TextEditor) {
                        int offset = ((TextEditor)editor).getEditor().getCaretModel().getOffset();
                        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file);
                        if (psiFile2 != null) {
                            e = psiFile2.findElementAt(offset);
                        }
                    }
                    CoverageView.this.select((Object)(e != null ? e : file));
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/view/CoverageView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }
}

