/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CoverageViewManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 %2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0003%&'B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000bJ\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\n\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0007J\u0010\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0002H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/intellij/coverage/view/CoverageViewManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/coverage/view/CoverageViewManager$StateBean;", "Lcom/intellij/openapi/Disposable$Default;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myContentManager", "Lcom/intellij/ui/content/ContentManager;", "myViews", "", "Lcom/intellij/coverage/CoverageSuitesBundle;", "Lcom/intellij/coverage/view/CoverageView;", "openedSuite", "getOpenedSuite", "()Lcom/intellij/coverage/CoverageSuitesBundle;", "<set-?>", "stateBean", "getStateBean", "()Lcom/intellij/coverage/view/CoverageViewManager$StateBean;", "activateToolwindow", "", "view", "activate", "", "closeView", "suitesBundle", "createToolWindow", "createView", "getContentManager", "getState", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolwindow", "getView", "loadState", "state", "Companion", "CoverageViewSettingsListener", "StateBean", "intellij.platform.coverage"})
@SourceDebugExtension(value={"SMAP\nCoverageViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageViewManager.kt\ncom/intellij/coverage/view/CoverageViewManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class CoverageViewManager
implements PersistentStateComponent<StateBean>,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private StateBean stateBean;
    @NotNull
    private final Map<CoverageSuitesBundle, CoverageView> myViews;
    @Nullable
    private volatile ContentManager myContentManager;
    @NotNull
    public static final String TOOLWINDOW_ID = "Coverage";

    public CoverageViewManager(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.stateBean = new StateBean();
        this.myViews = new HashMap();
    }

    @NotNull
    public final StateBean getStateBean() {
        return this.stateBean;
    }

    @NotNull
    public StateBean getState() {
        if (!this.myViews.isEmpty()) {
            CoverageView view = this.myViews.values().iterator().next();
            view.saveSize();
        }
        return this.stateBean;
    }

    public void loadState(@NotNull StateBean state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.stateBean = state;
    }

    @Nullable
    public final synchronized CoverageView getView(@NotNull CoverageSuitesBundle suitesBundle) {
        Intrinsics.checkNotNullParameter((Object)suitesBundle, (String)"suitesBundle");
        return this.myViews.get(suitesBundle);
    }

    @Nullable
    public final CoverageSuitesBundle getOpenedSuite() {
        CoverageSuitesBundle coverageSuitesBundle;
        block3: {
            ContentManager contentManager = this.myContentManager;
            if (contentManager == null) {
                return null;
            }
            ContentManager manager = contentManager;
            Content content = manager.getSelectedContent();
            if (content == null) {
                return null;
            }
            Content selectedContent = content;
            for (Map.Entry<CoverageSuitesBundle, CoverageView> entry2 : this.myViews.entrySet()) {
                CoverageSuitesBundle coverageSuitesBundle2;
                boolean bl = false;
                CoverageSuitesBundle suite2 = entry2.getKey();
                CoverageView view = entry2.getValue();
                CoverageSuitesBundle it = coverageSuitesBundle2 = suite2;
                boolean bl2 = false;
                CoverageSuitesBundle object2 = selectedContent == manager.getContent((JComponent)((Object)view)) ? coverageSuitesBundle2 : null;
                if (object2 == null) continue;
                coverageSuitesBundle = object2;
                break block3;
            }
            coverageSuitesBundle = null;
        }
        return coverageSuitesBundle;
    }

    @RequiresEdt
    public final void activateToolwindow(@NotNull CoverageView view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        ContentManager contentManager = this.myContentManager;
        if (contentManager == null) {
            return;
        }
        ContentManager manager = contentManager;
        manager.setSelectedContent(manager.getContent((JComponent)((Object)view)));
        ToolWindow toolWindow = this.getToolWindow();
        if (toolWindow == null) {
            throw new IllegalStateException("Coverage toolwindow is not registered".toString());
        }
        ToolWindow toolWindow2 = toolWindow;
        toolWindow2.activate(null, false);
    }

    @RequiresEdt
    public final void createView(@NotNull CoverageSuitesBundle suitesBundle, boolean activate2) {
        Content content;
        Intrinsics.checkNotNullParameter((Object)suitesBundle, (String)"suitesBundle");
        CoverageView coverageView = this.myViews.get(suitesBundle);
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return;
        }
        ContentManager manager = contentManager;
        if (coverageView == null) {
            Content content2;
            coverageView = new CoverageView(this.myProject, suitesBundle, this.stateBean);
            this.myViews.put(suitesBundle, coverageView);
            Content it = content2 = manager.getFactory().createContent((JComponent)((Object)coverageView), Companion.getDisplayName(suitesBundle), false);
            boolean bl = false;
            manager.addContent(it);
            content = content2;
        } else {
            content = manager.getContent((JComponent)((Object)coverageView));
        }
        Content content3 = content;
        manager.setSelectedContent(content3);
        if (CoverageOptionsProvider.getInstance(this.myProject).activateViewOnRun() && activate2) {
            this.activateToolwindow(coverageView);
        }
    }

    public final void closeView(@NotNull CoverageSuitesBundle suitesBundle) {
        Intrinsics.checkNotNullParameter((Object)suitesBundle, (String)"suitesBundle");
        CoverageView oldView = this.myViews.remove(suitesBundle);
        if (oldView != null) {
            oldView.saveSize();
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, oldView){
                final /* synthetic */ CoverageViewManager this$0;
                final /* synthetic */ CoverageView $oldView;
                {
                    this.this$0 = $receiver;
                    this.$oldView = $oldView;
                    super(0);
                }

                public final void invoke() {
                    ContentManager contentManager = CoverageViewManager.access$getMyContentManager$p(this.this$0);
                    if (contentManager == null) {
                        return;
                    }
                    ContentManager manager = contentManager;
                    Content content = manager.getContent((JComponent)((Object)this.$oldView));
                    if (content != null) {
                        manager.removeContent(content, false);
                    }
                }
            }), (int)1, null);
        }
    }

    @Deprecated(message="Use getView(CoverageSuitesBundle) instead", replaceWith=@ReplaceWith(expression="getView(suitesBundle)", imports={}))
    @Nullable
    public final CoverageView getToolwindow(@NotNull CoverageSuitesBundle suitesBundle) {
        Intrinsics.checkNotNullParameter((Object)suitesBundle, (String)"suitesBundle");
        return this.getView(suitesBundle);
    }

    @Deprecated(message="Use activateToolwindow(CoverageView) instead", replaceWith=@ReplaceWith(expression="if (activate) activateToolwindow(view)", imports={}))
    public final void activateToolwindow(@NotNull CoverageView view, boolean activate2) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        if (activate2) {
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, view){
                final /* synthetic */ CoverageViewManager this$0;
                final /* synthetic */ CoverageView $view;
                {
                    this.this$0 = $receiver;
                    this.$view = $view;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.activateToolwindow(this.$view);
                }
            }), (int)1, null);
        }
    }

    @Deprecated(message="Use createView instead", replaceWith=@ReplaceWith(expression="createView(suitesBundle, activate)", imports={}))
    @RequiresEdt
    public final void createToolWindow(@NotNull CoverageSuitesBundle suitesBundle, boolean activate2) {
        Intrinsics.checkNotNullParameter((Object)suitesBundle, (String)"suitesBundle");
        this.createView(suitesBundle, activate2);
    }

    private final ContentManager getContentManager() {
        ToolWindow toolWindow;
        ContentManager contentManager = this.myContentManager;
        if (contentManager != null) {
            ContentManager it = contentManager;
            boolean bl = false;
            return it;
        }
        ToolWindow toolWindow2 = this.getToolWindow();
        if (toolWindow2 != null && (toolWindow2 = toolWindow2.getContentManager()) != null) {
            ToolWindow toolWindow3;
            ToolWindow it = toolWindow3 = toolWindow2;
            boolean bl = false;
            this.myContentManager = it;
            toolWindow = toolWindow3;
        } else {
            toolWindow = null;
        }
        return toolWindow;
    }

    private final ToolWindow getToolWindow() {
        return ToolWindowManager.Companion.getInstance(this.myProject).getToolWindow(TOOLWINDOW_ID);
    }

    @JvmStatic
    @NotNull
    public static final CoverageViewManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    @Nullable
    public static final CoverageViewManager getInstanceIfCreated(@NotNull Project project2) {
        return Companion.getInstanceIfCreated(project2);
    }

    public static final /* synthetic */ ContentManager access$getMyContentManager$p(CoverageViewManager $this) {
        return $this.myContentManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/coverage/view/CoverageViewManager$Companion;", "", "()V", "TOOLWINDOW_ID", "", "Lorg/jetbrains/annotations/NonNls;", "getDisplayName", "Lcom/intellij/openapi/util/NlsSafe;", "suitesBundle", "Lcom/intellij/coverage/CoverageSuitesBundle;", "getInstance", "Lcom/intellij/coverage/view/CoverageViewManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "intellij.platform.coverage"})
    @SourceDebugExtension(value={"SMAP\nCoverageViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageViewManager.kt\ncom/intellij/coverage/view/CoverageViewManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,207:1\n31#2,2:208\n59#2:210\n*S KotlinDebug\n*F\n+ 1 CoverageViewManager.kt\ncom/intellij/coverage/view/CoverageViewManager$Companion\n*L\n196#1:208,2\n199#1:210\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CoverageViewManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<CoverageViewManager> serviceClass$iv = CoverageViewManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CoverageViewManager)object;
        }

        @JvmStatic
        @Nullable
        public final CoverageViewManager getInstanceIfCreated(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
            boolean $i$f$serviceIfCreated = false;
            return (CoverageViewManager)$this$serviceIfCreated$iv.getServiceIfCreated(CoverageViewManager.class);
        }

        @Nullable
        public final String getDisplayName(@NotNull CoverageSuitesBundle suitesBundle) {
            Intrinsics.checkNotNullParameter((Object)suitesBundle, (String)"suitesBundle");
            RunConfigurationBase configuration = suitesBundle.getRunConfiguration();
            Object object = configuration;
            if (object == null || (object = object.getName()) == null) {
                object = suitesBundle.getPresentableName();
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/coverage/view/CoverageViewManager$CoverageViewSettingsListener;", "", "onSettingsChanged", "", "stateBean", "Lcom/intellij/coverage/view/CoverageViewManager$StateBean;", "intellij.platform.coverage"})
    public static interface CoverageViewSettingsListener {
        public void onSettingsChanged(@Nullable StateBean var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bJ\b\u0010#\u001a\u00020\u001fH\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\nR$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\nR\u0012\u0010\u0011\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/coverage/view/CoverageViewManager$StateBean;", "", "()V", "<set-?>", "", "isDefaultFilters", "()Z", "flattenPackages", "isFlattenPackages", "setFlattenPackages", "(Z)V", "hideFullyCovered", "isHideFullyCovered", "setHideFullyCovered", "showOnlyModified", "isShowOnlyModified", "setShowOnlyModified", "myAscendingOrder", "myAutoScrollFromSource", "myAutoScrollToSource", "myColumnSize", "", "", "myFlattenPackages", "myHideFullyCovered", "myListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/coverage/view/CoverageViewManager$CoverageViewSettingsListener;", "myShowOnlyModified", "mySortingColumn", "addListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "fireChanged", "intellij.platform.coverage"})
    public static final class StateBean {
        private boolean myFlattenPackages;
        @JvmField
        public boolean myAutoScrollToSource;
        @JvmField
        public boolean myAutoScrollFromSource;
        @JvmField
        @Nullable
        public List<Integer> myColumnSize;
        @JvmField
        public boolean myAscendingOrder = true;
        @JvmField
        public int mySortingColumn;
        private boolean myHideFullyCovered;
        private boolean myShowOnlyModified = true;
        private boolean isDefaultFilters = true;
        @NotNull
        private final DisposableWrapperList<CoverageViewSettingsListener> myListeners = new DisposableWrapperList();

        public final boolean isDefaultFilters() {
            return this.isDefaultFilters;
        }

        public final boolean isFlattenPackages() {
            return this.myFlattenPackages;
        }

        public final void setFlattenPackages(boolean flattenPackages) {
            if (this.myFlattenPackages != flattenPackages) {
                this.myFlattenPackages = flattenPackages;
                this.fireChanged();
            }
        }

        public final boolean isHideFullyCovered() {
            return this.myHideFullyCovered;
        }

        public final void setHideFullyCovered(boolean hideFullyCovered) {
            if (this.myHideFullyCovered != hideFullyCovered) {
                this.myHideFullyCovered = hideFullyCovered;
                this.isDefaultFilters = false;
                this.fireChanged();
            }
        }

        public final boolean isShowOnlyModified() {
            return this.myShowOnlyModified;
        }

        public final void setShowOnlyModified(boolean showOnlyModified) {
            if (this.myShowOnlyModified != showOnlyModified) {
                this.myShowOnlyModified = showOnlyModified;
                this.isDefaultFilters = false;
                this.fireChanged();
            }
        }

        public final void addListener(@NotNull Disposable disposable, @NotNull CoverageViewSettingsListener listener2) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.myListeners.add((Object)listener2, disposable);
        }

        private final void fireChanged() {
            for (CoverageViewSettingsListener listener2 : this.myListeners) {
                listener2.onSettingsChanged(this);
            }
        }
    }
}

