/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class Reverter {
    private final Project myProject;
    protected LocalHistoryFacade myVcs;
    protected final IdeaGateway myGateway;
    private final Supplier<@NlsContexts.Command String> myCommandName;

    protected Reverter(Project p, LocalHistoryFacade vcs, IdeaGateway gw, @NotNull Supplier<@NlsContexts.Command String> commandName) {
        if (commandName == null) {
            Reverter.$$$reportNull$$$0(0);
        }
        this.myProject = p;
        this.myVcs = vcs;
        this.myGateway = gw;
        this.myCommandName = commandName;
    }

    @Deprecated
    public List<String> askUserForProceeding() throws IOException {
        return Collections.emptyList();
    }

    public List<String> checkCanRevert() throws IOException {
        if (!this.askForReadOnlyStatusClearing()) {
            return Collections.singletonList(LocalHistoryBundle.message("revert.error.files.are.read.only", new Object[0]));
        }
        return Collections.emptyList();
    }

    protected boolean askForReadOnlyStatusClearing() {
        return this.myGateway.ensureFilesAreWritable(this.myProject, this.getFilesToClearROStatus());
    }

    public void revert() throws Exception {
        try {
            WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(() -> {
                this.myGateway.saveAllUnsavedDocuments();
                this.doRevert();
                this.myGateway.saveAllUnsavedDocuments();
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    @NlsContexts.Command
    public String getCommandName() {
        return this.myCommandName.get();
    }

    @NotNull
    protected abstract List<VirtualFile> getFilesToClearROStatus();

    protected abstract void doRevert() throws IOException;

    @NotNull
    @Nls
    public static String getRevertCommandName(@NotNull Revision to) {
        if (to == null) {
            Reverter.$$$reportNull$$$0(1);
        }
        String name = to.getChangeSetName();
        String date = DateFormatUtil.formatDateTime((long)to.getTimestamp());
        if (name != null) {
            String string2 = LocalHistoryBundle.message("system.label.revert.to.change.date", name, date);
            if (string2 == null) {
                Reverter.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String string3 = LocalHistoryBundle.message("system.label.revert.to.date", date);
        if (string3 == null) {
            Reverter.$$$reportNull$$$0(3);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/revertion/Reverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/revertion/Reverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevertCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRevertCommandName";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

