/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diff.Block;
import com.intellij.history.core.Content;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0002$%B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u0006H$J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0016\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001f\u001a\u00020 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\"R\u001e\u0010\u000b\u001a\u0012\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "revisions", "", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "fromLine", "", "toLine", "(Lcom/intellij/history/integration/IdeaGateway;Ljava/util/List;II)V", "cache", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lcom/intellij/diff/Block;", "Lorg/jetbrains/annotations/NotNull;", "getRevisions$intellij_platform_lvcs_impl", "()Ljava/util/List;", "canCalculateFor", "", "revision", "progress", "Lcom/intellij/history/integration/ui/models/Progress;", "doGetSelectionFor", "findLastNonEmptyBlock", "Lkotlin/collections/IndexedValue;", "revisionIndex", "getEntry", "Lcom/intellij/history/core/tree/Entry;", "getRevisionContent", "", "getSelectionFor", "processContents", "", "processor", "Lkotlin/Function2;", "", "Companion", "ContentIsUnavailableException", "intellij.platform.lvcs.impl"})
public abstract class SelectionCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdeaGateway gateway;
    @NotNull
    private final List<RevisionId> revisions;
    private final int fromLine;
    private final int toLine;
    @NotNull
    private final ConcurrentIntObjectMap<Block> cache;
    @NotNull
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);

    public SelectionCalculator(@NotNull IdeaGateway gateway, @NotNull List<? extends RevisionId> revisions, int fromLine, int toLine) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
        this.gateway = gateway;
        this.revisions = revisions;
        this.fromLine = fromLine;
        this.toLine = toLine;
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.cache = concurrentIntObjectMap;
    }

    @NotNull
    public final List<RevisionId> getRevisions$intellij_platform_lvcs_impl() {
        return this.revisions;
    }

    public final boolean canCalculateFor(@NotNull RevisionId revision, @NotNull Progress progress) {
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        try {
            this.doGetSelectionFor(revision, progress);
        }
        catch (ContentIsUnavailableException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final Block getSelectionFor(@NotNull RevisionId revision, @NotNull Progress progress) {
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        return this.doGetSelectionFor(revision, progress);
    }

    private final Block doGetSelectionFor(RevisionId revision, Progress progress) {
        int target = this.revisions.indexOf(revision);
        return this.getSelectionFor(target, progress);
    }

    private final Block getSelectionFor(int revisionIndex, Progress progress) {
        Block block;
        Block lastNonEmptyBlock;
        Block cached;
        Block block2 = cached = (Block)this.cache.get(revisionIndex);
        if (block2 != null) {
            return block2;
        }
        IndexedValue<Block> indexedValue = this.findLastNonEmptyBlock(revisionIndex);
        int lastNonEmptyIndex = indexedValue.component1();
        Block lastBlock = lastNonEmptyBlock = (Block)indexedValue.component2();
        int currentIndex = lastNonEmptyIndex + 1;
        if (currentIndex <= revisionIndex) {
            while (true) {
                Block block3;
                String content = this.getRevisionContent(this.revisions.get(currentIndex));
                progress.processed((currentIndex + 1) * 100 / (revisionIndex + 1));
                if (content == null) {
                    block3 = EMPTY_BLOCK;
                } else if (currentIndex == 0) {
                    block3 = new Block(content, this.fromLine, this.toLine + 1);
                } else {
                    Block nextBlock = lastBlock;
                    Block block4 = nextBlock.createPreviousBlock(content);
                    Intrinsics.checkNotNull((Object)block4);
                    block3 = block4;
                }
                Block result2 = block3;
                this.cache.put(currentIndex, (Object)result2);
                if (!Intrinsics.areEqual((Object)result2, (Object)EMPTY_BLOCK)) {
                    lastBlock = result2;
                }
                if (currentIndex == revisionIndex) break;
                ++currentIndex;
            }
        }
        if ((block = (Block)this.cache.get(revisionIndex)) == null) {
            block = EMPTY_BLOCK;
        }
        return block;
    }

    private final IndexedValue<Block> findLastNonEmptyBlock(int revisionIndex) {
        for (int index = revisionIndex; -1 < index; --index) {
            Block cachedBlock = (Block)this.cache.get(index);
            if (cachedBlock == null || Intrinsics.areEqual((Object)cachedBlock, (Object)EMPTY_BLOCK)) continue;
            return new IndexedValue(index, (Object)cachedBlock);
        }
        return new IndexedValue(-1, (Object)EMPTY_BLOCK);
    }

    private final String getRevisionContent(RevisionId revision) {
        Entry entry2 = this.getEntry(revision);
        if (entry2 == null) {
            return null;
        }
        Entry entry3 = entry2;
        Content content = entry3.getContent();
        if (!content.isAvailable()) {
            throw new ContentIsUnavailableException();
        }
        return content.getString(entry3, this.gateway);
    }

    @Nullable
    protected abstract Entry getEntry(@NotNull RevisionId var1);

    public final void processContents(@NotNull Function2<? super Long, ? super String, Boolean> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Iterator<RevisionId> iterator = this.revisions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            RevisionId revisionId = iterator.next();
            Progress progress = Progress.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)progress, (String)"EMPTY");
            Block block = this.getSelectionFor(index, progress);
            if (!(revisionId instanceof RevisionId.ChangeSet)) continue;
            Long l = ((RevisionId.ChangeSet)revisionId).getId();
            String string2 = block.getBlockContent();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBlockContent(...)");
            if (((Boolean)processor2.invoke((Object)l, (Object)string2)).booleanValue()) continue;
            break;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/history/integration/ui/models/SelectionCalculator$Companion;", "", "()V", "EMPTY_BLOCK", "Lcom/intellij/diff/Block;", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/history/integration/ui/models/SelectionCalculator$ContentIsUnavailableException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "intellij.platform.lvcs.impl"})
    private static final class ContentIsUnavailableException
    extends RuntimeException {
    }
}

