/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions.commit;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\nJT\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007JM\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\n2\r\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/vcs/actions/commit/CheckinActionUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getIncludedChanges", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "selectedUnversioned", "Lcom/intellij/openapi/vcs/FilePath;", "initialChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "pathsToCommit", "getInitiallySelectedChangeList", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getInitiallySelectedChangeListFor", "performCheckInAfterUpdate", "", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "forceUpdateCommitStateFromContext", "", "performCommonCommitAction", "actionName", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "updateCommonCommitAction", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCheckinActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckinActionUtil.kt\ncom/intellij/openapi/vcs/actions/commit/CheckinActionUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n37#2,2:153\n1#3:155\n11#4:156\n*S KotlinDebug\n*F\n+ 1 CheckinActionUtil.kt\ncom/intellij/openapi/vcs/actions/commit/CheckinActionUtil\n*L\n76#1:153,2\n30#1:156\n*E\n"})
public final class CheckinActionUtil {
    @NotNull
    public static final CheckinActionUtil INSTANCE = new CheckinActionUtil();
    @NotNull
    private static final Logger LOG;

    private CheckinActionUtil() {
    }

    public final void updateCommonCommitAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        if (project2 == null || !ProjectLevelVcsManager.getInstance(project2).hasActiveVcss() || CommitModeManager.Companion.getInstance(project2).getCurrentCommitMode().disableDefaultCommitAction()) {
            presentation3.setEnabledAndVisible(false);
            return;
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance(project2);
        AbstractVcs singleVcs = projectLevelVcsManager.getSingleVCS();
        presentation3.setEnabled(!projectLevelVcsManager.isBackgroundVcsOperationRunning() && (singleVcs == null || !singleVcs.isCommitActionDisabled()));
        presentation3.setVisible(true);
    }

    public final void performCommonCommitAction(@NotNull AnActionEvent e, @NotNull Project project2, @NotNull LocalChangeList initialChangeList, @NotNull List<? extends FilePath> pathsToCommit, @Nullable String actionName, @Nullable CommitExecutor executor, boolean forceUpdateCommitStateFromContext) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialChangeList, (String)"initialChangeList");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        LOG.debug("performCommonCommitAction");
        String string3 = actionName;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            String operationName = AbstractCommitWorkflowKt.cleanActionText$default(actionName, false, 2, null);
            Object[] objectArray = new Object[]{operationName};
            string2 = VcsBundle.message("error.cant.perform.operation.now", objectArray);
        } else {
            string2 = null;
        }
        String isFreezedDialogTitle = string2;
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        if (changeListManager2.isFreezedWithNotification(isFreezedDialogTitle)) {
            LOG.debug("ChangeListManager is freezed, abort commit");
            return;
        }
        if (ProjectLevelVcsManager.getInstance(project2).isBackgroundVcsOperationRunning()) {
            LOG.debug("Background operation is running, abort commit");
            return;
        }
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        List list2 = objectArray != null ? ArraysKt.asList((Object[])objectArray) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List selectedChanges = list2;
        Iterable iterable = (Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY);
        List list3 = iterable != null ? CollectionsKt.toList((Iterable)iterable) : null;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List selectedUnversioned = list3;
        Collection $this$toTypedArray$iv = pathsToCommit;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FilePath[] filePathArray = DescindingFilesFilter.filterDescindingFiles(thisCollection$iv.toArray(new FilePath[0]), project2);
        Intrinsics.checkNotNullExpressionValue((Object)filePathArray, (String)"filterDescindingFiles(...)");
        List filteredPaths = ArraysKt.asList((Object[])filePathArray);
        this.performCheckInAfterUpdate(project2, selectedChanges, selectedUnversioned, initialChangeList, filteredPaths, executor, forceUpdateCommitStateFromContext);
    }

    @RequiresEdt
    public final void performCheckInAfterUpdate(@NotNull Project project2, @NotNull List<? extends Change> selectedChanges, @NotNull List<? extends FilePath> selectedUnversioned, @NotNull LocalChangeList initialChangeList, @NotNull List<? extends FilePath> pathsToCommit, @Nullable CommitExecutor executor, boolean forceUpdateCommitStateFromContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(selectedChanges, (String)"selectedChanges");
        Intrinsics.checkNotNullParameter(selectedUnversioned, (String)"selectedUnversioned");
        Intrinsics.checkNotNullParameter((Object)initialChangeList, (String)"initialChangeList");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        FileDocumentManager.getInstance().saveAllDocuments();
        String string2 = CommonBundle.message((String)"title.save.project", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking((Project)project2, (String)string2, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project2, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = StoreUtilKt.saveSettings$default((ComponentManager)((ComponentManager)this.$project), (boolean)false, (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        ChangesViewCommitWorkflowHandler workflowHandler = ChangesViewWorkflowManager.getInstance(project2).getCommitWorkflowHandler();
        if (executor == null && workflowHandler != null) {
            Collection<Object> included = this.getIncludedChanges(project2, selectedChanges, selectedUnversioned, initialChangeList, pathsToCommit);
            workflowHandler.setCommitState(initialChangeList, included, forceUpdateCommitStateFromContext);
            workflowHandler.activate();
        } else {
            ChangeListManager.getInstance(project2).invokeAfterUpdateWithModal(true, VcsBundle.message("waiting.changelists.update.for.show.commit.dialog.message", new Object[0]), () -> CheckinActionUtil.performCheckInAfterUpdate$lambda$1(project2, selectedChanges, selectedUnversioned, initialChangeList, pathsToCommit, executor));
        }
    }

    private final Collection<Object> getIncludedChanges(Project project2, List<? extends Change> selectedChanges, List<? extends FilePath> selectedUnversioned, LocalChangeList initialChangeList, List<? extends FilePath> pathsToCommit) {
        if (selectedChanges.isEmpty() && selectedUnversioned.isEmpty()) {
            Collection<Change> collection = ChangeListManager.getInstance(project2).getAllChanges();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllChanges(...)");
            Collection<Change> allChanges = collection;
            Set set = VcsImplUtil.filterChangesUnder((Iterable<? extends Change>)allChanges, (Collection<FilePath>)pathsToCommit).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set changesToCommit = set;
            Collection<Change> collection2 = initialChangeList.getChanges();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getChanges(...)");
            return CollectionsKt.intersect((Iterable)collection2, (Iterable)changesToCommit);
        }
        List list2 = ContainerUtil.concat(selectedChanges, selectedUnversioned);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"concat(...)");
        return list2;
    }

    @NotNull
    public final LocalChangeList getInitiallySelectedChangeList(@NotNull Project project2, @NotNull AnActionEvent e) {
        Object object;
        Object object2;
        Object object3;
        ChangeListManager manager;
        block8: {
            Object object4;
            block7: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
                manager = changeListManager;
                object3 = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
                if (object3 == null || (object3 = (ChangeList)ArraysKt.firstOrNull((Object[])object3)) == null) break block7;
                Object it = object3;
                boolean bl = false;
                LocalChangeList localChangeList = manager.findChangeList(it.getName());
                object3 = localChangeList;
                if (localChangeList != null) break block8;
            }
            if ((object4 = (Change[])e.getData(VcsDataKeys.CHANGES)) != null && (object4 = (Change)ArraysKt.firstOrNull((Object[])object4)) != null) {
                Object it = object4;
                boolean bl = false;
                object3 = manager.getChangeList((Change)it);
            } else {
                object3 = null;
            }
        }
        if ((object2 = object3) == null) {
            LocalChangeList localChangeList = manager.getDefaultChangeList();
            object = localChangeList;
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        } else {
            object = object2;
        }
        return object;
    }

    @NotNull
    public final LocalChangeList getInitiallySelectedChangeListFor(@NotNull Project project2, @NotNull List<? extends FilePath> pathsToCommit) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManagerEx, (String)"getInstanceEx(...)");
        ChangeListManagerEx manager = changeListManagerEx;
        LocalChangeList localChangeList = manager.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        LocalChangeList defaultChangeList = localChangeList;
        JBIterable<? extends Change> jBIterable = VcsImplUtil.filterChangesUnder((Iterable<? extends Change>)defaultChangeList.getChanges(), (Collection<FilePath>)pathsToCommit);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"filterChangesUnder(...)");
        JBIterable<? extends Change> selectedInDefault = jBIterable;
        if (selectedInDefault.isNotEmpty()) {
            return defaultChangeList;
        }
        JBIterable<? extends Change> jBIterable2 = VcsImplUtil.filterChangesUnder((Iterable<? extends Change>)manager.getAllChanges(), (Collection<FilePath>)pathsToCommit);
        Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"filterChangesUnder(...)");
        JBIterable<? extends Change> selectedChanges = jBIterable2;
        Collection<LocalChangeList> collection = manager.getAffectedLists(selectedChanges.toList());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAffectedLists(...)");
        Collection<LocalChangeList> changeLists = collection;
        LocalChangeList localChangeList2 = (LocalChangeList)CollectionsKt.singleOrNull((Iterable)changeLists);
        if (localChangeList2 == null) {
            localChangeList2 = defaultChangeList;
        }
        return localChangeList2;
    }

    private static final void performCheckInAfterUpdate$lambda$1(Project $project, List $selectedChanges, List $selectedUnversioned, LocalChangeList $initialChangeList, List $pathsToCommit, CommitExecutor $executor) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$selectedChanges, (String)"$selectedChanges");
        Intrinsics.checkNotNullParameter((Object)$selectedUnversioned, (String)"$selectedUnversioned");
        Intrinsics.checkNotNullParameter((Object)$initialChangeList, (String)"$initialChangeList");
        Intrinsics.checkNotNullParameter((Object)$pathsToCommit, (String)"$pathsToCommit");
        Collection<Object> included = INSTANCE.getIncludedChanges($project, $selectedChanges, $selectedUnversioned, $initialChangeList, $pathsToCommit);
        if ($executor != null) {
            CommitChangeListDialog.commitWithExecutor($project, included, $initialChangeList, $executor, null, null);
        } else {
            CommitChangeListDialog.commitVcsChanges($project, included, $initialChangeList, null, null);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CheckinActionUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

