/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IgnoredBeanFactory {
    private IgnoredBeanFactory() {
    }

    @NotNull
    public static IgnoredFileBean ignoreUnderDirectory(@NotNull @NlsSafe String path2, @Nullable Project p) {
        if (path2 == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(0);
        }
        String correctedPath = path2.endsWith("/") || path2.endsWith(File.separator) ? path2 : path2 + "/";
        return new IgnoredFileBean(correctedPath, IgnoreSettingsType.UNDER_DIR, p);
    }

    @NotNull
    public static IgnoredFileBean ignoreFile(@NotNull @NlsSafe String path2, @Nullable Project p) {
        if (path2 == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(1);
        }
        return new IgnoredFileBean(path2, IgnoreSettingsType.FILE, p);
    }

    @NotNull
    public static IgnoredFileBean ignoreFile(@NotNull VirtualFile file, @Nullable Project p) {
        if (file == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(2);
        }
        if (file.isDirectory()) {
            return IgnoredBeanFactory.ignoreUnderDirectory(file.getPath(), p);
        }
        return IgnoredBeanFactory.ignoreFile(file.getPath(), p);
    }

    @NotNull
    public static IgnoredFileBean withMask(@NotNull @NonNls String mask) {
        if (mask == null) {
            IgnoredBeanFactory.$$$reportNull$$$0(3);
        }
        return new IgnoredFileBean(mask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredBeanFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreUnderDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withMask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

