/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.CommitModeManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 62\u00020\u00012\u00020\u0002:\u0003678B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0016J'\u0010#\u001a\u0004\u0018\u0001H$\"\b\b\u0000\u0010$*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'H\u0016\u00a2\u0006\u0002\u0010(J\u0012\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\u000e\u0010+\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010-\u001a\u00020\u0015H\u0002J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010/\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u000fJ\u0010\u00101\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0018\u00101\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u00100\u001a\u00020\u000fH\u0016J\b\u00102\u001a\u00020\u000fH\u0002J\b\u00103\u001a\u00020\u0015H\u0002J\u000e\u00104\u001a\u0004\u0018\u00010\u000b*\u00020\bH\u0002J\f\u00105\u001a\u00020\u001e*\u00020\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addedContents", "", "Lcom/intellij/ui/content/Content;", "contentManagers", "", "Lcom/intellij/ui/content/ContentManager;", "getContentManagers", "()Ljava/util/Collection;", "isCommitToolWindowShown", "", "selectedAddedContent", "toolWindows", "", "Lcom/intellij/openapi/wm/ToolWindow;", "addContent", "", "content", "addIntoCorrectPlace", "contentManager", "attachToolWindow", "toolWindow", "dispose", "findContent", "tabName", "", "findContents", "", "predicate", "Ljava/util/function/Predicate;", "getActiveComponent", "T", "", "aClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getContentToolWindowId", "initContentManager", "initLazyContent", "isContentSelected", "remapContents", "removeContent", "selectContent", "requestFocus", "setSelectedContent", "shouldUseCommitToolWindow", "updateToolWindowMappings", "resolveContentManager", "resolveToolWindowId", "Companion", "ContentProvidersListener", "TabOrderWeight", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nChangesViewContentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewContentManager.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1549#2:339\n1620#2,3:340\n1855#2,2:344\n1855#2,2:346\n1855#2,2:348\n766#2:350\n857#2,2:351\n1855#2,2:353\n1747#2,3:355\n1360#2:358\n1446#2,5:359\n766#2:364\n857#2,2:365\n1#3:343\n*S KotlinDebug\n*F\n+ 1 ChangesViewContentManager.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager\n*L\n47#1:339\n47#1:340,3\n85#1:344,2\n95#1:346,2\n96#1:348,2\n111#1:350\n111#1:351,2\n112#1:353,2\n181#1:355,3\n194#1:358\n194#1:359,5\n195#1:364\n195#1:365,2\n*E\n"})
public final class ChangesViewContentManager
implements ChangesViewContentI,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<Content> addedContents;
    @Nullable
    private Content selectedAddedContent;
    @NotNull
    private final Set<ToolWindow> toolWindows;
    private boolean isCommitToolWindowShown;
    @NotNull
    public static final String TOOLWINDOW_ID = "Version Control";
    @NotNull
    public static final String COMMIT_TOOLWINDOW_ID = "Commit";
    @JvmField
    @NotNull
    public static final Key<Function0<ChangesViewContentProvider>> CONTENT_PROVIDER_SUPPLIER_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> IS_IN_COMMIT_TOOLWINDOW_KEY;
    @JvmField
    @NotNull
    public static final DataKey<String> CONTENT_TAB_NAME_KEY;
    @JvmField
    @NotNull
    public static final Key<Integer> ORDER_WEIGHT_KEY;
    @NotNull
    public static final String LOCAL_CHANGES = "Local Changes";
    @NotNull
    public static final String CONSOLE = "Console";
    @NotNull
    public static final String REPOSITORY = "Repository";
    @NotNull
    public static final String INCOMING = "Incoming";
    @NotNull
    public static final String SHELF = "Shelf";
    @NotNull
    public static final String BRANCHES = "Branches";
    @NotNull
    public static final String VCS_LOG = "Log";

    public ChangesViewContentManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.addedContents = new ArrayList();
        this.toolWindows = new LinkedHashSet();
        this.isCommitToolWindowShown = this.shouldUseCommitToolWindow();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.project).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

            public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)"vcs.commit.tool.window")) {
                    this.updateToolWindowMappings();
                }
            }
        });
        MessageBusConnection projectBusConnection = this.project.getMessageBus().connect();
        CommitModeManager.Companion.subscribeOnCommitModeChange((SimpleMessageBusConnection)projectBusConnection, new CommitModeManager.CommitModeListener(){

            @Override
            public void commitModeChanged() {
                this.updateToolWindowMappings();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ContentManager> getContentManagers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.toolWindows;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ToolWindow toolWindow = (ToolWindow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContentManager());
        }
        return (List)destination$iv$iv;
    }

    private final String resolveToolWindowId(Content $this$resolveToolWindowId) {
        boolean isInCommitToolWindow = Intrinsics.areEqual((Object)IS_IN_COMMIT_TOOLWINDOW_KEY.get((UserDataHolder)$this$resolveToolWindowId), (Object)true);
        if (isInCommitToolWindow && this.isCommitToolWindowShown) {
            return COMMIT_TOOLWINDOW_ID;
        }
        return TOOLWINDOW_ID;
    }

    private final ContentManager resolveContentManager(Content $this$resolveContentManager) {
        ToolWindow toolWindow;
        Object v0;
        block1: {
            String toolWindowId = this.resolveToolWindowId($this$resolveContentManager);
            Iterable iterable = this.toolWindows;
            for (Object t : iterable) {
                ToolWindow it = (ToolWindow)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)toolWindowId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        ToolWindow toolWindow2 = toolWindow = (ToolWindow)v0;
        return toolWindow2 != null ? toolWindow2.getContentManager() : null;
    }

    private final void updateToolWindowMappings() {
        this.isCommitToolWindowShown = this.shouldUseCommitToolWindow();
        this.remapContents();
        ((ChangesViewContentManagerListener)this.project.getMessageBus().syncPublisher(ChangesViewContentManagerListener.TOPIC)).toolWindowMappingChanged();
        Iterable $this$forEach$iv = this.getContentManagers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentManager it = (ContentManager)element$iv;
            boolean bl = false;
            ChangesViewContentManagerKt.selectFirstContent(it);
        }
    }

    private final boolean shouldUseCommitToolWindow() {
        return AdvancedSettings.Companion.getBoolean("vcs.commit.tool.window") && CommitModeManager.Companion.getInstance(this.project).getCurrentCommitMode().useCommitToolWindow();
    }

    private final void remapContents() {
        Content it;
        List<Content> remapped = this.findContents(arg_0 -> ChangesViewContentManager.remapContents$lambda$3(this, arg_0));
        Iterable $this$forEach$iv = remapped;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Content)element$iv;
            boolean bl = false;
            this.removeContent(it, false);
        }
        $this$forEach$iv = remapped;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Content)element$iv;
            boolean bl = false;
            this.addContent(it);
        }
    }

    @Override
    public void attachToolWindow(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.toolWindows.add(toolWindow);
        this.initContentManager(toolWindow);
    }

    /*
     * WARNING - void declaration
     */
    private final void initContentManager(ToolWindow toolWindow) {
        void $this$filterTo$iv$iv;
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        ContentProvidersListener listener2 = new ContentProvidersListener(toolWindow);
        contentManager2.addContentManagerListener((ContentManagerListener)listener2);
        Disposer.register((Disposable)this, () -> ChangesViewContentManager.initContentManager$lambda$6(contentManager2, listener2));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener2);
        Iterable $this$filter$iv = this.addedContents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Content it = (Content)element$iv$iv;
            boolean bl = false;
            if (!(this.resolveContentManager(it) == contentManager2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List contents = (List)destination$iv$iv;
        Iterable $this$forEach$iv = contents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            this.addIntoCorrectPlace(contentManager2, it);
            IJSwingUtilities.updateComponentTreeUI((Component)it.getComponent());
        }
        this.addedContents.removeAll(contents);
        Content toSelect = this.selectedAddedContent;
        if (toSelect != null && contents.contains(toSelect)) {
            contentManager2.setSelectedContent(toSelect);
        } else {
            ChangesViewContentManagerKt.selectFirstContent(contentManager2);
        }
        this.selectedAddedContent = null;
    }

    public void dispose() {
        for (Content content : this.addedContents) {
            Disposer.dispose((Disposable)((Disposable)content));
        }
        this.addedContents.clear();
        this.selectedAddedContent = null;
    }

    @Override
    public void addContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ContentManager contentManager = this.resolveContentManager(content);
        if (contentManager == null) {
            this.addedContents.add(content);
        } else {
            this.addIntoCorrectPlace(contentManager, content);
        }
    }

    @Override
    public void removeContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.removeContent(content, true);
    }

    private final void removeContent(Content content, boolean dispose) {
        ContentManager contentManager = content.getManager();
        if (contentManager == null || contentManager.isDisposed()) {
            this.addedContents.remove(content);
            if (Intrinsics.areEqual((Object)this.selectedAddedContent, (Object)content)) {
                this.selectedAddedContent = null;
            }
            if (dispose) {
                Disposer.dispose((Disposable)((Disposable)content));
            }
        } else {
            contentManager.removeContent(content, dispose);
        }
    }

    @Override
    public void setSelectedContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.setSelectedContent(content, false);
    }

    @Override
    public void setSelectedContent(@NotNull Content content, boolean requestFocus2) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ChangesViewContentManagerKt.access$getLOG$p().debug("select content: " + content.getTabName());
        ContentManager contentManager = content.getManager();
        if (contentManager != null) {
            contentManager.setSelectedContent(content, requestFocus2);
            this.selectedAddedContent = null;
        } else if (this.addedContents.contains(content)) {
            this.selectedAddedContent = content;
        }
    }

    @Override
    @Nullable
    public <T> T getActiveComponent(@NotNull Class<T> aClass) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
            for (ContentManager it : (Iterable)this.getContentManagers()) {
                boolean bl = false;
                Content content = it.getSelectedContent();
                Object object2 = ObjectUtils.tryCast((Object)(content != null ? content.getComponent() : null), aClass);
                if (object2 == null) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (T)object;
    }

    public final boolean isContentSelected(@NotNull String tabName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
            Iterable $this$any$iv = this.getContentManagers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ContentManager it = (ContentManager)element$iv;
                    boolean bl2 = false;
                    Content content = it.getSelectedContent();
                    if (!Intrinsics.areEqual((Object)(content != null ? content.getTabName() : null), (Object)tabName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void selectContent(@NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        this.selectContent(tabName, false);
    }

    public final void selectContent(@NotNull String tabName, boolean requestFocus2) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        ChangesViewContentManagerKt.access$getLOG$p().debug("select content: " + tabName);
        Content content = this.findContent(tabName);
        if (content == null) {
            return;
        }
        Content content2 = content;
        this.setSelectedContent(content2, requestFocus2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Content> findContents(@NotNull Predicate<Content> predicate) {
        void $this$filterTo$iv$iv;
        ContentManager it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterable $this$flatMap$iv = this.getContentManagers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ContentManager)element$iv$iv;
            boolean bl = false;
            Content[] contentArray = it.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Iterable list$iv$iv = ArraysKt.asList((Object[])contentArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allContents = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.addedContents);
        Iterable $this$filter$iv = allContents;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Content)element$iv$iv;
            boolean bl = false;
            if (!predicate.test((Content)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Content findContent(@NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        return (Content)CollectionsKt.firstOrNull(this.findContents(arg_0 -> ChangesViewContentManager.findContent$lambda$13(tabName, arg_0)));
    }

    private final String getContentToolWindowId(String tabName) {
        Content content = this.findContent(tabName);
        if (content == null) {
            return null;
        }
        Content content2 = content;
        return this.resolveToolWindowId(content2);
    }

    public final void initLazyContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = (Function0)content.getUserData(CONTENT_PROVIDER_SUPPLIER_KEY);
        if (object == null || (object = (ChangesViewContentProvider)object.invoke()) == null) {
            return;
        }
        Object provider2 = object;
        content.putUserData(CONTENT_PROVIDER_SUPPLIER_KEY, null);
        provider2.initTabContent(content);
        IJSwingUtilities.updateComponentTreeUI((Component)content.getComponent());
    }

    private final void addIntoCorrectPlace(ContentManager contentManager, Content content) {
        int weight = ChangesViewContentManagerKt.access$getContentWeight(content);
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Content[] contents = contentArray;
        int index = -1;
        int n = contents.length;
        for (int i = 0; i < n; ++i) {
            Content content2 = contents[i];
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"get(...)");
            int oldWeight = ChangesViewContentManagerKt.access$getContentWeight(content2);
            if (oldWeight <= weight) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = contents.length;
        }
        contentManager.addContent(content, index);
    }

    private static final boolean remapContents$lambda$3(ChangesViewContentManager this$0, Content it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)this$0.resolveContentManager(it), (Object)it.getManager());
    }

    private static final void initContentManager$lambda$6(ContentManager $contentManager, ContentProvidersListener $listener) {
        Intrinsics.checkNotNullParameter((Object)$contentManager, (String)"$contentManager");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $contentManager.removeContentManagerListener((ContentManagerListener)$listener);
    }

    private static final boolean findContent$lambda$13(String $tabName, Content it) {
        Intrinsics.checkNotNullParameter((Object)$tabName, (String)"$tabName");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getTabName(), (Object)$tabName);
    }

    @JvmStatic
    @NotNull
    public static final ChangesViewContentI getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    public static final boolean isCommitToolWindowShown(@NotNull Project project2) {
        return Companion.isCommitToolWindowShown(project2);
    }

    @JvmStatic
    @NotNull
    public static final String getToolWindowIdFor(@NotNull Project project2, @NotNull String tabName) {
        return Companion.getToolWindowIdFor(project2, tabName);
    }

    @JvmStatic
    @Nullable
    public static final ToolWindow getToolWindowFor(@NotNull Project project2, @NotNull String tabName) {
        return Companion.getToolWindowFor(project2, tabName);
    }

    static {
        Key key2 = Key.create((String)"CONTENT_PROVIDER_SUPPLIER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CONTENT_PROVIDER_SUPPLIER_KEY = key2;
        Key key3 = Key.create((String)"ChangesViewContentManager.IS_IN_COMMIT_TOOLWINDOW_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        IS_IN_COMMIT_TOOLWINDOW_KEY = key3;
        DataKey dataKey = DataKey.create((String)"ChangesViewContentManager.CONTENT_TAB_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        CONTENT_TAB_NAME_KEY = dataKey;
        Key key4 = Key.create((String)"ChangesView.ContentOrderWeight");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"create(...)");
        ORDER_WEIGHT_KEY = key4;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u001d\u0010#\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R3\u0010\b\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b \f*\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\r8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000e\u001a\u001f\u0012\u0016\u0012\u0014 \f*\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00050\u0004\u00a2\u0006\u0002\b\u00050\u000f\u00a2\u0006\u0002\b\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\u0011\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00120\u00120\t\u00a2\u0006\u0002\b\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\u0014\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u00150\t\u00a2\u0006\u0002\b\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager$Companion;", "", "()V", "BRANCHES", "", "Lorg/jetbrains/annotations/NonNls;", "COMMIT_TOOLWINDOW_ID", "CONSOLE", "CONTENT_PROVIDER_SUPPLIER_KEY", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Function0;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "CONTENT_TAB_NAME_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "INCOMING", "IS_IN_COMMIT_TOOLWINDOW_KEY", "", "LOCAL_CHANGES", "ORDER_WEIGHT_KEY", "", "REPOSITORY", "SHELF", "TOOLWINDOW_ID", "VCS_LOG", "getInstance", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager;", "getToolWindowFor", "Lcom/intellij/openapi/wm/ToolWindow;", "tabName", "getToolWindowId", "contentEp", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentEP;", "getToolWindowId$intellij_platform_vcs_impl", "getToolWindowIdFor", "isCommitToolWindowShown", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nChangesViewContentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewContentManager.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n31#2,2:339\n1#3:341\n*S KotlinDebug\n*F\n+ 1 ChangesViewContentManager.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager$Companion\n*L\n276#1:339,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ChangesViewContentI getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ChangesViewContentI> serviceClass$iv = ChangesViewContentI.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ChangesViewContentI)object;
        }

        @Nullable
        public final ChangesViewContentManager getInstanceImpl(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ChangesViewContentI changesViewContentI = this.getInstance(project2);
            return changesViewContentI instanceof ChangesViewContentManager ? (ChangesViewContentManager)changesViewContentI : null;
        }

        @JvmStatic
        public final boolean isCommitToolWindowShown(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ChangesViewContentManager changesViewContentManager = this.getInstanceImpl(project2);
            return changesViewContentManager != null ? changesViewContentManager.isCommitToolWindowShown : false;
        }

        @JvmStatic
        @NotNull
        public final String getToolWindowIdFor(@NotNull Project project2, @NotNull String tabName) {
            Object v1;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
                ChangesViewContentManager changesViewContentManager = this.getInstanceImpl(project2);
                if (changesViewContentManager == null) {
                    return ChangesViewContentManager.TOOLWINDOW_ID;
                }
                ChangesViewContentManager manager = changesViewContentManager;
                String toolWindowId = manager.getContentToolWindowId(tabName);
                if (toolWindowId != null) {
                    return toolWindowId;
                }
                Iterable iterable = ChangesViewContentEP.EP_NAME.getExtensions((AreaInstance)project2);
                for (Object t : iterable) {
                    ChangesViewContentEP it = (ChangesViewContentEP)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.tabName, (Object)tabName)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            ChangesViewContentEP extension = v1;
            if (extension != null) {
                return this.getToolWindowId$intellij_platform_vcs_impl(project2, extension);
            }
            return ChangesViewContentManager.TOOLWINDOW_ID;
        }

        @NotNull
        public final String getToolWindowId$intellij_platform_vcs_impl(@NotNull Project project2, @NotNull ChangesViewContentEP contentEp) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)contentEp, (String)"contentEp");
            return contentEp.isInCommitToolWindow && this.isCommitToolWindowShown(project2) ? ChangesViewContentManager.COMMIT_TOOLWINDOW_ID : ChangesViewContentManager.TOOLWINDOW_ID;
        }

        @JvmStatic
        @Nullable
        public final ToolWindow getToolWindowFor(@NotNull Project project2, @NotNull String tabName) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
            return ToolWindowManager.Companion.getInstance(project2).getToolWindow(this.getToolWindowIdFor(project2, tabName));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager$ContentProvidersListener;", "Lcom/intellij/ui/content/ContentManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager;Lcom/intellij/openapi/wm/ToolWindow;)V", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "selectionChanged", "", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "stateChanged", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.platform.vcs.impl"})
    private final class ContentProvidersListener
    implements ContentManagerListener,
    ToolWindowManagerListener {
        @NotNull
        private final ToolWindow toolWindow;

        public ContentProvidersListener(ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            this.toolWindow = toolWindow;
        }

        @NotNull
        public final ToolWindow getToolWindow() {
            return this.toolWindow;
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
            if (this.toolWindow.isVisible()) {
                Content content = this.toolWindow.getContentManager().getSelectedContent();
                if (content == null) {
                    return;
                }
                Content content2 = content;
                ChangesViewContentManager.this.initLazyContent(content2);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.toolWindow.isVisible()) {
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                ChangesViewContentManager.this.initLazyContent(content);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManager$TabOrderWeight;", "", "tabName", "", "weight", "", "(Ljava/lang/String;ILjava/lang/String;I)V", "getTabName", "()Ljava/lang/String;", "getWeight", "()I", "LOCAL_CHANGES", "REPOSITORY", "INCOMING", "SHELF", "BRANCHES", "VCS_LOG", "CONSOLE", "OTHER", "LAST", "intellij.platform.vcs.impl"})
    public static final class TabOrderWeight
    extends Enum<TabOrderWeight> {
        @Nullable
        private final String tabName;
        private final int weight;
        public static final /* enum */ TabOrderWeight LOCAL_CHANGES = new TabOrderWeight("Local Changes", 10);
        public static final /* enum */ TabOrderWeight REPOSITORY = new TabOrderWeight("Repository", 20);
        public static final /* enum */ TabOrderWeight INCOMING = new TabOrderWeight("Incoming", 30);
        public static final /* enum */ TabOrderWeight SHELF = new TabOrderWeight("Shelf", 40);
        public static final /* enum */ TabOrderWeight BRANCHES = new TabOrderWeight("Branches", 50);
        public static final /* enum */ TabOrderWeight VCS_LOG = new TabOrderWeight("Log", 50);
        public static final /* enum */ TabOrderWeight CONSOLE = new TabOrderWeight("Console", 60);
        public static final /* enum */ TabOrderWeight OTHER = new TabOrderWeight(null, 100);
        public static final /* enum */ TabOrderWeight LAST = new TabOrderWeight(null, Integer.MAX_VALUE);
        private static final /* synthetic */ TabOrderWeight[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TabOrderWeight(String tabName, int weight) {
            this.tabName = tabName;
            this.weight = weight;
        }

        @Nullable
        public final String getTabName() {
            return this.tabName;
        }

        public final int getWeight() {
            return this.weight;
        }

        public static TabOrderWeight[] values() {
            return (TabOrderWeight[])$VALUES.clone();
        }

        public static TabOrderWeight valueOf(String value2) {
            return Enum.valueOf(TabOrderWeight.class, value2);
        }

        @NotNull
        public static EnumEntries<TabOrderWeight> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tabOrderWeightArray = new TabOrderWeight[]{TabOrderWeight.LOCAL_CHANGES, TabOrderWeight.REPOSITORY, TabOrderWeight.INCOMING, TabOrderWeight.SHELF, TabOrderWeight.BRANCHES, TabOrderWeight.VCS_LOG, TabOrderWeight.CONSOLE, TabOrderWeight.OTHER, TabOrderWeight.LAST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

