/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vcs.impl.ContentRootChangeListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/impl/ContentRootChangeListener;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "skipFileChanges", "", "(Z)V", "getSkipFileChanges", "()Z", "changed", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "contentRootsChanged", "removed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "added", "intellij.platform.vcs.impl"})
public abstract class ContentRootChangeListener
implements WorkspaceModelChangeListener {
    private final boolean skipFileChanges;

    public ContentRootChangeListener(boolean skipFileChanges) {
        this.skipFileChanges = skipFileChanges;
    }

    public final boolean getSkipFileChanges() {
        return this.skipFileChanges;
    }

    public void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Set removedUrls = new LinkedHashSet();
        Set addedUrls = new LinkedHashSet();
        List changes2 = event.getChanges(ContentRootEntity.class);
        for (EntityChange change : changes2) {
            ContentRootEntity contentRootEntity = (ContentRootEntity)change.getOldEntity();
            VirtualFileUrl removedUrl = contentRootEntity != null ? contentRootEntity.getUrl() : null;
            ContentRootEntity contentRootEntity2 = (ContentRootEntity)change.getNewEntity();
            Object addedUrl = contentRootEntity2 != null ? contentRootEntity2.getUrl() : null;
            if (Intrinsics.areEqual((Object)removedUrl, (Object)addedUrl)) continue;
            if (removedUrl != null) {
                ((Collection)removedUrls).add(removedUrl);
            }
            if (addedUrl == null) continue;
            ((Collection)addedUrls).add(addedUrl);
        }
        Sequence removed2 = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)removedUrls), (Function1)((Function1)new Function1<VirtualFileUrl, Boolean>((Set<VirtualFileUrl>)addedUrls){
            final /* synthetic */ Set<VirtualFileUrl> $addedUrls;
            {
                this.$addedUrls = $addedUrls;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFileUrl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$addedUrls.contains(it);
            }
        })), (Function1)changed.removed.2.INSTANCE);
        Sequence added2 = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)addedUrls), (Function1)((Function1)new Function1<VirtualFileUrl, Boolean>((Set<VirtualFileUrl>)removedUrls){
            final /* synthetic */ Set<VirtualFileUrl> $removedUrls;
            {
                this.$removedUrls = $removedUrls;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFileUrl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$removedUrls.contains(it);
            }
        })), (Function1)changed.added.2.INSTANCE);
        if (this.skipFileChanges) {
            removed2 = SequencesKt.filter((Sequence)removed2, (Function1)changed.1.INSTANCE);
            added2 = SequencesKt.filter((Sequence)added2, (Function1)changed.2.INSTANCE);
        }
        List removedList = SequencesKt.toList((Sequence)removed2);
        List addedList = SequencesKt.toList((Sequence)added2);
        if (!((Collection)removedList).isEmpty() || !((Collection)addedList).isEmpty()) {
            this.contentRootsChanged(removedList, addedList);
        }
    }

    public abstract void contentRootsChanged(@NotNull List<? extends VirtualFile> var1, @NotNull List<? extends VirtualFile> var2);
}

