/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import org.jetbrains.annotations.Nullable;

public class UpToDateLineNumberProviderImpl
implements UpToDateLineNumberProvider {
    private final Document myDocument;
    private final LineStatusTrackerManagerI myLineStatusTrackerManagerI;

    public UpToDateLineNumberProviderImpl(Document document2, Project project2) {
        this.myDocument = document2;
        this.myLineStatusTrackerManagerI = LineStatusTrackerManager.getInstance(project2);
    }

    @Override
    public boolean isRangeChanged(int start2, int end) {
        LineStatusTracker<?> tracker = this.getTracker();
        if (tracker == null) {
            return false;
        }
        return tracker.isRangeModified(start2, end);
    }

    @Override
    public boolean isLineChanged(int currentNumber) {
        LineStatusTracker<?> tracker = this.getTracker();
        if (tracker == null) {
            return false;
        }
        return tracker.isLineModified(currentNumber);
    }

    @Override
    public int getLineNumber(int currentNumber) {
        return this.getLineNumber(currentNumber, false);
    }

    @Override
    public int getLineNumber(int currentNumber, boolean approximate) {
        LineStatusTracker<?> tracker = this.getTracker();
        if (tracker == null) {
            return currentNumber;
        }
        return tracker.transferLineToVcs(currentNumber, approximate);
    }

    @Override
    public int getLineCount() {
        LineStatusTracker<?> tracker = this.getTracker();
        if (tracker == null) {
            return this.myDocument.getLineCount();
        }
        return tracker.getVcsDocument().getLineCount();
    }

    @Nullable
    private LineStatusTracker<?> getTracker() {
        LineStatusTracker<?> tracker = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        return tracker != null && tracker.isOperational() ? tracker : null;
    }
}

