/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.model;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.platform.ml.Feature;
import com.intellij.platform.ml.FeatureDeclaration;
import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.impl.FeatureSelector;
import com.intellij.platform.ml.impl.model.MLModel;
import com.intellij.platform.ml.impl.model.RegressionModel;
import com.intellij.platform.ml.impl.model.RegressionModelKt;
import com.intellij.platform.ml.impl.session.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fBI\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00120\u0010\u0007\u001a,\u0012(\u0012&\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\tj\u0002`\f0\b\u00a2\u0006\u0002\u0010\rB;\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u0012\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J;\u0010\u0017\u001a\u00020\u00022,\u0010\u0018\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\n0\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\n`\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0011\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel;", "Lcom/intellij/platform/ml/impl/model/MLModel;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "featureSerialization", "Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "sessionTiers", "", "Lcom/intellij/platform/ml/impl/session/Level;", "", "Lcom/intellij/platform/ml/Tier;", "Lcom/intellij/platform/ml/impl/LevelTiers;", "(Lcom/intellij/internal/ml/DecisionFunction;Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;Ljava/util/List;)V", "featuresTiers", "availableTiers", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/util/Set;Ljava/util/Set;Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;)V", "knownFeatures", "", "Lcom/intellij/platform/ml/impl/FeatureSelector;", "Lcom/intellij/platform/ml/PerTier;", "getKnownFeatures", "()Ljava/util/Map;", "predict", "features", "Lcom/intellij/platform/ml/Feature;", "(Ljava/util/Map;)Ljava/lang/Double;", "Companion", "DecisionFunctionWrapper", "DefaultSerialization", "FeatureNameSerialization", "SelectionMissingFeatures", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,171:1\n11065#2:172\n11400#2,2:173\n11402#2:181\n1194#3,2:175\n1222#3,4:177\n1549#3:185\n1620#3,3:186\n1179#3,2:192\n1253#3,4:194\n76#4:182\n96#4,2:183\n98#4,3:189\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel\n*L\n27#1:172\n27#1:173,2\n27#1:181\n28#1:175,2\n28#1:177,4\n42#1:185\n42#1:186,3\n43#1:192,2\n43#1:194,4\n42#1:182\n42#1:183,2\n42#1:189,3\n*E\n"})
public class RegressionModel
implements MLModel<Double> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DecisionFunction decisionFunction;
    @NotNull
    private final Set<Tier<?>> featuresTiers;
    @NotNull
    private final FeatureNameSerialization featureSerialization;
    @NotNull
    private final Map<Tier<?>, FeatureSelector> knownFeatures;

    private RegressionModel(DecisionFunction decisionFunction, Set<? extends Tier<?>> featuresTiers, Set<? extends Tier<?>> availableTiers, FeatureNameSerialization featureSerialization) {
        this.decisionFunction = decisionFunction;
        this.featuresTiers = featuresTiers;
        this.featureSerialization = featureSerialization;
        this.knownFeatures = RegressionModel.Companion.createFeatureSelectors(new DecisionFunctionWrapper(this.decisionFunction, availableTiers, this.featureSerialization), this.featuresTiers);
    }

    /*
     * WARNING - void declaration
     */
    public RegressionModel(@NotNull DecisionFunction decisionFunction, @NotNull FeatureNameSerialization featureSerialization, @NotNull List<Level<Set<Tier<?>>, Set<Tier<?>>>> sessionTiers) {
        Collection<Tier> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
        Intrinsics.checkNotNullParameter((Object)featureSerialization, (String)"featureSerialization");
        Intrinsics.checkNotNullParameter(sessionTiers, (String)"sessionTiers");
        FeatureMapper[] featureMapperArray = decisionFunction.getFeaturesOrder();
        Intrinsics.checkNotNullExpressionValue((Object)featureMapperArray, (String)"getFeaturesOrder(...)");
        Object[] objectArray = featureMapperArray;
        DecisionFunction decisionFunction2 = decisionFunction;
        RegressionModel regressionModel = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            Map map2;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            void it;
            FeatureMapper featureMapper = (FeatureMapper)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getFeatureName(), (String)"getFeatureName(...)");
            Iterable iterable = RegressionModelKt.access$flatten(sessionTiers);
            FeatureNameSerialization featureNameSerialization = featureSerialization;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var19_21 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it2;
                Tier tier = (Tier)element$iv$iv;
                map2 = destination$iv$iv2;
                boolean bl2 = false;
                map2.put(it2.getName(), element$iv$iv);
            }
            map2 = destination$iv$iv2;
            collection.add((Tier)featureNameSerialization.deserialize(string2, map2).getFirst());
        }
        collection = (List)destination$iv$iv;
        regressionModel(decisionFunction2, CollectionsKt.toSet((Iterable)collection), RegressionModelKt.access$flatten(sessionTiers), featureSerialization);
    }

    @Override
    @NotNull
    public Map<Tier<?>, FeatureSelector> getKnownFeatures() {
        return this.knownFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Double predict(@NotNull Map<Tier<?>, ? extends Set<? extends Feature>> features) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        double[] array = new double[this.decisionFunction.getFeaturesOrder().length];
        Map<Tier<?>, Set<Feature>> map2 = features;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry2 = element$iv$iv = iterator.next();
            boolean bl = false;
            Tier tier = (Tier)entry2.getKey();
            Set tierFeatures = (Set)entry2.getValue();
            Iterable $this$map$iv = tierFeatures;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Feature feature = (Feature)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)tier, (Object)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv3;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            Tier tier = (Tier)pair.component1();
            Feature feature = (Feature)pair.component2();
            pair = TuplesKt.to((Object)this.featureSerialization.serialize(tier, feature.getDeclaration().getName()), (Object)feature);
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map featurePerSerializedName = destination$iv$iv3;
        if (!Intrinsics.areEqual(features.keySet(), this.featuresTiers)) {
            boolean bl = false;
            String string2 = "Given features tiers are " + features.keySet() + ", but this model needs " + this.featuresTiers;
            throw new IllegalArgumentException(string2.toString());
        }
        int n = this.decisionFunction.getFeaturesOrder().length;
        for (int featureI = 0; featureI < n; ++featureI) {
            double featureValue;
            String featureSerializedName;
            FeatureMapper featureMapper = this.decisionFunction.getFeaturesOrder()[featureI];
            Intrinsics.checkNotNullExpressionValue((Object)featureMapper.getFeatureName(), (String)"getFeatureName(...)");
            Feature feature = (Feature)featurePerSerializedName.get(featureSerializedName);
            array[featureI] = featureValue = featureMapper.asArrayValue(feature != null ? feature.getValue() : null);
        }
        return this.decisionFunction.predict(array);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$Companion;", "", "()V", "createFeatureSelectors", "", "Lcom/intellij/platform/ml/Tier;", "Lcom/intellij/platform/ml/impl/FeatureSelector;", "Lcom/intellij/platform/ml/PerTier;", "decisionFunction", "Lcom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper;", "featuresTiers", "", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1271#2,2:172\n1285#2,4:174\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$Companion\n*L\n163#1:172,2\n163#1:174,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Tier<?>, FeatureSelector> createFeatureSelectors(DecisionFunctionWrapper decisionFunction, Set<? extends Tier<?>> featuresTiers) {
            Map<Tier<?>, Set<String>> requiredFeaturesPerTier = decisionFunction.getRequiredFeaturesPerTier();
            Iterable $this$associateWith$iv = featuresTiers;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                Tier tier = (Tier)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                createFeatureSelectors.createFeatureSelector.1 var15_15 = com.intellij.platform.ml.impl.model.RegressionModel$Companion.createFeatureSelectors$createFeatureSelector(decisionFunction, requiredFeaturesPerTier, it);
                map2.put(t, var15_15);
            }
            return result$iv;
        }

        private static final createFeatureSelectors.createFeatureSelector.1 createFeatureSelectors$createFeatureSelector(DecisionFunctionWrapper $decisionFunction, Map<Tier<?>, ? extends Set<String>> requiredFeaturesPerTier, Tier<?> tier) {
            return new FeatureSelector($decisionFunction, tier, requiredFeaturesPerTier){
                final /* synthetic */ DecisionFunctionWrapper $decisionFunction;
                final /* synthetic */ Tier<?> $tier;
                final /* synthetic */ Map<Tier<?>, Set<String>> $requiredFeaturesPerTier;
                {
                    Map<Tier<?>, Set<String>> knownFeatures;
                    this.$decisionFunction = $decisionFunction;
                    this.$tier = $tier;
                    this.$requiredFeaturesPerTier = $requiredFeaturesPerTier;
                    Map<Tier<?>, Set<String>> $this$forEach$iv = knownFeatures = $decisionFunction.getKnownFeatures();
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<Tier<?>, Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Set<String> tierFeatures;
                        Map.Entry<Tier<?>, Set<String>> element$iv;
                        Map.Entry<Tier<?>, Set<String>> entry2 = element$iv = iterator.next();
                        boolean bl = false;
                        Tier<?> tier = entry2.getKey();
                        Set<String> nonConsistentlyKnownFeatures = $decisionFunction.getUnknownFeatures(tier, tierFeatures = entry2.getValue());
                        if (nonConsistentlyKnownFeatures.isEmpty()) continue;
                        boolean bl2 = false;
                        String string2 = "These features are known and unknown at the same time: " + nonConsistentlyKnownFeatures;
                        throw new IllegalArgumentException(string2.toString());
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public FeatureSelector.Selection select(@NotNull Set<? extends FeatureDeclaration<?>> availableFeatures) {
                    Set requiredFeaturesNames;
                    void $this$mapTo$iv$iv;
                    void $this$mapTo$iv$iv2;
                    FeatureDeclaration it;
                    Object object;
                    Iterable $this$associateByTo$iv$iv;
                    Intrinsics.checkNotNullParameter(availableFeatures, (String)"availableFeatures");
                    Iterable $this$associateBy$iv = availableFeatures;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associateBy$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv : $this$associateByTo$iv$iv) {
                        FeatureDeclaration featureDeclaration = (FeatureDeclaration)element$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.put(it.getName(), element$iv$iv);
                    }
                    Map availableFeaturesPerName = destination$iv$iv;
                    Iterable $this$map$iv = availableFeatures;
                    boolean $i$f$map = false;
                    $this$associateByTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        it = (FeatureDeclaration)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.add(it.getName());
                    }
                    Set availableFeaturesNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    Set<String> unknownFeaturesNames = this.$decisionFunction.getUnknownFeatures(this.$tier, availableFeaturesNames);
                    Set knownAvailableFeaturesNames = SetsKt.minus((Set)availableFeaturesNames, (Iterable)unknownFeaturesNames);
                    Iterable $this$map$iv2 = knownAvailableFeaturesNames;
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string2 = (String)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl = false;
                        object.add((FeatureDeclaration)MapsKt.getValue((Map)availableFeaturesPerName, (Object)it2));
                    }
                    Set knownAvailableFeatures = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    Set set = this.$requiredFeaturesPerTier.get(this.$tier);
                    if (set == null) {
                        set = SetsKt.emptySet();
                    }
                    return availableFeaturesNames.containsAll(requiredFeaturesNames = set) ? (FeatureSelector.Selection)new FeatureSelector.Selection.Complete(knownAvailableFeatures) : (FeatureSelector.Selection)new SelectionMissingFeatures(knownAvailableFeatures, SetsKt.minus((Set)requiredFeaturesNames, (Iterable)availableFeaturesNames));
                }

                public boolean select(@NotNull FeatureDeclaration<?> featureDeclaration) {
                    Intrinsics.checkNotNullParameter(featureDeclaration, (String)"featureDeclaration");
                    return this.$decisionFunction.getUnknownFeatures(this.$tier, SetsKt.setOf((Object)featureDeclaration.getName())).isEmpty();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\r\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u000bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0005`\u000eJ,\u0010\u000f\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u000bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0005`\u000eJ&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0005R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "availableTiers", "", "Lcom/intellij/platform/ml/Tier;", "featureNameSerialization", "Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/util/Set;Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;)V", "availableTiersPerName", "", "", "getKnownFeatures", "Lcom/intellij/platform/ml/PerTier;", "getRequiredFeaturesPerTier", "getUnknownFeatures", "tier", "featuresNames", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1194#2,2:172\n1222#2,4:174\n1549#2:182\n1620#2,3:183\n1490#2:186\n1520#2,3:187\n1523#2,3:197\n1238#2,4:202\n1194#2,2:206\n1222#2,4:208\n1549#2:212\n1620#2,3:213\n1490#2:216\n1520#2,3:217\n1523#2,3:227\n1238#2,4:232\n1194#2,2:236\n1222#2,4:238\n1549#2:242\n1620#2,2:243\n1622#2:246\n11065#3:178\n11400#3,3:179\n372#4,7:190\n453#4:200\n403#4:201\n372#4,7:220\n453#4:230\n403#4:231\n1#5:245\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DecisionFunctionWrapper\n*L\n97#1:172,2\n97#1:174,4\n102#1:182\n102#1:183,3\n103#1:186\n103#1:187,3\n103#1:197,3\n104#1:202,4\n108#1:206,2\n108#1:208,4\n111#1:212\n111#1:213,3\n112#1:216\n112#1:217,3\n112#1:227,3\n113#1:232,4\n118#1:236,2\n118#1:238,4\n122#1:242\n122#1:243,2\n122#1:246\n100#1:178\n100#1:179,3\n103#1:190,7\n104#1:200\n104#1:201\n112#1:220,7\n113#1:230\n113#1:231\n*E\n"})
    private static final class DecisionFunctionWrapper {
        @NotNull
        private final DecisionFunction decisionFunction;
        @NotNull
        private final Set<Tier<?>> availableTiers;
        @NotNull
        private final FeatureNameSerialization featureNameSerialization;
        @NotNull
        private final Map<String, Tier<?>> availableTiersPerName;

        /*
         * WARNING - void declaration
         */
        public DecisionFunctionWrapper(@NotNull DecisionFunction decisionFunction, @NotNull Set<? extends Tier<?>> availableTiers, @NotNull FeatureNameSerialization featureNameSerialization) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter(availableTiers, (String)"availableTiers");
            Intrinsics.checkNotNullParameter((Object)featureNameSerialization, (String)"featureNameSerialization");
            this.decisionFunction = decisionFunction;
            this.availableTiers = availableTiers;
            this.featureNameSerialization = featureNameSerialization;
            Iterable iterable = this.availableTiers;
            DecisionFunctionWrapper decisionFunctionWrapper = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var7_8 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                Tier tier = (Tier)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getName(), element$iv$iv);
            }
            decisionFunctionWrapper.availableTiersPerName = destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Tier<?>, Set<String>> getKnownFeatures() {
            void $this$mapValuesTo$iv$iv;
            Object value$iv$iv$iv;
            Object $this$groupByTo$iv$iv;
            Pair it;
            Object object;
            Object $this$mapTo$iv$iv;
            FeatureMapper[] featureMapperArray = this.decisionFunction.getFeaturesOrder();
            Intrinsics.checkNotNullExpressionValue((Object)featureMapperArray, (String)"getFeaturesOrder(...)");
            Object $this$map$iv = featureMapperArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Object destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (String item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FeatureMapper featureMapper = (FeatureMapper)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it2.getFeatureName());
            }
            Set knownFeaturesSerializedNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $this$map$iv = knownFeaturesSerializedNames;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                String item$iv$iv;
                Object item$iv$iv2 = iterator.next();
                item$iv$iv = (String)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                object.add(this.featureNameSerialization.deserialize((String)it, this.availableTiersPerName));
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it3;
                Object object2;
                Object element$iv$iv = iterator.next();
                it = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$getKnownFeatures$42 = false;
                Tier key$iv$iv = (Tier)it.getFirst();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                Pair $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$getKnownFeatures$42 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                object.add((String)it3.getSecond());
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it4;
                void it$iv$iv;
                Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object3 = destination$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = object3;
                boolean bl2 = false;
                Set set = CollectionsKt.toSet((Iterable)((Iterable)it4.getValue()));
                object.put(k, set);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Tier<?>, Set<String>> getRequiredFeaturesPerTier() {
            void $this$mapValuesTo$iv$iv;
            Object value$iv$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            String it;
            Object object;
            Iterable $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = this.availableTiers;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Tier tier = (Tier)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.put(it.getName(), element$iv$iv);
            }
            Map availableTiersPerName = destination$iv$iv;
            List list2 = this.decisionFunction.getRequiredFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRequiredFeatures(...)");
            Set requiredFeaturesSerializedNames = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)list2));
            Iterable $this$map$iv = requiredFeaturesSerializedNames;
            boolean $i$f$map = false;
            $this$associateByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void serializedFeatureName;
                it = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(this.featureNameSerialization.deserialize((String)serializedFeatureName, availableTiersPerName));
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it2;
                Object object2;
                Object element$iv$iv;
                element$iv$iv = iterator.next();
                it = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$getRequiredFeaturesPerTier$42 = false;
                key$iv$iv = (Tier)it.getFirst();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                Pair $i$a$-groupBy-RegressionModel$DecisionFunctionWrapper$getRequiredFeaturesPerTier$42 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                object.add((String)it2.getSecond());
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it3;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object3 = destination$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = object3;
                boolean bl2 = false;
                Set set = CollectionsKt.toSet((Iterable)((Iterable)it3.getValue()));
                object.put(k, set);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getUnknownFeatures(@NotNull Tier<?> tier, @NotNull Set<String> featuresNames) {
            void $this$mapTo$iv$iv;
            String it;
            Object object;
            Iterable $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter(tier, (String)"tier");
            Intrinsics.checkNotNullParameter(featuresNames, (String)"featuresNames");
            Iterable iterable = featuresNames;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var7_7 = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string2 = (String)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.put(this.featureNameSerialization.serialize(tier, it), element$iv$iv);
            }
            Map featureNamePerSerializedName = destination$iv$iv;
            List list2 = this.decisionFunction.getUnknownFeatures((Collection)featureNamePerSerializedName.keySet());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getUnknownFeatures(...)");
            List unknownFeaturesSerializedNames = CollectionsKt.filterNotNull((Iterable)list2);
            Iterable $this$map$iv = unknownFeaturesSerializedNames;
            boolean $i$f$map = false;
            $this$associateByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Object v = featureNamePerSerializedName.get(it);
                if (v == null) {
                    boolean bl2 = false;
                    String string3 = "Decision function returned an unknown feature that was not given: '" + it + "'";
                    throw new IllegalArgumentException(string3.toString());
                }
                object.add((String)v);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\b2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u000bH\u0016J\u001c\u0010\f\u001a\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$DefaultSerialization;", "Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "()V", "SERIALIZED_FEATURE_SEPARATOR", "", "deserialize", "Lkotlin/Pair;", "Lcom/intellij/platform/ml/Tier;", "", "serializedFeatureName", "availableTiersPerName", "", "serialize", "tier", "featureName", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nRegressionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DefaultSerialization\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n163#2,6:172\n1#3:178\n*S KotlinDebug\n*F\n+ 1 RegressionModel.kt\ncom/intellij/platform/ml/impl/model/RegressionModel$DefaultSerialization\n*L\n73#1:172,6\n*E\n"})
    public static final class DefaultSerialization
    implements FeatureNameSerialization {
        private final char SERIALIZED_FEATURE_SEPARATOR = (char)47;

        @Override
        @NotNull
        public String serialize(@NotNull Tier<?> tier, @NotNull String featureName) {
            Intrinsics.checkNotNullParameter(tier, (String)"tier");
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            return tier.getName() + this.SERIALIZED_FEATURE_SEPARATOR + featureName;
        }

        @Override
        @NotNull
        public Pair<Tier<?>, String> deserialize(@NotNull String serializedFeatureName, @NotNull Map<String, ? extends Tier<?>> availableTiersPerName) {
            int indexOfLastSeparator;
            block4: {
                int n;
                Intrinsics.checkNotNullParameter((Object)serializedFeatureName, (String)"serializedFeatureName");
                Intrinsics.checkNotNullParameter(availableTiersPerName, (String)"availableTiersPerName");
                CharSequence $this$indexOfLast$iv = serializedFeatureName;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == this.SERIALIZED_FEATURE_SEPARATOR)) continue;
                        n = index$iv;
                        break block4;
                    } while (0 <= n2);
                }
                n = indexOfLastSeparator = -1;
            }
            if (!(indexOfLastSeparator >= 0)) {
                boolean $i$a$-require-RegressionModel$DefaultSerialization$deserialize$22 = false;
                String $i$a$-require-RegressionModel$DefaultSerialization$deserialize$22 = "Feature name '" + serializedFeatureName + "' does not contain tier's name";
                throw new IllegalArgumentException($i$a$-require-RegressionModel$DefaultSerialization$deserialize$22.toString());
            }
            String featureTierName = StringsKt.slice((String)serializedFeatureName, (IntRange)RangesKt.until((int)0, (int)indexOfLastSeparator));
            String featureName = StringsKt.slice((String)serializedFeatureName, (IntRange)RangesKt.until((int)indexOfLastSeparator, (int)serializedFeatureName.length()));
            Tier<?> tier = availableTiersPerName.get(featureTierName);
            if (tier == null) {
                boolean bl = false;
                String string2 = "Serialized feature '" + serializedFeatureName + "' has tier " + featureTierName + ", but all available tiers are " + availableTiersPerName.keySet();
                throw new IllegalArgumentException(string2.toString());
            }
            Tier<?> featureTier = tier;
            return TuplesKt.to(featureTier, (Object)featureName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\bH&J\u001c\u0010\t\u001a\u00020\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u000b\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$FeatureNameSerialization;", "", "deserialize", "Lkotlin/Pair;", "Lcom/intellij/platform/ml/Tier;", "", "serializedFeatureName", "availableTiersPerName", "", "serialize", "tier", "featureName", "intellij.platform.ml.impl"})
    public static interface FeatureNameSerialization {
        @NotNull
        public String serialize(@NotNull Tier<?> var1, @NotNull String var2);

        @NotNull
        public Pair<Tier<?>, String> deserialize(@NotNull String var1, @NotNull Map<String, ? extends Tier<?>> var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/ml/impl/model/RegressionModel$SelectionMissingFeatures;", "Lcom/intellij/platform/ml/impl/FeatureSelector$Selection$Incomplete;", "selectedFeatures", "", "Lcom/intellij/platform/ml/FeatureDeclaration;", "missingFeatures", "", "(Ljava/util/Set;Ljava/util/Set;)V", "details", "getDetails", "()Ljava/lang/String;", "intellij.platform.ml.impl"})
    public static final class SelectionMissingFeatures
    extends FeatureSelector.Selection.Incomplete {
        @NotNull
        private final String details;

        public SelectionMissingFeatures(@NotNull Set<? extends FeatureDeclaration<?>> selectedFeatures, @NotNull Set<String> missingFeatures) {
            Intrinsics.checkNotNullParameter(selectedFeatures, (String)"selectedFeatures");
            Intrinsics.checkNotNullParameter(missingFeatures, (String)"missingFeatures");
            super(selectedFeatures);
            this.details = "Regression model requires more features to run. Missing: " + missingFeatures + ", Has: " + selectedFeatures;
        }

        @Override
        @NotNull
        public String getDetails() {
            return this.details;
        }
    }
}

