/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.xml;

import com.intellij.codeInsight.completion.HtmlCompletionContributor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.xml.XmlSpellcheckingStrategy;
import com.intellij.spellchecker.xml.XmlTokenizerBase;
import com.intellij.util.SmartList;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HtmlSpellcheckingStrategy
extends XmlSpellcheckingStrategy {
    private final Tokenizer<? extends PsiElement> myDocumentTextTokenizer = this.createDocumentTextTokenizer();

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof HtmlDocumentImpl) {
            Tokenizer<? extends PsiElement> tokenizer = this.myDocumentTextTokenizer;
            if (tokenizer == null) {
                HtmlSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element instanceof XmlAttributeValue) {
            if (URLUtil.isDataUri((String)ElementManipulators.getValueText((PsiElement)element))) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    HtmlSpellcheckingStrategy.$$$reportNull$$$0(1);
                }
                return tokenizer;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute) {
                if (HtmlCompletionContributor.hasHtmlAttributesCompletion(element) && HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)parent).length > 0) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        HtmlSpellcheckingStrategy.$$$reportNull$$$0(2);
                    }
                    return tokenizer;
                }
                XmlAttributeDescriptor descriptor = ((XmlAttribute)parent).getDescriptor();
                if (descriptor != null && (descriptor.isEnumerated() || descriptor.isFixed())) {
                    Tokenizer tokenizer = EMPTY_TOKENIZER;
                    if (tokenizer == null) {
                        HtmlSpellcheckingStrategy.$$$reportNull$$$0(3);
                    }
                    return tokenizer;
                }
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            HtmlSpellcheckingStrategy.$$$reportNull$$$0(4);
        }
        return tokenizer;
    }

    @Override
    protected boolean isXmlDataCharactersParentHandled(@NotNull PsiElement parent) {
        if (parent == null) {
            HtmlSpellcheckingStrategy.$$$reportNull$$$0(5);
        }
        return super.isXmlDataCharactersParentHandled(parent) || parent instanceof HtmlDocumentImpl;
    }

    protected Tokenizer<? extends PsiElement> createDocumentTextTokenizer() {
        return new HtmlDocumentTextTokenizer(PlainTextSplitter.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/xml/HtmlSpellcheckingStrategy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/xml/HtmlSpellcheckingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isXmlDataCharactersParentHandled";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 5 -> new IllegalArgumentException(string2);
        };
    }

    protected static class HtmlDocumentTextTokenizer
    extends XmlTokenizerBase<HtmlDocumentImpl> {
        public HtmlDocumentTextTokenizer(Splitter splitter) {
            super(splitter);
        }

        @Override
        @NotNull
        protected @NotNull List<@NotNull XmlTokenizerBase.SpellcheckRange> getSpellcheckRanges(@NotNull HtmlDocumentImpl element) {
            if (element == null) {
                HtmlDocumentTextTokenizer.$$$reportNull$$$0(0);
            }
            final SmartList result2 = new SmartList();
            element.acceptChildren(new XmlElementVisitor(){

                @Override
                public void visitXmlToken(@NotNull XmlToken token) {
                    if (token == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
                        String text2 = token.getText();
                        result2.add((Object)new XmlTokenizerBase.SpellcheckRange(text2, false, token.getStartOffsetInParent(), TextRange.allOf((String)text2)));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/spellchecker/xml/HtmlSpellcheckingStrategy$HtmlDocumentTextTokenizer$1", "visitXmlToken"));
                }
            });
            SmartList smartList = result2;
            if (smartList == null) {
                HtmlDocumentTextTokenizer.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        @Override
        @NotNull
        protected @NotNull List<@NotNull TextRange> getSpellcheckOuterContentRanges(@NotNull HtmlDocumentImpl element) {
            if (element == null) {
                HtmlDocumentTextTokenizer.$$$reportNull$$$0(2);
            }
            SmartList result2 = new SmartList(super.getSpellcheckOuterContentRanges(element));
            element.acceptChildren(new XmlElementVisitor((List)result2){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list2;
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!this.isContentElement(element)) {
                        this.val$result.add(element.getTextRangeInParent());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/xml/HtmlSpellcheckingStrategy$HtmlDocumentTextTokenizer$2", "visitElement"));
                }
            });
            SmartList smartList = result2;
            if (smartList == null) {
                HtmlDocumentTextTokenizer.$$$reportNull$$$0(3);
            }
            return smartList;
        }

        protected boolean isContentElement(@NotNull PsiElement element) {
            IElementType tokenType;
            if (element == null) {
                HtmlDocumentTextTokenizer.$$$reportNull$$$0(4);
            }
            if ((tokenType = element.getNode().getElementType()) == XmlTokenType.XML_DATA_CHARACTERS || XmlTokenType.WHITESPACES.contains(tokenType)) {
                return true;
            }
            if (tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN || tokenType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                return false;
            }
            return element instanceof XmlTag || element instanceof XmlComment || element instanceof XmlProlog || element instanceof XmlProcessingInstruction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/xml/HtmlSpellcheckingStrategy$HtmlDocumentTextTokenizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/xml/HtmlSpellcheckingStrategy$HtmlDocumentTextTokenizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpellcheckRanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpellcheckOuterContentRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpellcheckRanges";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpellcheckOuterContentRanges";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isContentElement";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

