/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotateStackTraceAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(AnnotateStackTraceAction.class);
    private boolean myIsLoading = false;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            AnnotateStackTraceAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        ConsoleViewImpl consoleView;
        if (e == null) {
            AnnotateStackTraceAction.$$$reportNull$$$0(1);
        }
        Editor editor = (consoleView = (ConsoleViewImpl)ObjectUtils.tryCast((Object)e.getData(LangDataKeys.CONSOLE_VIEW), ConsoleViewImpl.class)) != null ? consoleView.getEditor() : null;
        boolean isShown = editor != null && editor.getGutter().isAnnotationsShown();
        e.getPresentation().setEnabled(editor != null && !isShown && !this.myIsLoading);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            AnnotateStackTraceAction.$$$reportNull$$$0(2);
        }
        this.myIsLoading = true;
        final Project project2 = e.getProject();
        ConsoleViewImpl consoleView = (ConsoleViewImpl)e.getData(LangDataKeys.CONSOLE_VIEW);
        Editor editor2 = editor = consoleView != null ? consoleView.getEditor() : null;
        if (project2 == null || editor == null) {
            return;
        }
        final EditorHyperlinkSupport hyperlinks = consoleView.getHyperlinks();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, LangBundle.message((String)"progress.title.getting.file.history", (Object[])new Object[0]), true){
            private final Object LOCK;
            private final MergingUpdateQueue myUpdateQueue;
            private MyActiveAnnotationGutter myGutter;
            {
                super(arg0, arg1, arg2);
                this.LOCK = new Object();
                this.myUpdateQueue = new MergingUpdateQueue("AnnotateStackTraceAction", 200, true, null);
            }

            public void onCancel() {
                editor.getGutter().closeAllAnnotations();
            }

            public void onFinished() {
                AnnotateStackTraceAction.this.myIsLoading = false;
                Disposer.dispose((Disposable)this.myUpdateQueue);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map files2lines = CollectionFactory.createSmallMemoryFootprintMap();
                Int2ObjectOpenHashMap revisions = new Int2ObjectOpenHashMap();
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int line = 0; line < editor.getDocument().getLineCount(); ++line) {
                        indicator.checkCanceled();
                        VirtualFile file = AnnotateStackTraceAction.getHyperlinkVirtualFile(hyperlinks.findAllHyperlinksOnLine(line));
                        if (file == null) continue;
                        files2lines.computeIfAbsent(file, __ -> new IntArrayList()).add(line);
                    }
                });
                for (Map.Entry entry2 : files2lines.entrySet()) {
                    VirtualFile file = (VirtualFile)entry2.getKey();
                    IntList value2 = (IntList)entry2.getValue();
                    indicator.checkCanceled();
                    LastRevision revision = this.getLastRevision(file);
                    if (revision == null) continue;
                    Object object = this.LOCK;
                    synchronized (object) {
                        IntListIterator iterator = value2.iterator();
                        while (iterator.hasNext()) {
                            revisions.put(iterator.nextInt(), (Object)revision);
                        }
                    }
                    this.myUpdateQueue.queue(new Update("update", (Int2ObjectMap)revisions){
                        final /* synthetic */ Int2ObjectMap val$revisions;
                        {
                            this.val$revisions = int2ObjectMap;
                            super(arg0);
                        }

                        public void run() {
                            this.updateGutter(indicator, (Map<Integer, LastRevision>)this.val$revisions);
                        }
                    });
                }
                ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$2(indicator, (Int2ObjectMap)revisions));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @RequiresEdt
            private void updateGutter(@NotNull ProgressIndicator indicator, @NotNull Map<Integer, LastRevision> revisions) {
                HashMap<Integer, LastRevision> revisionsCopy;
                if (indicator == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (revisions == null) {
                    1.$$$reportNull$$$0(2);
                }
                ThreadingAssertions.assertEventDispatchThread();
                if (indicator.isCanceled()) {
                    return;
                }
                if (this.myGutter == null) {
                    this.myGutter = new MyActiveAnnotationGutter(this.getProject(), hyperlinks, indicator);
                    editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.myGutter, (EditorGutterAction)this.myGutter);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    revisionsCopy = new HashMap<Integer, LastRevision>(revisions);
                }
                this.myGutter.updateData(revisionsCopy);
                ((EditorGutterComponentEx)editor.getGutter()).revalidateMarkup();
            }

            @Nullable
            private LastRevision getLastRevision(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                try {
                    AbstractVcs vcs = VcsUtil.getVcsFor(project2, file);
                    if (vcs == null) {
                        return null;
                    }
                    VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
                    if (historyProvider == null) {
                        return null;
                    }
                    FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(file);
                    if (historyProvider instanceof VcsHistoryProviderEx) {
                        VcsFileRevision revision = ((VcsHistoryProviderEx)historyProvider).getLastRevision(filePath);
                        if (revision == null) {
                            return null;
                        }
                        return LastRevision.create(revision);
                    }
                    VcsHistorySession session = historyProvider.createSessionFor(filePath);
                    if (session == null) {
                        return null;
                    }
                    List<VcsFileRevision> list2 = session.getRevisionList();
                    if (list2 == null || list2.isEmpty()) {
                        return null;
                    }
                    return LastRevision.create(list2.get(0));
                }
                catch (VcsException e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            }

            private /* synthetic */ void lambda$run$2(ProgressIndicator indicator, Int2ObjectMap revisions) {
                this.updateGutter(indicator, (Map<Integer, LastRevision>)revisions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "revisions";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateGutter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getLastRevision";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    @RequiresReadLock
    private static VirtualFile getHyperlinkVirtualFile(@NotNull List<? extends RangeHighlighter> links) {
        if (links == null) {
            AnnotateStackTraceAction.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        RangeHighlighter key2 = (RangeHighlighter)ContainerUtil.getLastItem(links);
        if (key2 == null) {
            return null;
        }
        HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo((RangeHighlighter)key2);
        if (!(info instanceof FileHyperlinkInfo)) {
            return null;
        }
        OpenFileDescriptor descriptor = ((FileHyperlinkInfo)info).getDescriptor();
        return descriptor != null ? descriptor.getFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/unscramble/AnnotateStackTraceAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "links";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkVirtualFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyActiveAnnotationGutter
    implements TextAnnotationGutterProvider,
    EditorGutterAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final EditorHyperlinkSupport myHyperlinks;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private Map<Integer, LastRevision> myRevisions;
        private Date myNewestDate;
        private int myMaxDateLength;

        MyActiveAnnotationGutter(@NotNull Project project2, @NotNull EditorHyperlinkSupport hyperlinks, @NotNull ProgressIndicator indicator) {
            if (project2 == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(0);
            }
            if (hyperlinks == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(2);
            }
            this.myRevisions = Collections.emptyMap();
            this.myNewestDate = null;
            this.myMaxDateLength = 0;
            this.myProject = project2;
            this.myHyperlinks = hyperlinks;
            this.myIndicator = indicator;
        }

        public void doAction(int lineNum) {
            LastRevision revision = this.myRevisions.get(lineNum);
            if (revision == null) {
                return;
            }
            VirtualFile file = AnnotateStackTraceAction.getHyperlinkVirtualFile(this.myHyperlinks.findAllHyperlinksOnLine(lineNum));
            if (file == null) {
                return;
            }
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(file);
            if (vcs != null) {
                VcsRevisionNumber number = revision.getNumber();
                VcsKey vcsKey = vcs.getKeyInstanceMethod();
                ShowAllAffectedGenericAction.showSubmittedFiles(this.myProject, number, file, vcsKey);
            }
        }

        public Cursor getCursor(int lineNum) {
            return this.myRevisions.containsKey(lineNum) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor();
        }

        public String getLineText(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return String.format("%" + this.myMaxDateLength + "s", FileAnnotation.formatDate(revision.getDate())) + " " + revision.getAuthor();
            }
            return "";
        }

        public String getToolTip(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return XmlStringUtil.escapeString((String)(revision.getAuthor() + " " + DateFormatUtil.formatDateTime((Date)revision.getDate()) + "\n" + VcsUtil.trimCommitMessageToSaneSize(revision.getMessage())));
            }
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            return revision != null && revision.getDate().equals(this.myNewestDate) ? EditorFontType.BOLD : EditorFontType.PLAIN;
        }

        public ColorKey getColor(int line, Editor editor) {
            return AnnotationSource.LOCAL.getColor();
        }

        public Color getBgColor(int line, Editor editor) {
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
            this.myIndicator.cancel();
        }

        @RequiresEdt
        public void updateData(@NotNull Map<Integer, LastRevision> revisions) {
            if (revisions == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(3);
            }
            ThreadingAssertions.assertEventDispatchThread();
            this.myRevisions = revisions;
            Date newestDate = null;
            int maxDateLength = 0;
            for (LastRevision revision : this.myRevisions.values()) {
                int length;
                Date date = revision.getDate();
                if (newestDate == null || date.after(newestDate)) {
                    newestDate = date;
                }
                if ((length = DateFormatUtil.formatPrettyDate((Date)date).length()) <= maxDateLength) continue;
                maxDateLength = length;
            }
            this.myNewestDate = newestDate;
            this.myMaxDateLength = maxDateLength;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlinks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisions";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction$MyActiveAnnotationGutter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LastRevision {
        @NotNull
        private final VcsRevisionNumber myNumber;
        @NotNull
        private final String myAuthor;
        @NotNull
        private final Date myDate;
        @NotNull
        private final String myMessage;

        LastRevision(@NotNull VcsRevisionNumber number, @NotNull String author, @NotNull Date date, @NotNull String message2) {
            if (number == null) {
                LastRevision.$$$reportNull$$$0(0);
            }
            if (author == null) {
                LastRevision.$$$reportNull$$$0(1);
            }
            if (date == null) {
                LastRevision.$$$reportNull$$$0(2);
            }
            if (message2 == null) {
                LastRevision.$$$reportNull$$$0(3);
            }
            this.myNumber = number;
            this.myAuthor = author;
            this.myDate = date;
            this.myMessage = message2;
        }

        @NotNull
        public static LastRevision create(@NotNull VcsFileRevision revision) {
            if (revision == null) {
                LastRevision.$$$reportNull$$$0(4);
            }
            VcsRevisionNumber number = revision.getRevisionNumber();
            String author = StringUtil.notNullize((String)revision.getAuthor(), (String)VcsBundle.message("vfs.revision.author.unknown", new Object[0]));
            Date date = revision.getRevisionDate();
            String message2 = StringUtil.notNullize((String)revision.getCommitMessage());
            return new LastRevision(number, author, date, message2);
        }

        @NotNull
        public VcsRevisionNumber getNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myNumber;
            if (vcsRevisionNumber == null) {
                LastRevision.$$$reportNull$$$0(5);
            }
            return vcsRevisionNumber;
        }

        @NotNull
        @NlsSafe
        public String getAuthor() {
            String string2 = this.myAuthor;
            if (string2 == null) {
                LastRevision.$$$reportNull$$$0(6);
            }
            return string2;
        }

        @NotNull
        public Date getDate() {
            Date date = this.myDate;
            if (date == null) {
                LastRevision.$$$reportNull$$$0(7);
            }
            return date;
        }

        @NotNull
        public String getMessage() {
            String string2 = this.myMessage;
            if (string2 == null) {
                LastRevision.$$$reportNull$$$0(8);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "number";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "date";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNumber";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6, 7, 8 -> new IllegalStateException(string2);
            };
        }
    }
}

