/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.branch;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.branch.LinkedBranchData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\f0\u0004\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0007J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/branch/BranchPresentation;", "", "()V", "getMultiTooltip", "", "branch", "Lcom/intellij/vcs/branch/BranchData;", "getPresentableText", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/Nullable;", "getSingleTooltip", "getText", "branches", "", "getTooltip", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nBranchPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchPresentation.kt\ncom/intellij/vcs/branch/BranchPresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1655#2,8:48\n1655#2,8:56\n1045#2:64\n1#3:65\n*S KotlinDebug\n*F\n+ 1 BranchPresentation.kt\ncom/intellij/vcs/branch/BranchPresentation\n*L\n11#1:48,8\n24#1:56,8\n28#1:64\n*E\n"})
public final class BranchPresentation {
    @NotNull
    public static final BranchPresentation INSTANCE = new BranchPresentation();

    private BranchPresentation() {
    }

    @Nls
    @NotNull
    public final String getText(@NotNull Collection<? extends BranchData> branches) {
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String key$iv = it.getBranchName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        return switch (distinct.size()) {
            case 0 -> "";
            case 1 -> this.getPresentableText((BranchData)CollectionsKt.first((List)distinct));
            default -> this.getPresentableText((BranchData)CollectionsKt.first((List)distinct)) + ",...";
        };
    }

    @Nls
    @NotNull
    public final String getPresentableText(@NotNull BranchData branch) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        if (branch instanceof LinkedBranchData) {
            string2 = ((LinkedBranchData)branch).getBranchName();
            if (string2 == null) {
                string2 = "!";
            }
        } else {
            string2 = branch.getBranchName();
            if (string2 == null) {
                string2 = "";
            }
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        return string3;
    }

    @Nls
    @Nullable
    public final String getTooltip(@NotNull Collection<? extends BranchData> branches) {
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            LinkedBranchData linkedBranchData = it instanceof LinkedBranchData ? (LinkedBranchData)it : null;
            Pair key$iv = TuplesKt.to((Object)it.getBranchName(), (Object)(linkedBranchData != null ? linkedBranchData.getLinkedBranchName() : null));
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        return switch (distinct.size()) {
            case 0 -> null;
            case 1 -> this.getSingleTooltip((BranchData)CollectionsKt.first((List)distinct));
            default -> {
                Iterable $this$sortedBy$iv = branches;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        BranchData it = (BranchData)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getPresentableRootName());
                        it = (BranchData)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPresentableRootName())));
                    }
                }), (CharSequence)"", null, null, (int)0, null, (Function1)getTooltip.2.INSTANCE, (int)30, null);
            }
        };
    }

    @Nls
    @Nullable
    public final String getSingleTooltip(@NotNull BranchData branch) {
        Object object;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    object = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (object == null) break block3;
                    String it = object;
                    boolean bl = false;
                    String string2 = ((LinkedBranchData)branch).getBranchName() + " " + UIUtil.rightArrow() + " " + it;
                    object = string2;
                    if (string2 != null) break block4;
                }
                String string3 = VcsBundle.message("changes.no.tracking.branch", new Object[0]);
                object = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break block4;
            }
            object = null;
        }
        return object;
    }

    @Nls
    @NotNull
    public final String getMultiTooltip(@NotNull BranchData branch) {
        Object object;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    object = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (object == null) break block3;
                    String it = object;
                    boolean bl = false;
                    String string2 = " " + UIUtil.rightArrow() + " " + it;
                    object = string2;
                    if (string2 != null) break block4;
                }
                String string3 = VcsBundle.message("changes.no.tracking.branch.suffix", new Object[0]);
                object = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break block4;
            }
            object = "";
        }
        String linkedBranchPart = object;
        return "<tr><td>" + branch.getPresentableRootName() + ":</td><td>" + this.getPresentableText(branch) + linkedBranchPart + "</td></tr>";
    }
}

